/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui.property;

import de.fabiexe.paperui.property.DialogProperty;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumProperty<T>
implements DialogProperty<T> {
    private final String key;
    private final Component label;
    private final List<T> values;
    private final Function<T, Component> nameFunction;
    private T value;

    public EnumProperty(@NotNull String key, @NotNull Component label, @NotNull T[] values2, @NotNull Function<T, Component> nameFunction, @Nullable T value) {
        this.key = key;
        this.label = label;
        this.values = List.of(values2);
        this.values.forEach(Objects::requireNonNull);
        this.nameFunction = nameFunction;
        this.value = value;
    }

    @Override
    @NotNull
    public T get() {
        if (this.value == null) {
            throw new IllegalStateException("There is no value present");
        }
        return this.value;
    }

    @Override
    public void read(@NotNull DialogResponseView response) {
        this.value = this.values.get(Integer.parseInt(response.getText(this.key).replace("enum_", "")));
    }

    @Override
    public void populate(@NotNull List<DialogInput> inputs) {
        ArrayList<SingleOptionDialogInput.OptionEntry> options = new ArrayList<SingleOptionDialogInput.OptionEntry>();
        for (int i = 0; i < this.values.size(); ++i) {
            options.add(SingleOptionDialogInput.OptionEntry.create((String)("enum_" + i), (Component)this.nameFunction.apply(this.values.get(i)), (boolean)this.values.get(i).equals(this.value)));
        }
        inputs.add((DialogInput)DialogInput.singleOption((String)this.key, (Component)this.label, options).build());
    }
}

