/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui.property;

import de.fabiexe.paperui.property.DialogProperty;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerProperty
implements DialogProperty<Integer> {
    private final String key;
    private final Component label;
    private final int min;
    private final int max;
    private Integer value;

    public IntegerProperty(@NotNull String key, @NotNull Component label, int min, int max, @Nullable Integer value) {
        this.key = key;
        this.label = label;
        this.min = min;
        this.max = max;
        this.value = value;
    }

    @Override
    @NotNull
    public Integer get() {
        if (this.value == null) {
            throw new IllegalStateException("There is no value present");
        }
        return this.value;
    }

    @Override
    public void read(@NotNull DialogResponseView response) {
        this.value = Math.round(Math.max((float)this.min, Math.min(response.getFloat(this.key).floatValue(), (float)this.max)));
    }

    @Override
    public void populate(@NotNull List<DialogInput> inputs) {
        NumberRangeDialogInput.Builder builder = DialogInput.numberRange((String)this.key, (Component)this.label, (float)this.min, (float)this.max).step(Float.valueOf(1.0f));
        if (this.value == null) {
            builder.initial(Float.valueOf(this.min));
        } else {
            builder.initial(Float.valueOf(this.value.floatValue()));
        }
        inputs.add((DialogInput)builder.build());
    }
}

