/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui.test;

import de.fabiexe.paperui.DialogUI;
import de.fabiexe.paperui.property.Property;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class OrderCoffeeUI
extends DialogUI<Audience> {
    private final Property<CoffeeType> type;
    private final Property<Double> size;
    private final Property<Boolean> milk;
    private final Property<Integer> amount;
    private final Property<String> address;

    public OrderCoffeeUI(@NotNull Audience audience) {
        super(audience);
        this.title("Order a Coffee");
        this.type = this.enumProperty("Type", CoffeeType.class);
        this.size = this.doubleProperty("Size (liters)", 0.25, 1.0, 0.33);
        this.milk = this.booleanProperty("Add milk");
        this.amount = this.integerProperty("Amount", 1, 10);
        this.address = this.stringProperty("Address");
        this.actionButton("Order", this::order);
        this.actionButton("Cancel");
    }

    private void order() {
        String coffee = String.valueOf((Object)this.type.get()) + " with size " + String.valueOf(this.size.get()) + "l";
        if (this.milk.get().booleanValue()) {
            coffee = coffee + " with milk";
        }
        this.audience.sendMessage((Component)Component.text((String)("We will deliver " + String.valueOf(this.amount.get()) + " " + coffee + " to " + this.address.get())));
    }

    private static enum CoffeeType {
        COFFEE,
        ESPRESSO,
        CHOCOLATE_COFFEE,
        DOUBLE_CHOCOLATE_COFFEE;

    }
}

