/*
 * Decompiled with CFR 0.152.
 */
package de.fabia.servermonitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sun.management.OperatingSystemMXBean;
import com.sun.net.httpserver.HttpServer;
import de.fabia.servermonitor.Config;
import de.fabia.servermonitor.Localization;
import de.fabia.servermonitor.OnlinePeriod;
import de.fabia.servermonitor.PlayerData;
import de.fabia.servermonitor.ServerSnapshot;
import de.fabia.servermonitor.WebHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerMonitorMod
implements ModInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path MOD_DATA_DIR = FabricLoader.getInstance().getConfigDir().resolve("servermonitor");
    private static final Path CONFIG_PATH = MOD_DATA_DIR.resolve("servermonitor.json");
    private static final Path PLAYER_DATA_PATH = MOD_DATA_DIR.resolve("playerdata.json");
    public static Config config;
    private static HttpServer httpServer;
    private static MinecraftServer minecraftServer;
    private static ScheduledExecutorService scheduler;
    private static Map<String, PlayerData> playerData;
    private static Map<String, Long> currentJoinTimes;
    private static Map<String, double[]> lastPositions;
    private static LocalDate lastDay;
    private static final Deque<ServerSnapshot> historicalData;
    private static final long HISTORY_DURATION_MS = 300000L;
    private static long lastPlayerDataSave;

    public void onInitialize() {
        ServerMonitorMod.loadConfig();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            minecraftServer = server;
            ServerMonitorMod.loadPlayerData();
            if (ServerMonitorMod.config.enableWebServer) {
                ServerMonitorMod.startWebServer();
            }
            ServerMonitorMod.startDataScheduler();
            ServerMonitorMod.registerPlayerEvents();
            ServerTickEvents.START_SERVER_TICK.register(tickServer -> {
                if (minecraftServer == null) {
                    return;
                }
                for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                    String playerName = player.method_5477().getString();
                    double[] currentPos = new double[]{player.method_23317(), player.method_23318(), player.method_23321()};
                    double[] lastPos = lastPositions.get(playerName);
                    if (lastPos != null && currentPos[0] == lastPos[0] && currentPos[1] == lastPos[1] && currentPos[2] == lastPos[2]) continue;
                    PlayerData data = playerData.computeIfAbsent(playerName, k -> new PlayerData());
                    data.lastMovementTime = System.currentTimeMillis();
                    data.isAfk = false;
                    lastPositions.put(playerName, currentPos);
                }
            });
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            long stopTime = System.currentTimeMillis();
            for (Map.Entry<String, Long> entry : currentJoinTimes.entrySet()) {
                ServerMonitorMod.handlePlayerLeave(entry.getKey(), stopTime);
            }
            currentJoinTimes.clear();
            ServerMonitorMod.savePlayerData();
            if (httpServer != null) {
                httpServer.stop(0);
                httpServer = null;
            }
            if (scheduler != null && !scheduler.isShutdown()) {
                scheduler.shutdown();
            }
        });
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"serverstats").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)Localization.getFormatted("command.feedback", ServerMonitorMod.config.webPort)), false);
            return 1;
        }));
    }

    private static double getTPS(MinecraftServer server) {
        double avgTickTime = server.method_54832();
        return avgTickTime > 0.0 ? Math.min(1000.0 / avgTickTime, 20.0) : 20.0;
    }

    private static void startDataScheduler() {
        scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            if (minecraftServer == null) {
                return;
            }
            try {
                OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                double cpuLoad = osBean.getSystemCpuLoad() * 100.0;
                if (Double.isNaN(cpuLoad) || cpuLoad < 0.0) {
                    cpuLoad = 0.0;
                }
                ServerSnapshot snapshot = new ServerSnapshot(System.currentTimeMillis(), ServerMonitorMod.getTPS(minecraftServer), minecraftServer.method_54832(), Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory(), Runtime.getRuntime().maxMemory(), cpuLoad, Runtime.getRuntime().availableProcessors(), minecraftServer.method_3788(), minecraftServer.method_3802(), minecraftServer.method_3780() / 20);
                historicalData.add(snapshot);
                long cutoff = System.currentTimeMillis() - 300000L;
                while (!historicalData.isEmpty() && ServerMonitorMod.historicalData.peek().timestamp < cutoff) {
                    historicalData.poll();
                }
                long now = System.currentTimeMillis();
                for (Map.Entry<String, PlayerData> entry : playerData.entrySet()) {
                    String playerName = entry.getKey();
                    PlayerData data = entry.getValue();
                    if (currentJoinTimes.containsKey(playerName)) {
                        boolean shouldBeAfk = now - data.lastMovementTime > (long)(ServerMonitorMod.config.afkTimeoutMinutes * 60) * 1000L;
                        if (shouldBeAfk == data.isAfk) continue;
                        data.isAfk = shouldBeAfk;
                        continue;
                    }
                    data.isAfk = false;
                }
                if (System.currentTimeMillis() - lastPlayerDataSave > 300000L) {
                    ServerMonitorMod.savePlayerData();
                    lastPlayerDataSave = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                System.err.println("Error capturing server stats: " + e.getMessage());
            }
        }, 0L, ServerMonitorMod.config.updateIntervalSeconds, TimeUnit.SECONDS);
    }

    private static void loadConfig() {
        block12: {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                        config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    }
                    if (config == null) {
                        config = new Config();
                    }
                    if (ServerMonitorMod.config.language == null || !ServerMonitorMod.config.language.equals("de") && !ServerMonitorMod.config.language.equals("en")) {
                        ServerMonitorMod.config.language = "en";
                    }
                    ServerMonitorMod.saveConfig();
                    break block12;
                }
                config = new Config();
                ServerMonitorMod.saveConfig();
            }
            catch (Exception e) {
                System.err.println("Error loading config: " + e.getMessage());
                config = new Config();
            }
        }
    }

    private static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("Error saving config: " + e.getMessage());
        }
    }

    private static void loadPlayerData() {
        block9: {
            try {
                if (!Files.exists(PLAYER_DATA_PATH, new LinkOption[0])) break block9;
                try (BufferedReader reader = Files.newBufferedReader(PLAYER_DATA_PATH);){
                    Type type = new TypeToken<Map<String, PlayerData>>(){}.getType();
                    Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                    if (loaded != null) {
                        playerData.putAll(loaded);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error loading player data: " + e.getMessage());
            }
        }
    }

    private static synchronized void savePlayerData() {
        try {
            Files.createDirectories(PLAYER_DATA_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(PLAYER_DATA_PATH, new OpenOption[0]);){
                GSON.toJson(playerData, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("Error saving player data: " + e.getMessage());
        }
    }

    private static void registerPlayerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ServerMonitorMod.handlePlayerJoin(handler.field_14140.method_5477().getString()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerMonitorMod.handlePlayerLeave(handler.field_14140.method_5477().getString(), System.currentTimeMillis()));
    }

    private static void handlePlayerJoin(String playerName) {
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        if (!today.equals(lastDay)) {
            for (PlayerData data : playerData.values()) {
                data.yesterdayPlaytimeMs = data.todayPlaytimeMs;
                data.todayPlaytimeMs = 0L;
            }
            lastDay = today;
        }
        currentJoinTimes.put(playerName, System.currentTimeMillis());
        PlayerData data = playerData.computeIfAbsent(playerName, k -> new PlayerData());
        data.lastMovementTime = System.currentTimeMillis();
        data.isAfk = false;
    }

    private static void handlePlayerLeave(String playerName, long leaveTime) {
        Long joinTime = currentJoinTimes.remove(playerName);
        if (joinTime != null) {
            long duration = leaveTime - joinTime;
            PlayerData data = playerData.computeIfAbsent(playerName, k -> new PlayerData());
            data.totalPlaytimeMs += duration;
            data.todayPlaytimeMs += duration;
            data.periods.add(new OnlinePeriod(joinTime, leaveTime));
            long thirtyDaysAgo = System.currentTimeMillis() - 2592000000L;
            data.periods.removeIf(p -> p.end < thirtyDaysAgo);
        }
    }

    private static void startWebServer() {
        try {
            httpServer = HttpServer.create(new InetSocketAddress(ServerMonitorMod.config.webPort), 0);
            httpServer.createContext("/", new WebHandler());
            httpServer.setExecutor(Executors.newFixedThreadPool(4));
            httpServer.start();
            System.out.println("Server Monitor Webserver started on port " + ServerMonitorMod.config.webPort);
        }
        catch (Exception e) {
            System.err.println("Error starting web server: " + e.getMessage());
        }
    }

    public static String getHistoricalStatsJson() {
        return GSON.toJson(historicalData);
    }

    public static String getLatestStatsJson() {
        return historicalData.isEmpty() ? "{}" : GSON.toJson((Object)historicalData.peekLast());
    }

    public static String getServerPlayersJson() {
        if (minecraftServer == null) {
            return "[]";
        }
        List players = minecraftServer.method_3760().method_14571();
        return "[" + players.stream().map(player -> {
            String playerName = player.method_5477().getString();
            PlayerData data = playerData.getOrDefault(playerName, new PlayerData());
            long currentSessionMs = currentJoinTimes.getOrDefault(playerName, 0L) > 0L ? System.currentTimeMillis() - currentJoinTimes.get(playerName) : 0L;
            long todayMinutes = (data.todayPlaytimeMs + currentSessionMs) / 60000L;
            long yesterdayMinutes = data.yesterdayPlaytimeMs / 60000L;
            long totalMinutes = (data.totalPlaytimeMs + currentSessionMs) / 60000L;
            String periodsJson = data.periods.stream().map(p -> String.format("{\"start\":%d,\"end\":%d}", p.start, p.end)).collect(Collectors.joining(","));
            return String.format("{\"name\":\"%s\",\"ping\":%d,\"todayMinutes\":%d,\"yesterdayMinutes\":%d,\"totalMinutes\":%d,\"afk\":%b,\"periods\":[%s]}", GSON.toJson((Object)playerName).replaceAll("^\"|\"$", ""), player.field_13987.method_52405(), todayMinutes, yesterdayMinutes, totalMinutes, data.isAfk, periodsJson);
        }).collect(Collectors.joining(",")) + "]";
    }

    public static String generateHtmlPage() {
        String translationsJson = GSON.toJson(Localization.getJsTranslations());
        String locale = ServerMonitorMod.config.language.equals("de") ? "de-DE" : "en-US";
        return "<!DOCTYPE html><html lang=\"" + ServerMonitorMod.config.language + "\"><head><meta charset=\"UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">" + "<title>" + ServerMonitorMod.config.webTitle + "</title>" + "<script src=\"https://cdn.tailwindcss.com\"></script><script src=\"https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js\"></script><link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css\">" + "<style>body{font-family:'Inter',sans-serif;transition:background-color .5s} @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap'); body.modern{background-color:#111827;color:#e5e7eb} .chart-container{position:relative;height:300px;width:100%} .modern #player-modal{backdrop-filter:blur(5px)} #player-modal{transition:opacity .3s ease} #player-modal-content{transition:transform .3s ease,opacity .3s ease} #theme-toggle{z-index:99;position:fixed;top:1rem;right:1rem;cursor:pointer;padding:.5rem;border-radius:.5rem;transition:all .2s} .modern #theme-toggle{background-color:#374151;color:#e5e7eb} .modern #theme-toggle:hover{background-color:#4b5563} body.retro{font-family:Tahoma,Verdana,sans-serif;background:#3A6EA5;color:#000} .retro #theme-toggle{background:#ECE9D8;border:2px outset #fff;color:#000} .retro .main-container{background:#ECE9D8;border:2px outset #fff;padding:2px;margin-top:2rem} .retro .title-bar{background:linear-gradient(to right,#0A246A,#A6CAF0);color:white;padding:3px 5px;font-weight:bold;text-shadow:1px 1px #000} .retro h1.title-bar{font-size:1.1rem;margin-bottom:0} .retro .content-area{padding:1rem} .retro .stat-card,.retro .chart-window,.retro .player-card{background:#ECE9D8;border:2px outset #fff;padding:5px;transform:none!important} .retro .stat-card:hover{background:#f5f4f2} .retro .stat-card h3{font-size:1.5rem;font-weight:normal} .retro .stat-card p{font-size:.75rem} .retro .chart-window{padding:2px} .retro .chart-window .title-bar{font-size:.9rem} .retro #player-modal{background:rgba(0,0,0,.3);backdrop-filter:none} .retro #player-modal-content{background:#ECE9D8;border:2px outset #fff;padding:2px;transform:none!important;opacity:1!important;box-shadow:5px 5px 10px rgba(0,0,0,.5)} .retro #player-modal-content .title-bar{display:flex;justify-content:space-between;align-items:center} .retro .xp-close-btn{background:#E14739;color:white;font-weight:bold;border:1px outset #fff;width:20px;height:20px;display:flex;align-items:center;justify-content:center;font-family:'Courier New',monospace} .retro .player-card{border:1px solid #aaa;margin-bottom:5px}</style></head>" + "<body class=\"modern\"><div id=\"theme-toggle\" onclick=\"toggleTheme()\"><i class=\"fas fa-desktop\"></i></div><div class=\"main-container container mx-auto p-4 sm:p-6 lg:p-8\">" + "<h1 id=\"main-title\" class=\"title-bar text-3xl font-bold mb-6 text-center\"></h1><div class=\"content-area\"><div id=\"stats-grid\" class=\"grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6 mb-8\"></div>" + "<div id=\"charts-grid\" class=\"grid grid-cols-1 lg:grid-cols-2 gap-6\"><div class=\"chart-window bg-gray-800 p-4 rounded-lg shadow-lg\"><div class=\"chart-container\"><canvas id=\"tpsChart\"></canvas></div></div><div class=\"chart-window bg-gray-800 p-4 rounded-lg shadow-lg\"><div class=\"chart-container\"><canvas id=\"ramChart\"></canvas></div></div><div class=\"chart-window bg-gray-800 p-4 rounded-lg shadow-lg\"><div class=\"chart-container\"><canvas id=\"cpuChart\"></canvas></div></div><div class=\"chart-window bg-gray-800 p-4 rounded-lg shadow-lg\"><div class=\"chart-container\"><canvas id=\"playersChart\"></canvas></div></div></div></div></div>" + "<div id=\"player-modal\" class=\"fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center hidden opacity-0\" onclick=\"closePlayersModal()\"><div id=\"player-modal-content\" class=\"bg-gray-800 rounded-lg shadow-xl w-full max-w-4xl transform scale-95 opacity-0\" onclick=\"event.stopPropagation()\"><div class=\"title-bar flex justify-between items-center p-4 border-b border-gray-700\"><h2 id=\"player-modal-title\" class=\"text-xl font-bold\"></h2><button class=\"xp-close-btn text-gray-400 hover:text-white text-2xl\" onclick=\"closePlayersModal()\"><i class=\"fas fa-times\"></i></button></div><div class=\"content-area p-6\"><div id=\"player-list\" class=\"grid grid-cols-1 md:grid-cols-2 gap-4 max-h-[60vh] overflow-y-auto p-1\"></div></div></div></div>" + "<script>const I18N = " + translationsJson + "; const LOCALE = '" + locale + "'; let lastData={}; let playerUpdateInterval=null; const chartInstances={}; const chartData={labels:[],datasets:{tps:[],ram:[],cpu:[],players:[]}}; const MAX_DATA_POINTS=60;" + "function createChart(c,l,d,b,a,isRetro){const ctx=document.getElementById(c).getContext('2d');const labelColor=isRetro?'#000':'#FFF';const gridColor=isRetro?'rgba(0,0,0,0.1)':'rgba(255,255,255,0.1)';const tickColor=isRetro?'#333':'#9CA3AF';return new Chart(ctx,{type:'line',data:{labels:chartData.labels,datasets:[{label:l,data:d,borderColor:b,backgroundColor:a,fill:true}]},options:{responsive:true,maintainAspectRatio:false,plugins:{legend:{display:false},title:{display:true,text:isRetro?'':l,color:labelColor,font:{size:16}}},scales:{x:{ticks:{color:tickColor},grid:{color:gridColor}},y:{beginAtZero:true,ticks:{color:tickColor},grid:{color:gridColor}}},interaction:{intersect:false,mode:'index'},elements:{point:{radius:0},line:{tension:0.3}}}})}" + "function initCharts(isRetro){Object.values(chartInstances).forEach(c=>c.destroy());if(isRetro){document.querySelectorAll('.chart-window').forEach(w=>{const title=I18N[`chart.${w.querySelector('canvas').id.replace('Chart','')}.title`];if(!w.querySelector('.title-bar')){w.insertAdjacentHTML('afterbegin',`<div class=\"title-bar\">${title}</div>`);}});document.querySelectorAll('.modern .p-4').forEach(e=>e.classList.remove('p-4'));}chartInstances.tps=createChart('tpsChart',I18N['chart.tps.title'],chartData.datasets.tps,'#22C55E','rgba(34,197,94,0.2)',isRetro);chartInstances.ram=createChart('ramChart',I18N['chart.ram.title'],chartData.datasets.ram,'#3B82F6','rgba(59,130,246,0.2)',isRetro);chartInstances.cpu=createChart('cpuChart',I18N['chart.cpu.title'],chartData.datasets.cpu,'#F97316','rgba(249,115,22,0.2)',isRetro);chartInstances.players=createChart('playersChart',I18N['chart.players.title'],chartData.datasets.players,'#8B5CF6','rgba(139,92,246,0.2)',isRetro);}" + "function formatUptime(s){const d=Math.floor(s/86400),h=Math.floor((s%86400)/3600),m=Math.floor((s%3600)/60);return`${d}d ${h}h ${m}m`;}" + "function formatTime(min){if(isNaN(min)||min<0)return '0m';const h=Math.floor(min/60),m=min%60;let r='';if(h>0){r+=h+'h ';}r+=m+'m';return r;}" + "function renderStatCard(icon,title,value,sub,progress,color,onClick){const isRetro=document.body.classList.contains('retro'); const cardClasses=isRetro?'stat-card':'bg-gray-800 p-5 rounded-lg shadow-lg flex flex-col justify-between transform transition-transform hover:scale-105'; const onClickAttr=onClick?`onclick=\"${onClick}\"`:''; return`<div class=\"${cardClasses} ${onClick?'cursor-pointer':''}\" ${onClickAttr}><div><div class=\"flex items-center justify-between mb-2\"><p class=\"${isRetro?'':'text-sm text-gray-400'}\">${title}</p><i class=\"${icon} ${isRetro?'':color}\"></i></div><h3 class=\"${isRetro?'':'text-2xl font-bold text-white'}\">${value}</h3><p class=\"${isRetro?'':'text-xs text-gray-500'}\">${sub}</p></div>${progress!==null&&!isRetro?`<div class=\"w-full bg-gray-700 rounded-full h-2 mt-4\"><div class=\"${color.replace('text-','bg-')} h-2 rounded-full\" style=\"width:${progress}%\"></div></div>`:''}</div>`;}" + "function updateStatCards(data){if(!data||!data.tps)return;lastData=data;const grid=document.getElementById('stats-grid');grid.innerHTML=renderStatCard('fa fa-tachometer-alt',I18N['stat.tps.title'],`${data.tps.toFixed(2)}`,I18N['stat.tps.subtitle'].replace('%.1f',data.avgTickTime.toFixed(1)),(data.tps/20)*100,'text-green-400',null)+renderStatCard('fa fa-memory',I18N['stat.ram.title'],`${(data.ramUsed/1048576).toFixed(0)} MB`,I18N['stat.ram.subtitle'].replace('%d',(data.ramMax/1048576).toFixed(0)),(data.ramUsed/data.ramMax)*100,'text-blue-400',null)+renderStatCard('fa fa-microchip',I18N['stat.cpu.title'],`${data.cpuLoad.toFixed(1)}%`,I18N['stat.cpu.subtitle'].replace('%d',data.cpuCores),data.cpuLoad,'text-orange-400',null)+renderStatCard('fa fa-users',I18N['stat.players.title'],`${data.players} / ${data.maxPlayers}`,I18N['stat.players.subtitle'],(data.players/data.maxPlayers)*100,'text-purple-400','openPlayersModal()')+renderStatCard('fa fa-clock',I18N['stat.uptime.title'],`${formatUptime(data.uptimeSeconds)}`,I18N['stat.uptime.subtitle'],null,'text-cyan-400',null);}" + "async function loadInitialHistory(){try{const res=await fetch('/api/history');if(!res.ok)return;const history=await res.json();chartData.labels.length=0;Object.values(chartData.datasets).forEach(d=>d.length=0);history.forEach(s=>{chartData.labels.push(new Date(s.timestamp).toLocaleTimeString(LOCALE));chartData.datasets.tps.push(s.tps.toFixed(2));chartData.datasets.ram.push((s.ramUsed/1048576).toFixed(1));chartData.datasets.cpu.push(s.cpuLoad.toFixed(1));chartData.datasets.players.push(s.players);});if(history.length>0){updateStatCards(history[history.length-1]);}}catch(e){console.error('Error:',e);}finally{Object.values(chartInstances).forEach(c=>c.update());}}" + "async function updateStats(){try{const res=await fetch('/api/stats');if(!res.ok)return;const data=await res.json();if(!data.timestamp)return;chartData.labels.push(new Date(data.timestamp).toLocaleTimeString(LOCALE));chartData.datasets.tps.push(data.tps.toFixed(2));chartData.datasets.ram.push((data.ramUsed/1048576).toFixed(1));chartData.datasets.cpu.push(data.cpuLoad.toFixed(1));chartData.datasets.players.push(data.players);if(chartData.labels.length>MAX_DATA_POINTS){chartData.labels.shift();Object.values(chartData.datasets).forEach(d=>d.shift());}Object.values(chartInstances).forEach(c=>c.update());updateStatCards(data);}catch(e){console.error('Error:',e);}}" + "function closePlayersModal(){if(playerUpdateInterval)clearInterval(playerUpdateInterval);playerUpdateInterval=null;const modal=document.getElementById('player-modal');const content=document.getElementById('player-modal-content');modal.classList.add('opacity-0');if(document.body.classList.contains('modern')){content.classList.add('scale-95','opacity-0');}setTimeout(()=>modal.classList.add('hidden'),300);}" + "async function refreshPlayers(){try{const res=await fetch('/api/players');const players=await res.json();const isRetro=document.body.classList.contains('retro');const list=document.getElementById('player-list');if(players.length===0){list.innerHTML=`<div class=\"col-span-full text-center py-4\">${I18N['modal.players.none']}</div>`;return;}list.innerHTML=players.map(p=>{const displayPing=p.ping===0?'< 1':p.ping;const cardClasses=isRetro?'player-card':'player-card bg-gray-700/50 p-4 rounded-md';const textColor=isRetro?'':'text-white';const subTextColor=isRetro?'':'text-gray-400';const pingColor=isRetro?'':(p.ping<80?'text-green-400':p.ping<150?'text-yellow-400':'text-red-400');return `<div class=\"${cardClasses} flex flex-col\"><div class=\"flex justify-between items-start mb-2\"><div class=\"flex items-center\"><img src=\"https://cravatar.eu/helmavatar/${p.name}/32.png\" class=\"w-8 h-8 rounded-md mr-3\"/><div><span class=\"font-semibold ${textColor}\">${p.name}</span><br><span class=\"text-sm ${subTextColor}\">${I18N['player.card.today']}: ${formatTime(p.todayMinutes)} | ${I18N['player.card.yesterday']}: ${formatTime(p.yesterdayMinutes)} | ${I18N['player.card.total']}: ${formatTime(p.totalMinutes)}</span></div></div><span class=\"font-mono ${pingColor}\">${displayPing} ms</span></div><div class=\"chart-container flex-grow\" style=\"height:150px;\"><canvas id=\"chart-${p.name}\"></canvas></div></div>`;}).join('');setTimeout(()=>{players.forEach(p=>{const ctx=document.getElementById(`chart-${p.name}`);if(!ctx)return;const now=new Date();const daysToShow=7;const labels=[];const hours=Array(daysToShow).fill(0);const todayStart=new Date();todayStart.setHours(0,0,0,0);for(let i=daysToShow-1;i>=0;i--){const d=new Date(now);d.setDate(d.getDate()-i);labels.push(d.toLocaleDateString(LOCALE,{weekday:'short'}));}p.periods.forEach(period=>{const start=new Date(period.start);if(start.getTime()<todayStart.getTime()){const diffDays=Math.floor((now-start)/(1000*60*60*24));if(diffDays>0&&diffDays<daysToShow){const index=daysToShow-1-diffDays;hours[index]+=(period.end-period.start)/3600000;}}});hours[daysToShow-1]=p.todayMinutes/60.0;new Chart(ctx.getContext('2d'),{type:'bar',data:{labels:labels,datasets:[{label:I18N['player.chart.hours'],data:hours,backgroundColor:isRetro?'#3B82F6':'rgba(139,92,246,0.6)',borderColor:isRetro?'#0A246A':'#8B5CF6',borderWidth:1}]},options:{responsive:true,maintainAspectRatio:false,plugins:{legend:{display:false}},scales:{y:{beginAtZero:true,ticks:{color:isRetro?'#333':'#9CA3AF',callback:function(value){if(value===0)return '0m';const h=Math.floor(value);const m=Math.round((value-h)*60);let l='';if(h>0)l+=h+'h ';if(m>0)l+=m+'m';return l.trim();}}},x:{ticks:{color:isRetro?'#333':'#9CA3AF'}}}}})});},100);}catch(e){console.error(e);document.getElementById('player-list').innerHTML=`<div class=\"col-span-full text-red-400 text-center py-4\">${I18N['modal.players.error']}</div>`;}}" + "function openPlayersModal(){if(playerUpdateInterval)clearInterval(playerUpdateInterval);const modal=document.getElementById('player-modal');const content=document.getElementById('player-modal-content');const list=document.getElementById('player-list');list.innerHTML=`<div class=\"col-span-full text-center\"><i class=\"fas fa-spinner fa-spin\"></i> ${I18N['modal.players.loading']}</div>`;modal.classList.remove('hidden');setTimeout(()=>{modal.classList.remove('opacity-0');if(document.body.classList.contains('modern')){content.classList.remove('scale-95','opacity-0');}},10);refreshPlayers();playerUpdateInterval=setInterval(refreshPlayers,5000);}" + "function toggleTheme(){const body=document.body;body.classList.toggle('retro');body.classList.toggle('modern');const isRetro=body.classList.contains('retro');localStorage.setItem('theme',isRetro?'retro':'modern');document.querySelectorAll('.chart-window .title-bar').forEach(e=>e.remove());initCharts(isRetro);if(lastData.tps){updateStatCards(lastData);}const toggleIcon=document.getElementById('theme-toggle').querySelector('i');toggleIcon.className=isRetro?'fas fa-paint-roller':'fas fa-desktop';}" + "function loadTheme(){const theme=localStorage.getItem('theme');if(theme==='retro'){document.body.classList.add('retro');document.body.classList.remove('modern');}else{document.body.classList.add('modern');document.body.classList.remove('retro');}const isRetro=document.body.classList.contains('retro');document.getElementById('theme-toggle').querySelector('i').className=isRetro?'fas fa-paint-roller':'fas fa-desktop';}" + "function applyTranslations(){document.getElementById('main-title').textContent=I18N['web.header']; document.getElementById('player-modal-title').textContent=I18N['modal.players.title'];}" + "async function init(){loadTheme();initCharts(document.body.classList.contains('retro'));applyTranslations();document.getElementById('stats-grid').innerHTML=`<div class=\"col-span-full text-center p-4\">${I18N['page.loading']}</div>`;await loadInitialHistory();setInterval(updateStats," + ServerMonitorMod.config.updateIntervalSeconds * 1000 + ");}document.addEventListener('DOMContentLoaded',init);" + "</script></body></html>";
    }

    static {
        playerData = new ConcurrentHashMap<String, PlayerData>();
        currentJoinTimes = new ConcurrentHashMap<String, Long>();
        lastPositions = new ConcurrentHashMap<String, double[]>();
        lastDay = LocalDate.now(ZoneId.systemDefault());
        historicalData = new ConcurrentLinkedDeque<ServerSnapshot>();
        lastPlayerDataSave = 0L;
    }
}

