/*
 * Decompiled with CFR 0.152.
 */
package de.fabia.servermonitor;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.fabia.servermonitor.ServerMonitorMod;
import java.io.IOException;
import java.io.OutputStream;

public class WebHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String path;
        switch (path = exchange.getRequestURI().getPath()) {
            case "/api/history": {
                this.handleApiRequest(exchange, ServerMonitorMod.getHistoricalStatsJson());
                break;
            }
            case "/api/stats": {
                this.handleApiRequest(exchange, ServerMonitorMod.getLatestStatsJson());
                break;
            }
            case "/api/players": {
                this.handleApiRequest(exchange, ServerMonitorMod.getServerPlayersJson());
                break;
            }
            default: {
                this.handleHtmlRequest(exchange);
            }
        }
    }

    private void handleApiRequest(HttpExchange e, String json) throws IOException {
        e.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        e.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
        byte[] response = json.getBytes("UTF-8");
        e.sendResponseHeaders(200, response.length);
        try (OutputStream os = e.getResponseBody();){
            os.write(response);
        }
    }

    private void handleHtmlRequest(HttpExchange e) throws IOException {
        byte[] response = ServerMonitorMod.generateHtmlPage().getBytes("UTF-8");
        e.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        e.sendResponseHeaders(200, response.length);
        try (OutputStream os = e.getResponseBody();){
            os.write(response);
        }
    }
}

