/*
 * Decompiled with CFR 0.152.
 */
package com.servermonitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.servermonitor.MainMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerMonitorConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "servermonitor", "config.json");
    public static final Path DATA_DIR = Paths.get("config", "servermonitor", "data");
    public String language = "en";
    public boolean webServerEnabled = true;
    public int webServerPort = 8080;
    public String webServerHost = "0.0.0.0";
    public String adminUsername = "server";
    public String adminPassword = "monitor";
    public int sessionTimeoutMinutes = 30;
    public int updateIntervalSeconds = 5;
    public boolean overviewAdminOnly = true;
    public boolean tpsAdminOnly = true;
    public boolean cpuAdminOnly = true;
    public boolean ramAdminOnly = true;
    public boolean storageAdminOnly = true;
    public boolean playersAdminOnly = true;
    public boolean uptimeAdminOnly = true;
    public List<String> dashboardLayout = new ArrayList<String>();
    public Map<String, Map<String, Boolean>> widgetConfigs = new HashMap<String, Map<String, Boolean>>();

    public ServerMonitorConfig() {
        if (this.dashboardLayout.isEmpty()) {
            this.dashboardLayout.add("tps_card");
            this.dashboardLayout.add("cpu_card");
            this.dashboardLayout.add("ram_card");
            this.dashboardLayout.add("players_card");
            this.dashboardLayout.add("uptime_card");
            this.dashboardLayout.add("custom_graph");
            this.dashboardLayout.add("storage_pie");
            this.dashboardLayout.add("storage_graph");
            while (this.dashboardLayout.size() < 32) {
                this.dashboardLayout.add("empty");
            }
        }
        if (!this.widgetConfigs.containsKey("custom_graph")) {
            HashMap<String, Boolean> defaults = new HashMap<String, Boolean>();
            defaults.put("tps", true);
            defaults.put("cpu", true);
            defaults.put("ram", true);
            defaults.put("players", true);
            this.widgetConfigs.put("custom_graph", defaults);
        }
    }

    public static ServerMonitorConfig load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                ServerMonitorConfig config = (ServerMonitorConfig)GSON.fromJson(Files.readString(CONFIG_PATH), ServerMonitorConfig.class);
                if (config.dashboardLayout == null) {
                    config.dashboardLayout = new ArrayList<String>();
                }
                while (config.dashboardLayout.size() < 32) {
                    config.dashboardLayout.add("empty");
                }
                if (config.widgetConfigs == null) {
                    config.widgetConfigs = new HashMap<String, Map<String, Boolean>>();
                }
                if (!config.widgetConfigs.containsKey("custom_graph")) {
                    HashMap<String, Boolean> defaults = new HashMap<String, Boolean>();
                    defaults.put("tps", true);
                    defaults.put("cpu", true);
                    defaults.put("ram", true);
                    defaults.put("players", true);
                    config.widgetConfigs.put("custom_graph", defaults);
                }
                if (config.language == null) {
                    config.language = "en";
                }
                return config;
            }
        }
        catch (IOException e) {
            MainMod.LOGGER.error("Failed to load config", (Throwable)e);
        }
        ServerMonitorConfig config = new ServerMonitorConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            MainMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public boolean isCommandAdminOnly(String command) {
        return switch (command.toLowerCase()) {
            case "overview" -> this.overviewAdminOnly;
            case "tps" -> this.tpsAdminOnly;
            case "cpu" -> this.cpuAdminOnly;
            case "ram" -> this.ramAdminOnly;
            case "storage" -> this.storageAdminOnly;
            case "players" -> this.playersAdminOnly;
            case "uptime" -> this.uptimeAdminOnly;
            default -> true;
        };
    }

    public void setCommandAdminOnly(String command, boolean val) {
        switch (command.toLowerCase()) {
            case "overview": {
                this.overviewAdminOnly = val;
                break;
            }
            case "tps": {
                this.tpsAdminOnly = val;
                break;
            }
            case "cpu": {
                this.cpuAdminOnly = val;
                break;
            }
            case "ram": {
                this.ramAdminOnly = val;
                break;
            }
            case "storage": {
                this.storageAdminOnly = val;
                break;
            }
            case "players": {
                this.playersAdminOnly = val;
                break;
            }
            case "uptime": {
                this.uptimeAdminOnly = val;
            }
        }
        this.save();
    }
}

