/*
 * Decompiled with CFR 0.152.
 */
package com.servermonitor;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.servermonitor.ServerDataManager;
import com.servermonitor.ServerMonitorConfig;
import com.servermonitor.ServerMonitorLocale;
import com.servermonitor.ServerStats;
import com.servermonitor.WebServerService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMod
implements ModInitializer {
    public static final String MOD_ID = "servermonitor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"servermonitor");
    public static final Gson GSON = new Gson();
    private static ServerMonitorConfig config;
    private static WebServerService webServer;
    private static ServerDataManager dataManager;
    private static MinecraftServer serverInstance;
    private static PlaytimeTracker playtimeTracker;
    private ScheduledExecutorService scheduler;
    private final Map<UUID, Long> sessionStartTimes = new ConcurrentHashMap<UUID, Long>();
    private static final long AFK_THRESHOLD_MS = 60000L;
    private final Map<UUID, AFKState> afkStates = new ConcurrentHashMap<UUID, AFKState>();

    public void onInitialize() {
        LOGGER.info("Server Monitor initializing...");
        config = ServerMonitorConfig.load();
        dataManager = new ServerDataManager(config);
        playtimeTracker = new PlaytimeTracker();
        webServer = new WebServerService(dataManager, config);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            this.startMonitoringTask();
            webServer.start();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            webServer.stop();
            dataManager.saveData();
            playtimeTracker.save();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            dataManager.saveData();
            playtimeTracker.save();
        }, 5L, 5L, TimeUnit.MINUTES));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            this.sessionStartTimes.put(handler.method_32311().method_5667(), System.currentTimeMillis());
            playtimeTracker.updatePlayer(handler.method_32311());
            AFKState state = new AFKState();
            state.lastX = handler.method_32311().method_23317();
            state.lastY = handler.method_32311().method_23318();
            state.lastZ = handler.method_32311().method_23321();
            state.lastMoveTime = System.currentTimeMillis();
            this.afkStates.put(handler.method_32311().method_5667(), state);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            this.sessionStartTimes.remove(handler.method_32311().method_5667());
            this.afkStates.remove(handler.method_32311().method_5667());
            playtimeTracker.updatePlayer(handler.method_32311());
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private void startMonitoringTask() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this::collectData, 0L, MainMod.config.updateIntervalSeconds, TimeUnit.SECONDS);
    }

    private void collectData() {
        if (serverInstance == null) {
            return;
        }
        try {
            double tps = this.calculateTPS(serverInstance);
            double cpu = this.getCPUUsage();
            Runtime rt = Runtime.getRuntime();
            long maxMem = rt.maxMemory();
            long totalAllocated = rt.totalMemory();
            long reallyUsed = totalAllocated - rt.freeMemory();
            double ramPercent = (double)reallyUsed * 100.0 / (double)maxMem;
            FileStore fs = Files.getFileStore(Paths.get(".", new String[0]));
            long totalSpace = fs.getTotalSpace();
            long usedSpace = totalSpace - fs.getUsableSpace();
            double storagePercent = (double)usedSpace * 100.0 / (double)totalSpace;
            long uptimeSec = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
            int playerCount = 0;
            int maxPlayers = 0;
            ArrayList<ServerStats.PlayerDetail> playerList = new ArrayList<ServerStats.PlayerDetail>();
            if (serverInstance.method_3760() != null) {
                playerCount = serverInstance.method_3788();
                maxPlayers = serverInstance.method_3802();
                for (class_3222 p : serverInstance.method_3760().method_14571()) {
                    playtimeTracker.updatePlayer(p);
                    long totalTicks = p.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417));
                    long totalSeconds = totalTicks / 20L;
                    long sessionMillis = System.currentTimeMillis() - this.sessionStartTimes.getOrDefault(p.method_5667(), System.currentTimeMillis());
                    long sessionSeconds = sessionMillis / 1000L;
                    PlaytimeTracker.DailyStats ds = playtimeTracker.getStats(p.method_5667());
                    long todaySeconds = (totalTicks - ds.startOfDayTicks) / 20L;
                    long yesterdaySeconds = ds.yesterdayTicks / 20L;
                    AFKState afk = this.afkStates.computeIfAbsent(p.method_5667(), k -> {
                        AFKState s = new AFKState();
                        s.lastX = p.method_23317();
                        s.lastY = p.method_23318();
                        s.lastZ = p.method_23321();
                        s.lastMoveTime = System.currentTimeMillis();
                        return s;
                    });
                    double distSq = Math.pow(p.method_23317() - afk.lastX, 2.0) + Math.pow(p.method_23318() - afk.lastY, 2.0) + Math.pow(p.method_23321() - afk.lastZ, 2.0);
                    if (distSq > 0.0025) {
                        afk.lastX = p.method_23317();
                        afk.lastY = p.method_23318();
                        afk.lastZ = p.method_23321();
                        afk.lastMoveTime = System.currentTimeMillis();
                    }
                    boolean isAfk = System.currentTimeMillis() - afk.lastMoveTime > 60000L;
                    playerList.add(new ServerStats.PlayerDetail(p.method_5820(), this.getPing(p), p.method_31477(), p.method_31478(), p.method_31479(), totalSeconds, sessionSeconds, Math.max(0L, todaySeconds), Math.max(0L, yesterdaySeconds), isAfk));
                }
            }
            ServerStats stats = new ServerStats(System.currentTimeMillis(), tps, cpu, ramPercent, (double)reallyUsed / 1048576.0, (double)maxMem / 1048576.0, storagePercent, (double)usedSpace / 1.073741824E9, (double)totalSpace / 1.073741824E9, playerCount, maxPlayers, uptimeSec, playerList);
            dataManager.addStat(stats);
        }
        catch (Exception e) {
            LOGGER.error("Error collecting stats", (Throwable)e);
        }
    }

    private int getPing(class_3222 player) {
        try {
            if (player.field_13987 == null) {
                return 0;
            }
            for (Class<?> clazz = player.field_13987.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField("latency");
                    field.setAccessible(true);
                    return field.getInt(player.field_13987);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    private double calculateTPS(MinecraftServer server) {
        try {
            long[] tickTimes;
            String[] possibleNames;
            Field tickTimesField = null;
            for (String fieldName : possibleNames = new String[]{"tickTimes", "recentTickTimes", "lastTickTimes", "tickTimes50", "f_129753_"}) {
                try {
                    tickTimesField = MinecraftServer.class.getDeclaredField(fieldName);
                    tickTimesField.setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            if (tickTimesField != null && (tickTimes = (long[])tickTimesField.get(server)) != null && tickTimes.length > 0) {
                long sum = 0L;
                for (Object t : (String)tickTimes) {
                    sum += t;
                }
                double avgTickMs = (double)sum / (double)tickTimes.length * 1.0E-6;
                return Math.min(20.0, 1000.0 / avgTickMs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 20.0;
    }

    private double getCPUUsage() {
        try {
            com.sun.management.OperatingSystemMXBean sunBean;
            double load;
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            if (osBean instanceof com.sun.management.OperatingSystemMXBean && (load = (sunBean = (com.sun.management.OperatingSystemMXBean)osBean).getProcessCpuLoad()) >= 0.0) {
                return load * 100.0;
            }
            double sysLoad = osBean.getSystemLoadAverage();
            if (sysLoad >= 0.0) {
                return sysLoad / (double)osBean.getAvailableProcessors() * 100.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)MOD_ID);
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"overview").requires(s -> this.checkPerm((class_2168)s, "overview"))).executes(this::cmdOverview));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tps").requires(s -> this.checkPerm((class_2168)s, "tps"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "tps")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cpu").requires(s -> this.checkPerm((class_2168)s, "cpu"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "cpu")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ram").requires(s -> this.checkPerm((class_2168)s, "ram"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "ram")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"storage").requires(s -> this.checkPerm((class_2168)s, "storage"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "storage")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"players").requires(s -> this.checkPerm((class_2168)s, "players"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "players")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"uptime").requires(s -> this.checkPerm((class_2168)s, "uptime"))).executes(ctx -> this.showSingleStat((CommandContext<class_2168>)ctx, "uptime")));
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"interval").requires(s -> s.method_9259(2))).then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)600)).executes(ctx -> {
            int sec;
            MainMod.config.updateIntervalSeconds = sec = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            config.save();
            this.startMonitoringTask();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)ServerMonitorLocale.fmt("cmd.interval_update", sec)), true);
            return 1;
        })));
        SuggestionProvider features = (ctx, builder) -> class_2172.method_9265(List.of("overview", "tps", "cpu", "ram", "storage", "players", "uptime"), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder configNode = (LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(s -> s.method_9259(2));
        configNode.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(features).then(class_2170.method_9247((String)"priv").executes(ctx -> this.setFeaturePerm((CommandContext<class_2168>)ctx, true)))).then(class_2170.method_9247((String)"open").executes(ctx -> this.setFeaturePerm((CommandContext<class_2168>)ctx, false))));
        root.then((ArgumentBuilder)configNode);
        dispatcher.register(root);
    }

    private boolean checkPerm(class_2168 source, String cmd) {
        return !config.isCommandAdminOnly(cmd) || source.method_9259(2);
    }

    private int cmdOverview(CommandContext<class_2168> context) {
        String cpuC;
        String tpsC;
        ServerStats stats = dataManager.getLatest();
        if (stats == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)ServerMonitorLocale.get("cmd.no_data")));
            return 0;
        }
        class_2168 s = (class_2168)context.getSource();
        String sep = "\u00a78 | \u00a7r";
        String prefix = ServerMonitorLocale.get("cmd.prefix");
        String string = stats.tps() >= 18.0 ? "\u00a7a" : (tpsC = stats.tps() >= 15.0 ? "\u00a7e" : "\u00a7c");
        String string2 = stats.cpuLoad() < 50.0 ? "\u00a7a" : (cpuC = stats.cpuLoad() < 80.0 ? "\u00a7e" : "\u00a7c");
        String ramC = stats.ramUsagePercent() < 75.0 ? "\u00a7a" : (stats.ramUsagePercent() < 90.0 ? "\u00a7e" : "\u00a7c");
        s.method_9226(() -> class_2561.method_43470((String)(prefix + ServerMonitorLocale.get("cmd.overview"))), false);
        s.method_9226(() -> class_2561.method_43470((String)String.format(" \u00a77%s: %s%.1f\u00a7r%s%s: %s%.0f%%\u00a7r%s%s: %s%.0f%%", ServerMonitorLocale.get("cmd.tps"), tpsC, stats.tps(), sep, ServerMonitorLocale.get("cmd.cpu"), cpuC, stats.cpuLoad(), sep, ServerMonitorLocale.get("cmd.ram"), ramC, stats.ramUsagePercent())), false);
        s.method_9226(() -> class_2561.method_43470((String)String.format(" \u00a77%s: \u00a7b%.1f%%\u00a7r%s%s: \u00a7f%d/%d%s%s: \u00a7f%s", ServerMonitorLocale.get("cmd.storage"), stats.storageUsagePercent(), sep, ServerMonitorLocale.get("cmd.players"), stats.onlinePlayers(), stats.maxPlayers(), sep, ServerMonitorLocale.get("cmd.uptime"), this.formatDuration(stats.uptimeSeconds()))), false);
        return 1;
    }

    private int showSingleStat(CommandContext<class_2168> context, String type) {
        ServerStats stats = dataManager.getLatest();
        if (stats == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)ServerMonitorLocale.get("cmd.no_data")));
            return 0;
        }
        String prefix = ServerMonitorLocale.get("cmd.prefix");
        String finalOutput = switch (type) {
            case "tps" -> String.format("\u00a77%s: %s%.2f", ServerMonitorLocale.get("cmd.tps"), stats.tps() >= 18.0 ? "\u00a7a" : (stats.tps() >= 15.0 ? "\u00a7e" : "\u00a7c"), stats.tps());
            case "cpu" -> String.format("\u00a77%s: %s%.1f%%", ServerMonitorLocale.get("cmd.cpu"), stats.cpuLoad() < 60.0 ? "\u00a7a" : (stats.cpuLoad() < 85.0 ? "\u00a7e" : "\u00a7c"), stats.cpuLoad());
            case "ram" -> String.format("\u00a77%s: %s%.1f%% \u00a77(%.0f/%.0f MB)", ServerMonitorLocale.get("cmd.ram"), stats.ramUsagePercent() < 75.0 ? "\u00a7a" : "\u00a7e", stats.ramUsagePercent(), stats.ramUsedMB(), stats.ramTotalMB());
            case "storage" -> String.format("\u00a77%s: \u00a7b%.1f%% \u00a77(%.1f %s)", ServerMonitorLocale.get("cmd.storage"), stats.storageUsagePercent(), stats.storageTotalGB() - stats.storageUsedGB(), ServerMonitorLocale.get("cmd.gb_free"));
            case "players" -> String.format("\u00a77%s: \u00a7f%d \u00a77/ \u00a7f%d", ServerMonitorLocale.get("cmd.players"), stats.onlinePlayers(), stats.maxPlayers());
            case "uptime" -> String.format("\u00a77%s: \u00a7f%s", ServerMonitorLocale.get("cmd.uptime"), this.formatDuration(stats.uptimeSeconds()));
            default -> ServerMonitorLocale.get("cmd.unknown");
        };
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(prefix + finalOutput)), false);
        return 1;
    }

    private int setFeaturePerm(CommandContext<class_2168> ctx, boolean priv) {
        String feature = StringArgumentType.getString(ctx, (String)"feature");
        if (!List.of("overview", "tps", "cpu", "ram", "storage", "players", "uptime").contains(feature)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cUnknown feature: " + feature)));
            return 0;
        }
        config.setCommandAdminOnly(feature, priv);
        String state = priv ? ServerMonitorLocale.get("cmd.perm_priv") : ServerMonitorLocale.get("cmd.perm_open");
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)ServerMonitorLocale.fmt("cmd.config_update", feature, state)), true);
        return 1;
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        if (h > 0L) {
            return h + "h " + m + "m";
        }
        return m + "m " + seconds % 60L + "s";
    }

    public static class PlaytimeTracker {
        private static final Path FILE = ServerMonitorConfig.DATA_DIR.resolve("playtime_tracker.json");
        private Map<UUID, DailyStats> data = new ConcurrentHashMap<UUID, DailyStats>();

        public PlaytimeTracker() {
            if (Files.exists(FILE, new LinkOption[0])) {
                try (BufferedReader r = Files.newBufferedReader(FILE);){
                    Type type = new TypeToken<ConcurrentHashMap<UUID, DailyStats>>(this){}.getType();
                    Map loaded = (Map)GSON.fromJson((Reader)r, type);
                    if (loaded != null) {
                        this.data.putAll(loaded);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load playtime tracker", (Throwable)e);
                }
            }
        }

        public void save() {
            try (BufferedWriter w = Files.newBufferedWriter(FILE, new OpenOption[0]);){
                GSON.toJson(this.data, (Appendable)w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void updatePlayer(class_3222 p) {
            UUID id = p.method_5667();
            long currentTotal = p.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417));
            String today = LocalDate.now().toString();
            this.data.compute(id, (k, stats) -> {
                if (stats == null) {
                    stats = new DailyStats();
                    stats.date = today;
                    stats.startOfDayTicks = currentTotal;
                    stats.yesterdayTicks = 0L;
                    stats.lastSeenTotal = currentTotal;
                    return stats;
                }
                if (!stats.date.equals(today)) {
                    stats.yesterdayTicks = currentTotal - stats.startOfDayTicks;
                    stats.date = today;
                    stats.startOfDayTicks = currentTotal;
                }
                stats.lastSeenTotal = currentTotal;
                return stats;
            });
        }

        public DailyStats getStats(UUID id) {
            return this.data.getOrDefault(id, new DailyStats());
        }

        public static class DailyStats {
            String date;
            long startOfDayTicks;
            long yesterdayTicks;
            long lastSeenTotal;
        }
    }

    private static class AFKState {
        double lastX;
        double lastY;
        double lastZ;
        long lastMoveTime;

        private AFKState() {
        }
    }
}

