/*
 * Decompiled with CFR 0.152.
 */
package com.servermonitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.servermonitor.MainMod;
import com.servermonitor.ServerMonitorConfig;
import com.servermonitor.ServerStats;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;

public class ServerDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path DATA_FILE = ServerMonitorConfig.DATA_DIR.resolve("serverdata.json");
    private static final int MAX_HISTORY_SIZE = 20000;
    private final Deque<ServerStats> history = new ConcurrentLinkedDeque<ServerStats>();
    private final ServerMonitorConfig config;

    public ServerDataManager(ServerMonitorConfig config) {
        this.config = config;
        try {
            Files.createDirectories(ServerMonitorConfig.DATA_DIR, new FileAttribute[0]);
            this.loadData();
        }
        catch (IOException e) {
            MainMod.LOGGER.error("Failed to initialize data directory", (Throwable)e);
        }
    }

    public void addStat(ServerStats stat) {
        this.history.add(stat);
        this.trimHistory();
    }

    private void trimHistory() {
        while (this.history.size() > 20000) {
            this.history.pollFirst();
        }
    }

    public List<ServerStats> getHistory(int limitMinutes) {
        long threshold = System.currentTimeMillis() - (long)(limitMinutes * 60) * 1000L;
        return this.history.stream().filter(s -> s.timestamp() >= threshold).collect(Collectors.toList());
    }

    public ServerStats getLatest() {
        return this.history.peekLast();
    }

    public synchronized void saveData() {
        try (BufferedWriter writer = Files.newBufferedWriter(DATA_FILE, new OpenOption[0]);){
            List snapshot = this.history.stream().skip(Math.max(0, this.history.size() - 2000)).collect(Collectors.toList());
            GSON.toJson(snapshot, (Appendable)writer);
        }
        catch (IOException e) {
            MainMod.LOGGER.error("Failed to save server data", (Throwable)e);
        }
    }

    private void loadData() {
        if (!Files.exists(DATA_FILE, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(DATA_FILE);){
            Type listType = new TypeToken<ArrayList<ServerStats>>(this){}.getType();
            List loaded = (List)GSON.fromJson((Reader)reader, listType);
            if (loaded != null) {
                long threshold = System.currentTimeMillis() - 86400000L;
                for (ServerStats s : loaded) {
                    if (s.timestamp() <= threshold) continue;
                    this.history.add(s);
                }
                this.fillOfflineGaps();
            }
        }
        catch (Exception e) {
            MainMod.LOGGER.error("Failed to load existing data (file might be corrupt)", (Throwable)e);
        }
    }

    private void fillOfflineGaps() {
        long intervalMillis;
        long lastTime;
        ServerStats lastKnown = this.history.peekLast();
        if (lastKnown == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (lastTime = lastKnown.timestamp()) > (intervalMillis = (long)this.config.updateIntervalSeconds * 1000L) * 2L) {
            MainMod.LOGGER.info("Detected downtime gap. Filling with offline stats...");
            int addedCount = 0;
            for (long fillTime = lastTime + intervalMillis; fillTime < now; fillTime += intervalMillis) {
                ServerStats offlineStat = new ServerStats(fillTime, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0L, Collections.emptyList());
                this.history.add(offlineStat);
                if (this.history.size() <= 20000) continue;
                this.history.pollFirst();
                if (++addedCount <= 20000) continue;
                break;
            }
            MainMod.LOGGER.info("Filled {} offline data points.", (Object)addedCount);
        }
    }
}

