/*
 * Decompiled with CFR 0.152.
 */
package com.servermonitor;

import com.servermonitor.ServerMonitorConfig;
import java.util.HashMap;
import java.util.Map;

public class ServerMonitorLocale {
    private static final Map<String, Map<String, String>> LANGUAGES = new HashMap<String, Map<String, String>>();

    public static String get(String key) {
        String langCode = ServerMonitorConfig.load().language;
        if (langCode == null || !LANGUAGES.containsKey(langCode)) {
            langCode = "en";
        }
        Map<String, String> map = LANGUAGES.get(langCode);
        return map.getOrDefault(key, key);
    }

    public static String fmt(String key, Object ... args) {
        return String.format(ServerMonitorLocale.get(key), args);
    }

    static {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("cmd.prefix", "\u00a78[\u00a7bServerMonitor\u00a78] ");
        en.put("cmd.no_data", "\u00a7cNo data collected yet.");
        en.put("cmd.overview", "\u00a77Overview:");
        en.put("cmd.tps", "TPS");
        en.put("cmd.cpu", "CPU");
        en.put("cmd.ram", "RAM");
        en.put("cmd.players", "Players");
        en.put("cmd.uptime", "Uptime");
        en.put("cmd.storage", "Disk");
        en.put("cmd.unknown", "\u00a7cUnknown metric");
        en.put("cmd.interval_update", "\u00a7aInterval updated to %ss");
        en.put("cmd.config_update", "\u00a77Feature \u00a7f%s\u00a77 is now: %s");
        en.put("cmd.perm_priv", "\u00a7cAdmin Only (priv)");
        en.put("cmd.perm_open", "\u00a7aEveryone (open)");
        en.put("cmd.gb_free", "GB Free");
        en.put("web.title", "Server Monitor");
        en.put("web.loading", "Loading...");
        en.put("web.live", "Live: ");
        en.put("web.head.tps", "Performance");
        en.put("web.head.cpu", "CPU Load");
        en.put("web.head.ram", "Memory");
        en.put("web.head.players", "Online");
        en.put("web.head.storage", "Disk");
        en.put("web.head.uptime", "Uptime");
        en.put("web.sub.target", "Target: 20.0");
        en.put("web.sub.system", "System Process");
        en.put("web.sub.restart", "Since Restart");
        en.put("web.pie.tps", "TPS");
        en.put("web.pie.cpu", "CPU");
        en.put("web.pie.ram", "RAM");
        en.put("web.pie.players", "Players");
        en.put("web.pie.storage", "Storage");
        en.put("web.pie.uptime", "Uptime (24h)");
        en.put("web.pie.multi", "Overview");
        en.put("web.legend.tps", "TPS");
        en.put("web.legend.cpu", "CPU");
        en.put("web.legend.ram", "RAM");
        en.put("web.legend.players", "Players");
        en.put("web.legend.used", "Used");
        en.put("web.legend.free", "Free");
        en.put("web.legend.online", "Online");
        en.put("web.legend.offline", "Offline");
        en.put("web.graph.tps", "TPS History");
        en.put("web.graph.cpu", "CPU History");
        en.put("web.graph.ram", "RAM History");
        en.put("web.graph.players", "Player History");
        en.put("web.graph.storage", "Storage History");
        en.put("web.graph.uptime", "Heartbeat (1=Online)");
        en.put("web.graph.combined", "Combined Monitor");
        en.put("web.list.header", "Online Players");
        en.put("web.list.none", "No players online");
        en.put("web.list.ping_pos", "Ping / Pos");
        en.put("web.list.total", "Total");
        en.put("web.list.sess", "Sess");
        en.put("web.list.today", "Today");
        en.put("web.list.yest", "Yest");
        en.put("adm.login.title", "Admin Login");
        en.put("adm.login.btn", "Login");
        en.put("adm.login.back", "Back to Dashboard");
        en.put("adm.login.user", "Username");
        en.put("adm.login.pass", "Password");
        en.put("adm.panel.title", "Layout Designer");
        en.put("adm.btn.save", "Save");
        en.put("adm.btn.dash", "To Dashboard");
        en.put("adm.btn.logout", "Logout");
        en.put("adm.sidebar.title", "Available Widgets");
        en.put("adm.grid.title", "Active Dashboard (4x8 Grid)");
        en.put("adm.toast.saved", "Saved!");
        en.put("adm.modal.title", "Configure Widget");
        en.put("adm.modal.save", "Save");
        en.put("adm.modal.cancel", "Cancel");
        en.put("adm.modal.show", "Show");
        en.put("adm.widget.playerlist", "Player List");
        LANGUAGES.put("en", en);
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("cmd.prefix", "\u00a78[\u00a7bServerMonitor\u00a78] ");
        de.put("cmd.no_data", "\u00a7cNoch keine Daten gesammelt.");
        de.put("cmd.overview", "\u00a77\u00dcbersicht:");
        de.put("cmd.tps", "TPS");
        de.put("cmd.cpu", "CPU");
        de.put("cmd.ram", "RAM");
        de.put("cmd.players", "Spieler");
        de.put("cmd.uptime", "Laufzeit");
        de.put("cmd.storage", "Speicher");
        de.put("cmd.unknown", "\u00a7cUnbekannter Wert");
        de.put("cmd.interval_update", "\u00a7aIntervall aktualisiert auf %ss");
        de.put("cmd.config_update", "\u00a77Feature \u00a7f%s\u00a77 ist jetzt: %s");
        de.put("cmd.perm_priv", "\u00a7cNur Admins (priv)");
        de.put("cmd.perm_open", "\u00a7aJeder (open)");
        de.put("cmd.gb_free", "GB Frei");
        de.put("web.title", "Server Monitor");
        de.put("web.loading", "Lade...");
        de.put("web.live", "Live: ");
        de.put("web.head.tps", "Leistung (TPS)");
        de.put("web.head.cpu", "Prozessorlast");
        de.put("web.head.ram", "Arbeitsspeicher");
        de.put("web.head.players", "Spieler Online");
        de.put("web.head.storage", "Festplatte");
        de.put("web.head.uptime", "Laufzeit");
        de.put("web.sub.target", "Ziel: 20.0");
        de.put("web.sub.system", "Systemprozess");
        de.put("web.sub.restart", "Seit Neustart");
        de.put("web.pie.tps", "TPS");
        de.put("web.pie.cpu", "CPU");
        de.put("web.pie.ram", "RAM");
        de.put("web.pie.players", "Spieler");
        de.put("web.pie.storage", "Speicher");
        de.put("web.pie.uptime", "Laufzeit (24h)");
        de.put("web.pie.multi", "\u00dcbersicht");
        de.put("web.legend.tps", "TPS");
        de.put("web.legend.cpu", "CPU");
        de.put("web.legend.ram", "RAM");
        de.put("web.legend.players", "Spieler");
        de.put("web.legend.used", "Belegt");
        de.put("web.legend.free", "Frei");
        de.put("web.legend.online", "Online");
        de.put("web.legend.offline", "Offline");
        de.put("web.graph.tps", "TPS Verlauf");
        de.put("web.graph.cpu", "CPU Verlauf");
        de.put("web.graph.ram", "RAM Verlauf");
        de.put("web.graph.players", "Spieler Verlauf");
        de.put("web.graph.storage", "Speicher Verlauf");
        de.put("web.graph.uptime", "Status (1=Online)");
        de.put("web.graph.combined", "Kombi-Monitor");
        de.put("web.list.header", "Spieler Online");
        de.put("web.list.none", "Keine Spieler online");
        de.put("web.list.ping_pos", "Ping / Pos");
        de.put("web.list.total", "Gesamt");
        de.put("web.list.sess", "Sess");
        de.put("web.list.today", "Heute");
        de.put("web.list.yest", "Gestern");
        de.put("adm.login.title", "Admin Anmeldung");
        de.put("adm.login.btn", "Anmelden");
        de.put("adm.login.back", "Zur\u00fcck zum Dashboard");
        de.put("adm.login.user", "Benutzername");
        de.put("adm.login.pass", "Passwort");
        de.put("adm.panel.title", "Layout Designer");
        de.put("adm.btn.save", "Speichern");
        de.put("adm.btn.dash", "Zum Dashboard");
        de.put("adm.btn.logout", "Abmelden");
        de.put("adm.sidebar.title", "Verf\u00fcgbare Widgets");
        de.put("adm.grid.title", "Aktives Dashboard (4x8 Raster)");
        de.put("adm.toast.saved", "Gespeichert!");
        de.put("adm.modal.title", "Widget Konfigurieren");
        de.put("adm.modal.save", "Speichern");
        de.put("adm.modal.cancel", "Abbrechen");
        de.put("adm.modal.show", "Zeige");
        de.put("adm.widget.playerlist", "Spielerliste");
        LANGUAGES.put("de", de);
    }
}

