/*
 * Decompiled with CFR 0.152.
 */
package com.servermonitor;

import com.servermonitor.MainMod;
import com.servermonitor.ServerDataManager;
import com.servermonitor.ServerMonitorConfig;
import com.servermonitor.ServerMonitorLocale;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;

public class WebServerService {
    private HttpServer server;
    private final ServerDataManager dataManager;
    private final ServerMonitorConfig config;
    private final Map<String, Long> sessions = new ConcurrentHashMap<String, Long>();
    private static final String CSS_VARS = "    :root {\n        --bg-body:#09090b; --bg-card:#18181b; --bg-card-hover:#27272a; --text-main:#fafafa; --text-muted:#a1a1aa;\n        --accent:#6366f1; --accent-glow:rgba(99,102,241,0.15); --border:#27272a; --slot-bg:#121214;\n        --font-main:'Inter',sans-serif; --font-mono:'JetBrains Mono',monospace;\n        --radius:12px; --shadow:none; --border-style:solid; --border-width:1px;\n        --success:#10b981; --warn:#f59e0b; --danger:#ef4444;\n        --card-height: 240px;\n    }\n    [data-theme=\"light\"] {\n        --bg-body:#f4f4f5; --bg-card:#ffffff; --bg-card-hover:#f4f4f5; --text-main:#18181b; --text-muted:#71717a;\n        --accent:#4f46e5; --accent-glow:rgba(79,70,229,0.1); --border:#e4e4e7; --slot-bg:#f4f4f5; --shadow:0 1px 3px rgba(0,0,0,0.1);\n    }\n    [data-style=\"retro\"] {\n        --bg-body:#008080; --bg-card:#c0c0c0; --bg-card-hover:#c0c0c0; --text-main:#000000; --text-muted:#404040;\n        --accent:#000080; --accent-glow:transparent; --border:#dfdfdf; --slot-bg:#ffffff;\n        --font-main:'Tahoma',sans-serif; --font-mono:'Courier New',monospace;\n        --radius:0px; --border-style:solid; --border-width:2px;\n        --success:#008000; --warn:#808000; --danger:#ff0000;\n    }\n    * { box-sizing:border-box; margin:0; padding:0; }\n    body { background-color:var(--bg-body); color:var(--text-main); font-family:var(--font-main); min-height:100vh; transition:background 0.3s, color 0.3s; }\n    .btn { background:var(--bg-card); border:1px solid var(--border); color:var(--text-muted); padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:600; transition:all 0.2s; white-space:nowrap; }\n    .btn:hover { background:var(--bg-card-hover); color:var(--text-main); border-color:var(--accent); }\n    .btn.active { background:var(--accent); color:white; border-color:var(--accent); }\n    .btn.danger { border-color:var(--danger); color:var(--danger); }\n    .btn.danger:hover { background:var(--danger); color:white; }\n    [data-style=\"retro\"] .btn { background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; color:black; border-radius:0; box-shadow:none; }\n    [data-style=\"retro\"] .btn:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n    .fab-container { position:fixed; bottom:20px; right:20px; display:flex; gap:10px; z-index:1000; }\n    .fab { width:48px; height:48px; border-radius:50%; background:var(--bg-card); border:1px solid var(--border); color:var(--text-main); display:flex; align-items:center; justify-content:center; cursor:pointer; font-size:1.2rem; box-shadow:0 4px 12px rgba(0,0,0,0.3); transition:transform 0.2s; }\n    .fab:hover { transform:scale(1.1); color:var(--accent); }\n    [data-style=\"retro\"] .fab { border-radius:0; background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; box-shadow:none; color:black; }\n    [data-style=\"retro\"] .fab:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n\n    .player-list-container { overflow-y: auto; flex: 1; display: flex; flex-direction: column; gap: 0.5rem; padding-right: 5px; height: 100%; min-height: 0; }\n    .player-row { display: flex; flex-direction:column; padding: 0.5rem; background: var(--slot-bg); border-radius: 6px; border: 1px solid var(--border); }\n    .player-row-top { display:flex; align-items:center; justify-content:space-between; margin-bottom:4px; }\n    .player-head { width: 24px; height: 24px; border-radius: 4px; }\n    .player-name { font-weight: 600; font-size: 0.9rem; margin-left:8px; }\n    .pt-row { display:flex; justify-content:space-between; font-size:0.7rem; color:var(--text-muted); font-family:var(--font-mono); margin-top:2px; }\n    .pt-val { color:var(--text-main); }\n    ::-webkit-scrollbar { width: 6px; height: 6px; }\n    ::-webkit-scrollbar-track { background: transparent; }\n    ::-webkit-scrollbar-thumb { background: var(--border); border-radius: 3px; }\n    ::-webkit-scrollbar-thumb:hover { background: var(--text-muted); }\n    [data-style=\"retro\"] .player-row { border-radius: 0; border: 1px solid #808080; background: white; color: black; box-shadow: inset 1px 1px 2px rgba(0,0,0,0.2); }\n    [data-style=\"retro\"] .player-head { border-radius: 0; border: 1px solid black; }\n";
    private static final String LOGIN_HTML = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><title>Login</title>\n    <link href=\"https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap\" rel=\"stylesheet\">\n    <style>\n        {{CSS}}\n        body { display:flex; align-items:center; justify-content:center; padding:1rem; }\n        .login-card { background:var(--bg-card); border:1px solid var(--border); padding:2.5rem; border-radius:16px; width:100%; max-width:400px; }\n        [data-style=\"retro\"] .login-card { border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; border-radius:0; box-shadow:4px 4px 0px rgba(0,0,0,0.5); }\n        input { width:100%; padding:0.75rem; margin-bottom:1rem; border-radius:8px; background:var(--bg-dark); border:1px solid var(--border); color:var(--text-main); }\n        [data-style=\"retro\"] input { background:white; color:black; border-radius:0; border:2px inset #dfdfdf; }\n        button { width:100%; padding:0.75rem; border-radius:8px; background:var(--accent); color:white; border:none; font-weight:600; cursor:pointer; }\n    </style>\n</head>\n<body>\n    <div class=\"login-card\">\n        <h2 style=\"margin-bottom:1.5rem; text-align:center;\">Admin Login</h2>\n        <form action=\"/auth\" method=\"POST\">\n            <label style=\"display:block; margin-bottom:0.5rem; color:var(--text-muted)\">Username</label>\n            <input type=\"text\" name=\"username\" required autofocus>\n            <label style=\"display:block; margin-bottom:0.5rem; color:var(--text-muted)\">Password</label>\n            <input type=\"password\" name=\"password\" required>\n            <button type=\"submit\" class=\"btn active\">Login</button>\n        </form>\n        <a href=\"/\" style=\"display:block; text-align:center; margin-top:1.5rem; color:var(--text-muted); text-decoration:none;\">\u2190 Back to Dashboard</a>\n    </div>\n    <div class=\"fab-container\"><div class=\"fab\" onclick=\"toggleTheme()\">\u25d1</div><div class=\"fab\" onclick=\"toggleRetro()\">\ud83d\udcbe</div></div>\n    <script>\n        function toggleTheme() { const b=document.body; const n=b.getAttribute('data-theme')==='light'?'dark':'light'; b.setAttribute('data-theme',n); localStorage.setItem('theme',n); }\n        function toggleRetro() { const b=document.body; const n=b.getAttribute('data-style')==='retro'?'modern':'retro'; b.setAttribute('data-style',n); localStorage.setItem('style',n); }\n        document.body.setAttribute('data-theme', localStorage.getItem('theme')||'dark');\n        document.body.setAttribute('data-style', localStorage.getItem('style')||'modern');\n    </script>\n</body>\n</html>\n".replace("{{CSS}}", "    :root {\n        --bg-body:#09090b; --bg-card:#18181b; --bg-card-hover:#27272a; --text-main:#fafafa; --text-muted:#a1a1aa;\n        --accent:#6366f1; --accent-glow:rgba(99,102,241,0.15); --border:#27272a; --slot-bg:#121214;\n        --font-main:'Inter',sans-serif; --font-mono:'JetBrains Mono',monospace;\n        --radius:12px; --shadow:none; --border-style:solid; --border-width:1px;\n        --success:#10b981; --warn:#f59e0b; --danger:#ef4444;\n        --card-height: 240px;\n    }\n    [data-theme=\"light\"] {\n        --bg-body:#f4f4f5; --bg-card:#ffffff; --bg-card-hover:#f4f4f5; --text-main:#18181b; --text-muted:#71717a;\n        --accent:#4f46e5; --accent-glow:rgba(79,70,229,0.1); --border:#e4e4e7; --slot-bg:#f4f4f5; --shadow:0 1px 3px rgba(0,0,0,0.1);\n    }\n    [data-style=\"retro\"] {\n        --bg-body:#008080; --bg-card:#c0c0c0; --bg-card-hover:#c0c0c0; --text-main:#000000; --text-muted:#404040;\n        --accent:#000080; --accent-glow:transparent; --border:#dfdfdf; --slot-bg:#ffffff;\n        --font-main:'Tahoma',sans-serif; --font-mono:'Courier New',monospace;\n        --radius:0px; --border-style:solid; --border-width:2px;\n        --success:#008000; --warn:#808000; --danger:#ff0000;\n    }\n    * { box-sizing:border-box; margin:0; padding:0; }\n    body { background-color:var(--bg-body); color:var(--text-main); font-family:var(--font-main); min-height:100vh; transition:background 0.3s, color 0.3s; }\n    .btn { background:var(--bg-card); border:1px solid var(--border); color:var(--text-muted); padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:600; transition:all 0.2s; white-space:nowrap; }\n    .btn:hover { background:var(--bg-card-hover); color:var(--text-main); border-color:var(--accent); }\n    .btn.active { background:var(--accent); color:white; border-color:var(--accent); }\n    .btn.danger { border-color:var(--danger); color:var(--danger); }\n    .btn.danger:hover { background:var(--danger); color:white; }\n    [data-style=\"retro\"] .btn { background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; color:black; border-radius:0; box-shadow:none; }\n    [data-style=\"retro\"] .btn:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n    .fab-container { position:fixed; bottom:20px; right:20px; display:flex; gap:10px; z-index:1000; }\n    .fab { width:48px; height:48px; border-radius:50%; background:var(--bg-card); border:1px solid var(--border); color:var(--text-main); display:flex; align-items:center; justify-content:center; cursor:pointer; font-size:1.2rem; box-shadow:0 4px 12px rgba(0,0,0,0.3); transition:transform 0.2s; }\n    .fab:hover { transform:scale(1.1); color:var(--accent); }\n    [data-style=\"retro\"] .fab { border-radius:0; background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; box-shadow:none; color:black; }\n    [data-style=\"retro\"] .fab:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n\n    .player-list-container { overflow-y: auto; flex: 1; display: flex; flex-direction: column; gap: 0.5rem; padding-right: 5px; height: 100%; min-height: 0; }\n    .player-row { display: flex; flex-direction:column; padding: 0.5rem; background: var(--slot-bg); border-radius: 6px; border: 1px solid var(--border); }\n    .player-row-top { display:flex; align-items:center; justify-content:space-between; margin-bottom:4px; }\n    .player-head { width: 24px; height: 24px; border-radius: 4px; }\n    .player-name { font-weight: 600; font-size: 0.9rem; margin-left:8px; }\n    .pt-row { display:flex; justify-content:space-between; font-size:0.7rem; color:var(--text-muted); font-family:var(--font-mono); margin-top:2px; }\n    .pt-val { color:var(--text-main); }\n    ::-webkit-scrollbar { width: 6px; height: 6px; }\n    ::-webkit-scrollbar-track { background: transparent; }\n    ::-webkit-scrollbar-thumb { background: var(--border); border-radius: 3px; }\n    ::-webkit-scrollbar-thumb:hover { background: var(--text-muted); }\n    [data-style=\"retro\"] .player-row { border-radius: 0; border: 1px solid #808080; background: white; color: black; box-shadow: inset 1px 1px 2px rgba(0,0,0,0.2); }\n    [data-style=\"retro\"] .player-head { border-radius: 0; border: 1px solid black; }\n");
    private static final String ADMIN_HTML = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><title>Admin Panel</title>\n    <link href=\"https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap\" rel=\"stylesheet\">\n    <style>\n        {{CSS}}\n        .container { max-width:1600px; margin:0 auto; padding:2rem; }\n        header { display:flex; justify-content:space-between; align-items:center; margin-bottom:2rem; border-bottom:1px solid var(--border); padding-bottom:1rem; }\n        .editor-container { display:flex; gap:2rem; align-items:flex-start; }\n        .sidebar { width:300px; background:var(--bg-card); border:1px solid var(--border); border-radius:12px; padding:1rem; position:sticky; top:1rem; height:calc(100vh - 150px); overflow-y:auto; }\n        .sidebar-title { font-weight:600; margin-bottom:1rem; color:var(--text-muted); text-transform:uppercase; font-size:0.8rem; }\n        .main-editor { flex:1; }\n        .fixed-grid { display:grid; grid-template-columns:repeat(4, 1fr); gap:1.5rem; background:rgba(255,255,255,0.02); border:2px solid var(--border); border-radius:12px; padding:1.5rem; }\n        [data-style=\"retro\"] .sidebar, [data-style=\"retro\"] .fixed-grid { border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; border-radius:0; background:var(--bg-card); }\n        .slot { height:120px; background:var(--slot-bg); border:1px dashed var(--border); border-radius:8px; display:flex; align-items:center; justify-content:center; position:relative; transition:border-color 0.2s, background 0.2s; }\n        .slot.drag-over { border-color:var(--accent)!important; background:var(--accent-glow)!important; }\n        .slot.has-item { border-style:solid; background:var(--bg-card); }\n        .slot.col-2 { grid-column:span 2; }\n        [data-style=\"retro\"] .slot { border-radius:0; border:1px dotted #808080; }\n        [data-style=\"retro\"] .slot.has-item { border:2px outset white; }\n        .sidebar-item { background:var(--bg-body); border:1px solid var(--border); border-radius:8px; padding:0.8rem; margin-bottom:0.5rem; cursor:grab; display:flex; align-items:center; gap:0.8rem; user-select:none; transition:all 0.2s; }\n        [data-style=\"retro\"] .sidebar-item { border:2px outset white; border-radius:0; background:var(--bg-card); }\n        .remove-btn, .settings-btn { position:absolute; top:-8px; right:-8px; background:var(--danger); color:white; border-radius:50%; width:20px; height:20px; display:flex; align-items:center; justify-content:center; cursor:pointer; font-size:12px; opacity:0; transition:opacity 0.2s; z-index:10; }\n        .settings-btn { right:18px; background:var(--accent); }\n        .slot:hover .remove-btn, .slot:hover .settings-btn { opacity:1; }\n        .modal-overlay { position:fixed; top:0; left:0; right:0; bottom:0; background:rgba(0,0,0,0.7); display:none; align-items:center; justify-content:center; z-index:200; }\n        .modal { background:var(--bg-card); padding:2rem; border-radius:12px; border:1px solid var(--border); width:300px; }\n        [data-style=\"retro\"] .modal { border:2px outset white; border-radius:0; box-shadow:6px 6px 0 black; }\n        .checkbox-group { display:flex; flex-direction:column; gap:0.5rem; margin-bottom:1.5rem; }\n        .checkbox-label { display:flex; align-items:center; gap:0.5rem; cursor:pointer; }\n        .toast { position:fixed; top:1rem; right:1rem; padding:1rem; border-radius:8px; color:white; display:none; animation:slideIn 0.3s; z-index:100; background:var(--success); }\n        @keyframes slideIn { from { transform: translateX(100%); } to { transform: translateX(0); } }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <header>\n            <h1>\u2699\ufe0f Layout Designer</h1>\n            <div style=\"display:flex; gap:1rem; align-items:center;\">\n                <button class=\"btn active\" onclick=\"saveLayout()\">Save</button>\n                <a href=\"/\" class=\"btn\">To Dashboard</a>\n                <a href=\"/logout\" class=\"btn danger\">Logout</a>\n            </div>\n        </header>\n        <div class=\"editor-container\">\n            <div class=\"sidebar\">\n                <div class=\"sidebar-title\">Available Widgets</div>\n                <div id=\"sidebar-list\"></div>\n            </div>\n            <div class=\"main-editor\">\n                <div class=\"sidebar-title\">Active Dashboard (4x8 Grid)</div>\n                <div id=\"grid-editor\" class=\"fixed-grid\"></div>\n            </div>\n        </div>\n    </div>\n    <div id=\"toast\" class=\"toast\">Saved!</div>\n    <div id=\"config-modal\" class=\"modal-overlay\">\n        <div class=\"modal\">\n            <div style=\"display:flex; justify-content:space-between; align-items:center; margin-bottom:1rem; background:var(--accent); padding:2px 5px; color:white; display:none;\" id=\"retro-title\"><span>Config.exe</span><span style=\"cursor:pointer\" onclick=\"closeModal()\">X</span></div>\n            <h3>Configure Widget</h3>\n            <div class=\"checkbox-group\">\n                <label class=\"checkbox-label\"><input type=\"checkbox\" id=\"cfg_tps\"> Show TPS</label>\n                <label class=\"checkbox-label\"><input type=\"checkbox\" id=\"cfg_cpu\"> Show CPU</label>\n                <label class=\"checkbox-label\"><input type=\"checkbox\" id=\"cfg_ram\"> Show RAM</label>\n                <label class=\"checkbox-label\"><input type=\"checkbox\" id=\"cfg_players\"> Show Players</label>\n            </div>\n            <div style=\"display:flex; gap:1rem;\">\n                <button class=\"btn active\" onclick=\"saveConfig()\">Save</button>\n                <button class=\"btn\" onclick=\"closeModal()\">Cancel</button>\n            </div>\n        </div>\n    </div>\n    <div class=\"fab-container\"><div class=\"fab\" onclick=\"toggleTheme()\">\u25d1</div><div class=\"fab\" onclick=\"toggleRetro()\">\ud83d\udcbe</div></div>\n    <script>\n        function toggleTheme() { const b=document.body; const n=b.getAttribute('data-theme')==='light'?'dark':'light'; b.setAttribute('data-theme',n); localStorage.setItem('theme',n); }\n        function toggleRetro() { const b=document.body; const n=b.getAttribute('data-style')==='retro'?'modern':'retro'; b.setAttribute('data-style',n); localStorage.setItem('style',n); if(document.getElementById('config-modal').style.display==='flex') openConfig(currentConfigWidget); }\n        document.body.setAttribute('data-theme', localStorage.getItem('theme')||'dark');\n        document.body.setAttribute('data-style', localStorage.getItem('style')||'modern');\n\n        const WIDGETS = [\n            { id:'tps_card', name:'TPS', type:'Card', size:1, icon:'\u26a1' }, { id:'cpu_card', name:'CPU', type:'Card', size:1, icon:'\ud83d\udcbb' },\n            { id:'ram_card', name:'RAM', type:'Card', size:1, icon:'\ud83e\udde0' }, { id:'players_card', name:'Players', type:'Card', size:1, icon:'\ud83d\udc65' },\n            { id:'storage_card', name:'Storage', type:'Card', size:1, icon:'\ud83d\udcbe' }, { id:'uptime_card', name:'Uptime', type:'Card', size:1, icon:'\u23f1\ufe0f' },\n            { id:'tps_pie', name:'TPS Pie', type:'Pie', size:1, icon:'\u26a1' }, { id:'cpu_pie', name:'CPU Pie', type:'Pie', size:1, icon:'\ud83d\udcbb' },\n            { id:'ram_pie', name:'RAM Pie', type:'Pie', size:1, icon:'\ud83e\udde0' }, { id:'players_pie', name:'Players Pie', type:'Pie', size:1, icon:'\ud83d\udc65' },\n            { id:'storage_pie', name:'Storage Pie', type:'Pie', size:1, icon:'\ud83e\udd67' }, { id:'uptime_pie', name:'Uptime Pie', type:'Pie', size:1, icon:'\u23f1\ufe0f' },\n            { id:'multi_pie', name:'Multi Pie', type:'Pie', size:1, icon:'\u25ce' },\n            { id:'tps_graph', name:'TPS History', type:'Graph', size:2, icon:'\ud83d\udcc8' }, { id:'cpu_graph', name:'CPU History', type:'Graph', size:2, icon:'\ud83d\udcc9' },\n            { id:'ram_graph', name:'RAM History', type:'Graph', size:2, icon:'\ud83d\udcca' }, { id:'players_graph', name:'Player History', type:'Graph', size:2, icon:'\ud83d\udcc5' },\n            { id:'storage_graph', name:'Storage History', type:'Graph', size:2, icon:'\ud83d\udcbe' }, { id:'uptime_graph', name:'Uptime Status', type:'Graph', size:2, icon:'\ud83d\udcf6' },\n            { id:'custom_graph', name:'Combined Monitor', type:'Graph', size:2, icon:'\ud83d\udcca', configurable:true },\n            { id:'player_list', name:'Player List', type:'Card', size:2, icon:'\ud83d\udcdc' }\n        ];\n\n        let layout = Array(32).fill('empty');\n        let widgetConfigs = {};\n        let currentConfigWidget = null;\n        let draggingItem = null;\n\n        async function init() {\n            const res = await fetch('/api/config/layout');\n            const data = await res.json();\n            for(let i=0; i<Math.min(data.length, 32); i++) layout[i] = data[i];\n            const cfgRes = await fetch('/api/config/widgets');\n            if(cfgRes.ok) widgetConfigs = await cfgRes.json();\n            renderSidebar(); renderGrid();\n        }\n\n        function renderSidebar() {\n            const container = document.getElementById('sidebar-list'); container.innerHTML = '';\n            WIDGETS.forEach(w => {\n                const div = document.createElement('div'); div.className = 'sidebar-item'; div.draggable = true;\n                div.innerHTML = `<span>${w.icon}</span> <div><div class=\"item-name\">${w.name}</div><div class=\"item-sub\">${w.type} (${w.size===2?'2 Slots':'1 Slot'})</div></div>`;\n                div.ondragstart = (e) => { draggingItem = w; e.dataTransfer.setData('text/plain', JSON.stringify({ type:'new', id:w.id, size:w.size })); };\n                div.ondragend = () => { draggingItem = null; cleanupDragOver(); };\n                container.appendChild(div);\n            });\n        }\n\n        function renderGrid() {\n            const grid = document.getElementById('grid-editor'); grid.innerHTML = '';\n            for(let i=0; i<layout.length; i++) {\n                if(layout[i]!=='empty' && layout[i]!=='HIDDEN_SLOT') {\n                    const w = WIDGETS.find(x => x.id === layout[i]);\n                    if(w && w.size===2) {\n                        if((i%4)===3) layout[i]='empty'; else layout[i+1]='HIDDEN_SLOT';\n                    }\n                }\n            }\n            for(let i=0; i<32; i++) {\n                const itemId = layout[i];\n                if(itemId === 'HIDDEN_SLOT') continue;\n\n                const slot = document.createElement('div'); slot.className = 'slot'; slot.dataset.index = i;\n                slot.ondragover = (e) => handleDragOver(e, i); slot.ondragleave = (e) => handleDragLeave(e, i); slot.ondrop = (e) => handleDrop(e, i);\n\n                if(itemId !== 'empty') {\n                    const w = WIDGETS.find(x => x.id === itemId);\n                    if(w) {\n                        slot.classList.add('has-item');\n                        if(w.size===2) slot.classList.add('col-2');\n                        let html = `<div class=\"slot-item\" draggable=\"true\" ondragstart=\"handleGridDragStart(event, ${i})\">\n                                <div class=\"item-icon\">${w.icon}</div><div class=\"item-name\">${w.name}</div></div>\n                            <div class=\"remove-btn\" onclick=\"clearSlot(${i})\">\u00d7</div>`;\n                        if(w.configurable) html += `<div class=\"settings-btn\" onclick=\"openConfig('${w.id}')\">\u2699</div>`;\n                        slot.innerHTML = html;\n                    } else { slot.innerHTML = `<span style=\"color:#ef4444\">?</span><div class=\"remove-btn\" onclick=\"clearSlot(${i})\">\u00d7</div>`; }\n                }\n                grid.appendChild(slot);\n            }\n        }\n\n        function handleGridDragStart(e, index) {\n            const itemId = layout[index]; const w = WIDGETS.find(x => x.id === itemId);\n            draggingItem = w; e.dataTransfer.setData('text/plain', JSON.stringify({ type:'move', index:index, size:w?w.size:1 }));\n        }\n\n        function handleDragOver(e, i) {\n            e.preventDefault(); if(!draggingItem) return;\n            const size = draggingItem.size;\n            if(size===2 && (i%4)===3) return;\n            document.querySelector(`.slot[data-index=\"${i}\"]`).classList.add('drag-over');\n            if(size===2) {\n                const next = document.querySelector(`.slot[data-index=\"${i+1}\"]`);\n                if(next) next.classList.add('drag-over');\n            }\n        }\n\n        function handleDragLeave(e, i) { cleanupDragOver(); }\n        function cleanupDragOver() { document.querySelectorAll('.slot').forEach(s => s.classList.remove('drag-over')); }\n\n        function handleDrop(e, targetIndex) {\n            e.preventDefault(); cleanupDragOver();\n            try {\n                const data = JSON.parse(e.dataTransfer.getData('text/plain'));\n                const size = data.size || 1;\n                if(size===2 && (targetIndex%4)===3) return;\n                if(size===2) { layout[targetIndex]='empty'; layout[targetIndex+1]='empty'; }\n                if(data.type === 'new') {\n                    layout[targetIndex] = data.id;\n                    if(size===2) layout[targetIndex+1] = 'HIDDEN_SLOT';\n                } else if (data.type === 'move') {\n                    const sourceId = layout[data.index];\n                    layout[data.index] = 'empty';\n                    if(size===2) layout[data.index+1] = 'empty';\n                    layout[targetIndex] = sourceId;\n                    if(size===2) layout[targetIndex+1] = 'HIDDEN_SLOT';\n                }\n                renderGrid();\n            } catch(err){}\n            draggingItem = null;\n        }\n\n        function clearSlot(i) {\n            const w = WIDGETS.find(x => x.id === layout[i]);\n            layout[i] = 'empty';\n            if(w && w.size===2) layout[i+1] = 'empty';\n            renderGrid();\n        }\n\n        function openConfig(id) {\n            currentConfigWidget = id;\n            const cfg = widgetConfigs[id] || { tps:true, cpu:true, ram:true, players:true };\n            document.getElementById('cfg_tps').checked = cfg.tps;\n            document.getElementById('cfg_cpu').checked = cfg.cpu;\n            document.getElementById('cfg_ram').checked = cfg.ram;\n            document.getElementById('cfg_players').checked = cfg.players;\n            document.getElementById('config-modal').style.display = 'flex';\n            if(document.body.getAttribute('data-style')==='retro') document.getElementById('retro-title').style.display='flex';\n            else document.getElementById('retro-title').style.display='none';\n        }\n        function closeModal() { document.getElementById('config-modal').style.display='none'; }\n\n        async function saveConfig() {\n            if(!currentConfigWidget) return;\n            widgetConfigs[currentConfigWidget] = {\n                tps: document.getElementById('cfg_tps').checked, cpu: document.getElementById('cfg_cpu').checked,\n                ram: document.getElementById('cfg_ram').checked, players: document.getElementById('cfg_players').checked\n            };\n            await fetch('/api/config/widgets', { method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(widgetConfigs)});\n            closeModal();\n        }\n\n        async function saveLayout() {\n            await fetch('/api/config/layout', { method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(layout)});\n            const t = document.getElementById('toast'); t.style.display='block'; setTimeout(()=>t.style.display='none',2000);\n        }\n        init();\n    </script>\n</body>\n</html>\n".replace("{{CSS}}", "    :root {\n        --bg-body:#09090b; --bg-card:#18181b; --bg-card-hover:#27272a; --text-main:#fafafa; --text-muted:#a1a1aa;\n        --accent:#6366f1; --accent-glow:rgba(99,102,241,0.15); --border:#27272a; --slot-bg:#121214;\n        --font-main:'Inter',sans-serif; --font-mono:'JetBrains Mono',monospace;\n        --radius:12px; --shadow:none; --border-style:solid; --border-width:1px;\n        --success:#10b981; --warn:#f59e0b; --danger:#ef4444;\n        --card-height: 240px;\n    }\n    [data-theme=\"light\"] {\n        --bg-body:#f4f4f5; --bg-card:#ffffff; --bg-card-hover:#f4f4f5; --text-main:#18181b; --text-muted:#71717a;\n        --accent:#4f46e5; --accent-glow:rgba(79,70,229,0.1); --border:#e4e4e7; --slot-bg:#f4f4f5; --shadow:0 1px 3px rgba(0,0,0,0.1);\n    }\n    [data-style=\"retro\"] {\n        --bg-body:#008080; --bg-card:#c0c0c0; --bg-card-hover:#c0c0c0; --text-main:#000000; --text-muted:#404040;\n        --accent:#000080; --accent-glow:transparent; --border:#dfdfdf; --slot-bg:#ffffff;\n        --font-main:'Tahoma',sans-serif; --font-mono:'Courier New',monospace;\n        --radius:0px; --border-style:solid; --border-width:2px;\n        --success:#008000; --warn:#808000; --danger:#ff0000;\n    }\n    * { box-sizing:border-box; margin:0; padding:0; }\n    body { background-color:var(--bg-body); color:var(--text-main); font-family:var(--font-main); min-height:100vh; transition:background 0.3s, color 0.3s; }\n    .btn { background:var(--bg-card); border:1px solid var(--border); color:var(--text-muted); padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:600; transition:all 0.2s; white-space:nowrap; }\n    .btn:hover { background:var(--bg-card-hover); color:var(--text-main); border-color:var(--accent); }\n    .btn.active { background:var(--accent); color:white; border-color:var(--accent); }\n    .btn.danger { border-color:var(--danger); color:var(--danger); }\n    .btn.danger:hover { background:var(--danger); color:white; }\n    [data-style=\"retro\"] .btn { background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; color:black; border-radius:0; box-shadow:none; }\n    [data-style=\"retro\"] .btn:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n    .fab-container { position:fixed; bottom:20px; right:20px; display:flex; gap:10px; z-index:1000; }\n    .fab { width:48px; height:48px; border-radius:50%; background:var(--bg-card); border:1px solid var(--border); color:var(--text-main); display:flex; align-items:center; justify-content:center; cursor:pointer; font-size:1.2rem; box-shadow:0 4px 12px rgba(0,0,0,0.3); transition:transform 0.2s; }\n    .fab:hover { transform:scale(1.1); color:var(--accent); }\n    [data-style=\"retro\"] .fab { border-radius:0; background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; box-shadow:none; color:black; }\n    [data-style=\"retro\"] .fab:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n\n    .player-list-container { overflow-y: auto; flex: 1; display: flex; flex-direction: column; gap: 0.5rem; padding-right: 5px; height: 100%; min-height: 0; }\n    .player-row { display: flex; flex-direction:column; padding: 0.5rem; background: var(--slot-bg); border-radius: 6px; border: 1px solid var(--border); }\n    .player-row-top { display:flex; align-items:center; justify-content:space-between; margin-bottom:4px; }\n    .player-head { width: 24px; height: 24px; border-radius: 4px; }\n    .player-name { font-weight: 600; font-size: 0.9rem; margin-left:8px; }\n    .pt-row { display:flex; justify-content:space-between; font-size:0.7rem; color:var(--text-muted); font-family:var(--font-mono); margin-top:2px; }\n    .pt-val { color:var(--text-main); }\n    ::-webkit-scrollbar { width: 6px; height: 6px; }\n    ::-webkit-scrollbar-track { background: transparent; }\n    ::-webkit-scrollbar-thumb { background: var(--border); border-radius: 3px; }\n    ::-webkit-scrollbar-thumb:hover { background: var(--text-muted); }\n    [data-style=\"retro\"] .player-row { border-radius: 0; border: 1px solid #808080; background: white; color: black; box-shadow: inset 1px 1px 2px rgba(0,0,0,0.2); }\n    [data-style=\"retro\"] .player-head { border-radius: 0; border: 1px solid black; }\n");
    private static final String INDEX_HTML = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><title>Server Monitor</title>\n    <script src=\"https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js\"></script>\n    <link href=\"https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;700&family=Inter:wght@400;600;800&display=swap\" rel=\"stylesheet\">\n    <style>\n        {{CSS}}\n        .container { max-width:1600px; margin:0 auto; padding:2rem; }\n        header { display:flex; justify-content:space-between; align-items:center; margin-bottom:2rem; padding-bottom:1rem; border-bottom:1px solid var(--border); }\n        h1 { font-weight:800; font-size:1.8rem; }\n        .admin-link { color:var(--text-muted); text-decoration:none; font-size:0.9rem; display:flex; align-items:center; gap:0.5rem; }\n        .admin-link:hover { color:var(--accent); }\n        .dashboard-grid { display:grid; grid-template-columns:repeat(4, 1fr); gap:1.5rem; margin-bottom:1.5rem; }\n        @media(max-width:1000px) { .dashboard-grid { grid-template-columns:repeat(2, 1fr); } }\n        @media(max-width:600px) { .dashboard-grid { grid-template-columns:1fr; } }\n        .col-1 { grid-column:span 1; } .col-2 { grid-column:span 2; }\n        @media(max-width:1000px) { .col-2 { grid-column:span 2; } } @media(max-width:600px) { .col-1, .col-2 { grid-column:span 1; } }\n        .card { background:var(--bg-card); border:var(--border-width) var(--border-style) var(--border); border-radius:var(--radius); padding:1.5rem; display:flex; flex-direction:column; justify-content:space-between; height:var(--card-height); box-shadow:var(--shadow); }\n        .card-header { font-size:0.875rem; color:var(--text-muted); text-transform:uppercase; letter-spacing:0.05em; margin-bottom:0.5rem; }\n        .card-value { font-size:2.5rem; font-weight:800; font-family:var(--font-mono); }\n        .card-sub { font-size:0.875rem; color:var(--text-muted); margin-top:auto; }\n        .chart-card { background:var(--bg-card); border:var(--border-width) var(--border-style) var(--border); border-radius:var(--radius); padding:1rem; height:var(--card-height); position:relative; display:flex; flex-direction:column; box-shadow:var(--shadow); }\n        [data-style=\"retro\"] .card, [data-style=\"retro\"] .chart-card { border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; border-radius:0; background:var(--bg-card); }\n        [data-style=\"retro\"] .controls { border-radius:0; border:2px groove white; }\n        .pie-card { padding:0.25rem!important; align-items:center; justify-content:center; }\n        .empty-slot { height:var(--card-height); visibility:hidden; }\n        .value-good { color:var(--success); } .value-warn { color:var(--warn); } .value-bad { color:var(--danger); }\n        .controls { display:flex; gap:0.5rem; margin-bottom:2rem; flex-wrap:wrap; background:var(--bg-card); padding:0.5rem; border-radius:var(--radius); width:fit-content; border:1px solid var(--border); }\n        .chart-legend { display:flex; justify-content:center; gap:1rem; margin-bottom:0.5rem; font-size:0.75rem; color:var(--text-muted); font-weight:600; text-transform:uppercase; }\n        .legend-item { display:flex; align-items:center; gap:0.4rem; }\n        .dot { width:8px; height:8px; border-radius:50%; } [data-style=\"retro\"] .dot { border-radius:0; border:1px solid black; }\n        .hidden { display:none!important; }\n        canvas { width:100%!important; height:100%!important; }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <header>\n            <h1>Server Monitor</h1>\n            <div><span id=\"lastUpdate\" style=\"margin-right:15px; color:var(--text-muted);\">Loading...</span><a href=\"/admin\" class=\"admin-link\">\u2699\ufe0f Layout</a></div>\n        </header>\n        <div class=\"controls\">\n            <button class=\"btn active\" onclick=\"setTimeRange(1)\">1 Min</button><button class=\"btn\" onclick=\"setTimeRange(5)\">5 Min</button>\n            <button class=\"btn\" onclick=\"setTimeRange(10)\">10 Min</button><button class=\"btn\" onclick=\"setTimeRange(30)\">30 Min</button>\n            <button class=\"btn\" onclick=\"setTimeRange(60)\">1 Hour</button><button class=\"btn\" onclick=\"setTimeRange(360)\">6 Hours</button>\n            <button class=\"btn\" onclick=\"setTimeRange(720)\">12 Hours</button><button class=\"btn\" onclick=\"setTimeRange(1440)\">24 Hours</button>\n        </div>\n        <div id=\"grid-container\" class=\"dashboard-grid\"></div>\n    </div>\n    <div class=\"fab-container\"><div class=\"fab\" onclick=\"toggleTheme()\">\u25d1</div><div class=\"fab\" onclick=\"toggleRetro()\">\ud83d\udcbe</div></div>\n    <script>\n        const renderPie = (id, title) => `<div style=\"height:100%; width:100%; display:flex; flex-direction:column; align-items:center; justify-content:center;\"><h3 style=\"color:var(--text-muted); font-size:0.75rem; text-transform:uppercase; margin-bottom:0.1rem; margin-top:0.1rem; height:18px;\">${title}</h3><div style=\"position:relative; width:100%; flex:1; min-height:0;\"><canvas id=\"${id}_canvas\"></canvas><div id=\"${id}_center\" style=\"position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); font-weight:bold; font-size:1rem; color:var(--text-main); pointer-events:none;\">--%</div></div></div>`;\n        const initPie = (id, color) => new Chart(document.getElementById(id+'_canvas'), { type:'doughnut', data:{ labels:['Used','Free'], datasets:[{ data:[1,1], backgroundColor:[color,'#27272a'], borderWidth:0, hoverOffset:4 }] }, options:{ cutout:'60%', responsive:true, maintainAspectRatio:false, layout:{padding:8}, plugins:{legend:{display:false},tooltip:{enabled:false}}, onHover:(e,els,chart)=>{ const ct=document.getElementById(id+'_center'); if(els.length>0){ const v=chart.data.datasets[0].data[els[0].index]; if(ct){ if(chart.data.datasets[0].data[0]!==1) { ct.innerText=Number.isInteger(v)?v:v.toFixed(1)+'%'; ct.style.color=els[0].index===0?color:'var(--text-muted)'; } } } else if(ct && ct.dataset.default){ ct.innerText=ct.dataset.default; ct.style.color='var(--text-main)'; } } } });\n        const renderGraph = (id, title, color) => `<div class=\"chart-legend\"><div class=\"legend-item\"><span class=\"dot\" style=\"background:${color}\"></span>${title}</div></div><div style=\"flex:1; position:relative; min-height:0; width:100%;\"><canvas id=\"${id}_canvas\"></canvas></div>`;\n        const fmtTime = (s) => { if(s<60)return s+\"s\"; if(s<3600)return Math.floor(s/60)+\"m\"; return Math.floor(s/3600)+\"h \"+Math.floor((s%3600)/60)+\"m\"; };\n\n        let widgetConfigs = { custom_graph: { tps:true, cpu:true, ram:true, players:true } };\n        const WIDGETS = {\n            'tps_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">Performance</div><div class=\"card-value\" id=\"${id}_val\">--</div><div class=\"card-sub\">Target: 20.0</div>`, update: (id,d) => { const el=document.getElementById(id+'_val'); if(el){ el.innerText=d.tps.toFixed(1); el.className='card-value '+(d.tps>=18?'value-good':(d.tps>=15?'value-warn':'value-bad')); } } },\n            'cpu_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">CPU Load</div><div class=\"card-value\" id=\"${id}_val\">--%</div><div class=\"card-sub\">System Process</div>`, update: (id,d) => document.getElementById(id+'_val').innerText=d.cpuLoad.toFixed(0)+'%' },\n            'ram_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">Memory</div><div class=\"card-value\" id=\"${id}_val\">--%</div><div class=\"card-sub\" id=\"${id}_sub\">-- MB</div>`, update: (id,d) => { document.getElementById(id+'_val').innerText=d.ramUsagePercent.toFixed(0)+'%'; document.getElementById(id+'_sub').innerText=`${d.ramUsedMB.toFixed(0)} / ${d.ramTotalMB.toFixed(0)} MB`; } },\n            'players_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">Online</div><div class=\"card-value\" id=\"${id}_val\">--</div><div class=\"card-sub\" id=\"${id}_sub\">Max: --</div>`, update: (id,d) => { document.getElementById(id+'_val').innerText=d.onlinePlayers; document.getElementById(id+'_sub').innerText='Max: '+d.maxPlayers; } },\n            'storage_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">Disk</div><div class=\"card-value\" id=\"${id}_val\">--%</div><div class=\"card-sub\" id=\"${id}_sub\">-- GB free</div>`, update: (id,d) => { document.getElementById(id+'_val').innerText=d.storageUsagePercent.toFixed(0)+'%'; document.getElementById(id+'_sub').innerText=(d.storageTotalGB-d.storageUsedGB).toFixed(1)+' GB free'; } },\n            'uptime_card': { type:'card', size:'col-1', render: (id) => `<div class=\"card-header\">Uptime</div><div class=\"card-value\" id=\"${id}_val\" style=\"font-size:1.6rem\">--</div><div class=\"card-sub\">Since Restart</div>`, update: (id,d) => { const s=d.uptimeSeconds||0; const d1=Math.floor(s/86400),h=Math.floor((s%86400)/3600),m=Math.floor((s%3600)/60); document.getElementById(id+'_val').innerText=(d1>0?d1+\"d \":\"\")+h+\"h \"+m+\"m\"; } },\n            'tps_pie': { type:'doughnut', size:'col-1', render: (id) => renderPie(id,'TPS'), init: (id) => initPie(id,'#6366f1'), update: (i,d) => { i.data.datasets[0].data=[d.tps, Math.max(0,20-d.tps)]; i.update(); const el=document.getElementById(i.canvas.id.replace('_canvas','_center')); if(el){ el.innerText=d.tps.toFixed(1); el.dataset.default=el.innerText; } } },\n            'cpu_pie': { type:'doughnut', size:'col-1', render: (id) => renderPie(id,'CPU'), init: (id) => initPie(id,'#f59e0b'), update: (i,d) => { i.data.datasets[0].data=[d.cpuLoad, Math.max(0,100-d.cpuLoad)]; i.update(); const el=document.getElementById(i.canvas.id.replace('_canvas','_center')); if(el){ el.innerText=d.cpuLoad.toFixed(0)+'%'; el.dataset.default=el.innerText; } } },\n            'ram_pie': { type:'doughnut', size:'col-1', render: (id) => renderPie(id,'RAM'), init: (id) => initPie(id,'#10b981'), update: (i,d) => { i.data.datasets[0].data=[d.ramUsagePercent, Math.max(0,100-d.ramUsagePercent)]; i.update(); const el=document.getElementById(i.canvas.id.replace('_canvas','_center')); if(el){ el.innerText=d.ramUsagePercent.toFixed(0)+'%'; el.dataset.default=el.innerText; } } },\n            'players_pie': { type:'doughnut', size:'col-1', render: (id) => renderPie(id,'Players'), init: (id) => initPie(id,'#ef4444'), update: (i,d) => { i.data.datasets[0].data=[d.onlinePlayers, Math.max(0,d.maxPlayers-d.onlinePlayers)]; i.update(); const el=document.getElementById(i.canvas.id.replace('_canvas','_center')); if(el){ el.innerText=d.onlinePlayers; el.dataset.default=el.innerText; } } },\n            'storage_pie': { type:'doughnut', size:'col-1', render: (id) => renderPie(id,'Storage'), init: (id) => initPie(id,'#6366f1'), update: (i,d) => { i.data.datasets[0].data=[d.storageUsagePercent, 100-d.storageUsagePercent]; i.update(); const el=document.getElementById(i.canvas.id.replace('_canvas','_center')); if(el){ el.innerText=d.storageUsagePercent.toFixed(0)+'%'; el.dataset.default=el.innerText; } } },\n            'uptime_pie': {\n                type: 'doughnut', size: 'col-1', render: (id) => renderPie(id, 'Uptime (24h)'),\n                init: (id) => {\n                    const ctx = document.getElementById(id+'_canvas');\n                    return new Chart(ctx, {\n                        type: 'doughnut',\n                        data: { labels: ['Online', 'Offline'], datasets: [{ data: [1, 0], backgroundColor: ['#06b6d4', '#27272a'], borderWidth: 0, hoverOffset: 4 }] },\n                        options: {\n                            cutout: '60%', responsive: true, maintainAspectRatio: false, layout: { padding: 8 },\n                            plugins: { legend: {display:false}, tooltip: {enabled: false} },\n                            onHover: (e, els, chart) => {\n                                const ct = document.getElementById(id+'_center');\n                                if (els.length > 0) {\n                                   if(ct && ct.dataset.sub) { ct.innerText = ct.dataset.sub; ct.style.color = '#06b6d4'; }\n                                } else {\n                                   if(ct && ct.dataset.default) { ct.innerText = ct.dataset.default; ct.style.color = 'var(--text-main)'; }\n                                }\n                            }\n                        }\n                    });\n                },\n                update: (inst, d) => {\n                    const limit = 86400;\n                    const s = d.uptimeSeconds || 0;\n                    const capped = Math.min(s, limit);\n                    const rem = limit - capped;\n\n                    inst.data.datasets[0].data = [capped, rem];\n                    inst.update();\n\n                    const el = document.getElementById(inst.canvas.id.replace('_canvas', '_center'));\n                    if(el) {\n                        const pct = ((capped / limit) * 100).toFixed(0) + '%';\n                        const h = Math.floor(capped / 3600);\n                        const m = Math.floor((capped % 3600) / 60);\n                        el.innerText = pct;\n                        el.dataset.default = pct;\n                        el.dataset.sub = h + 'h ' + m + 'm';\n                    }\n                }\n            },\n            'multi_pie': {\n                type: 'doughnut', size: 'col-1', render: (id) => renderPie(id, 'Overview'),\n                init: (id) => {\n                    const ctx = document.getElementById(id+'_canvas'); const centerText = document.getElementById(id+'_center');\n                    return new Chart(ctx, {\n                        type: 'doughnut',\n                        data: { labels: ['TPS', 'CPU', 'RAM', 'Players'], datasets: [ { data: [1, 1], backgroundColor: ['#6366f1', '#27272a'], borderWidth: 0, weight: 1 }, { data: [1, 1], backgroundColor: ['#f59e0b', '#27272a'], borderWidth: 0, weight: 1 }, { data: [1, 1], backgroundColor: ['#10b981', '#27272a'], borderWidth: 0, weight: 1 }, { data: [1, 1], backgroundColor: ['#ef4444', '#27272a'], borderWidth: 0, weight: 1 } ] },\n                        options: { responsive: true, maintainAspectRatio: false, cutout: '30%', layout: { padding: 8 }, plugins: { legend: {display:false}, tooltip: {enabled: false} },\n                            onHover: (event, elements, chart) => {\n                                if (elements && elements.length > 0) {\n                                    const dsIndex = elements[0].datasetIndex; const labels = ['TPS', 'CPU', 'RAM', 'Players']; const colors = ['#6366f1', '#f59e0b', '#10b981', '#ef4444']; const val = chart.data.datasets[dsIndex].data[0]; let txt = \"\"; if(dsIndex === 0) txt = `TPS: ${val.toFixed(1)}`; else if(dsIndex === 3) txt = `P: ${val}`; else txt = `${labels[dsIndex]}: ${val.toFixed(0)}%`; if(centerText) { centerText.innerText = txt; centerText.style.color = colors[dsIndex]; centerText.style.fontSize = \"0.75rem\"; }\n                                } else { if(centerText) { centerText.innerText = \"All\"; centerText.style.color = \"var(--text-main)\"; centerText.style.fontSize = \"1rem\"; } }\n                            }\n                        }\n                    });\n                },\n                update: (inst, d) => { inst.data.datasets[0].data = [d.tps, Math.max(0, 20-d.tps)]; inst.data.datasets[1].data = [d.cpuLoad, Math.max(0, 100-d.cpuLoad)]; inst.data.datasets[2].data = [d.ramUsagePercent, Math.max(0, 100-d.ramUsagePercent)]; inst.data.datasets[3].data = [d.onlinePlayers, Math.max(0, d.maxPlayers - d.onlinePlayers)]; inst.update(); }\n            },\n            'tps_graph': { type:'graph', size:'col-2', config:{label:'TPS',color:'#6366f1',max:22}, key:'tps', render:(id)=>renderGraph(id,'TPS History','#6366f1') },\n            'cpu_graph': { type:'graph', size:'col-2', config:{label:'CPU %',color:'#f59e0b',max:100}, key:'cpuLoad', render:(id)=>renderGraph(id,'CPU History','#f59e0b') },\n            'ram_graph': { type:'graph', size:'col-2', config:{label:'RAM %',color:'#10b981',max:100}, key:'ramUsagePercent', render:(id)=>renderGraph(id,'RAM History','#10b981') },\n            'players_graph': { type:'graph', size:'col-2', config:{label:'Players',color:'#ef4444',step:true}, key:'onlinePlayers', render:(id)=>renderGraph(id,'Player History','#ef4444') },\n            'storage_graph': { type:'graph', size:'col-2', config:{label:'Storage %',color:'#8b5cf6',max:100}, key:'storageUsagePercent', render:(id)=>renderGraph(id,'Storage History','#8b5cf6') },\n            'uptime_graph': { type:'graph', size:'col-2', config:{label:'Server Status',color:'#10b981',step:true,max:1.2}, key:'CONST_1', render:(id)=>renderGraph(id,'Heartbeat (1=Online)','#10b981') },\n            'custom_graph': { type:'graph', size:'col-2',\n                render: (id) => { const c=(widgetConfigs&&widgetConfigs.custom_graph)?widgetConfigs.custom_graph:{tps:true,cpu:true,ram:true,players:true}; return `<div class=\"chart-legend\"><div class=\"legend-item ${!c.tps?'hidden':''}\"><span class=\"dot\" style=\"background:#6366f1\"></span>TPS</div><div class=\"legend-item ${!c.cpu?'hidden':''}\"><span class=\"dot\" style=\"background:#f59e0b\"></span>CPU</div><div class=\"legend-item ${!c.ram?'hidden':''}\"><span class=\"dot\" style=\"background:#10b981\"></span>RAM</div><div class=\"legend-item ${!c.players?'hidden':''}\"><span class=\"dot\" style=\"background:#ef4444\"></span>Players</div></div><div style=\"flex:1; position:relative; min-height:0; width:100%;\"><canvas id=\"${id}_canvas\"></canvas></div>`; },\n                init: (id) => { const c=(widgetConfigs&&widgetConfigs.custom_graph)?widgetConfigs.custom_graph:{tps:true,cpu:true,ram:true,players:true}; return new Chart(document.getElementById(id+'_canvas'), { type:'line', data:{ labels:[], datasets:[ {label:'TPS',borderColor:'#6366f1',backgroundColor:'#6366f120',data:[],yAxisID:'y_right',tension:0.3,hidden:!c.tps}, {label:'CPU',borderColor:'#f59e0b',backgroundColor:'transparent',data:[],yAxisID:'y_left',tension:0.3,hidden:!c.cpu}, {label:'RAM',borderColor:'#10b981',backgroundColor:'transparent',data:[],yAxisID:'y_left',tension:0.3,hidden:!c.ram}, {label:'Players',borderColor:'#ef4444',backgroundColor:'transparent',data:[],yAxisID:'y_right',stepped:true,hidden:!c.players} ] }, options:{ responsive:true, maintainAspectRatio:false, animation:false, interaction:{mode:'index',intersect:false}, plugins:{legend:{display:false}}, scales:{ x:{ticks:{maxTicksLimit:8,maxRotation:0}}, y_left:{type:'linear',display:true,position:'left',min:0,max:100,grid:{color:'#27272a'},title:{display:true,text:'%'}}, y_right:{type:'linear',display:true,position:'right',min:0,suggestedMax:20,grid:{drawOnChartArea:false},title:{display:true,text:'Val'}} } } }); },\n                update: (c,d) => { if(!d)return; c.data.datasets[0].data.push(d.tps); c.data.datasets[1].data.push(d.cpuLoad); c.data.datasets[2].data.push(d.ramUsagePercent); c.data.datasets[3].data.push(d.onlinePlayers); if(c.data.labels.length>100)c.data.datasets.forEach(s=>s.data.shift()); }\n            },\n            'player_list': {\n                type: 'custom', size: 'col-2',\n                render: (id) => `<div class=\"card-header\" style=\"margin-bottom:0.5rem; display:flex; justify-content:space-between;\"><span>Online Players</span><span style=\"font-size:0.7rem\">Ping / Pos</span></div><div id=\"${id}_list\" class=\"player-list-container\"></div>`,\n                update: (id, d) => {\n                    const c = document.getElementById(id+'_list'); if(!c) return;\n                    const list = d.playerList || [];\n                    if(list.length === 0) { c.innerHTML = '<div style=\"color:var(--text-muted); text-align:center; margin-top:2rem;\">No players online</div>'; return; }\n                    let html = '';\n                    list.forEach(p => {\n                        html += `<div class=\"player-row\">\n                            <div class=\"player-row-top\">\n                                <div style=\"display:flex; align-items:center;\">\n                                    <img src=\"https://minotar.net/avatar/${p.name}/24.png\" class=\"player-head\">\n                                    <span class=\"player-name\">${p.name} ${p.isAfk ? '<span style=\"color:var(--warn); margin-left:4px; font-size:0.8rem;\">[AFK]</span>' : ''}</span>\n                                </div>\n                                <div style=\"text-align:right; font-size:0.8rem; color:var(--text-muted); font-family:var(--font-mono);\">\n                                    <span style=\"color:${p.ping < 100 ? 'var(--success)' : (p.ping < 200 ? 'var(--warn)' : 'var(--danger)')}\">${p.ping}ms</span>\n                                    <span style=\"margin-left:8px; opacity:0.7;\">${p.x}, ${p.y}, ${p.z}</span>\n                                </div>\n                            </div>\n                            <div class=\"pt-row\">\n                                <div>Total: <span class=\"pt-val\">${fmtTime(p.playtimeTotal)}</span></div>\n                                <div>Sess: <span class=\"pt-val\">${fmtTime(p.playtimeSession)}</span></div>\n                                <div>Today: <span class=\"pt-val\">${fmtTime(p.playtimeToday)}</span></div>\n                                <div>Yest: <span class=\"pt-val\">${fmtTime(p.playtimeYesterday)}</span></div>\n                            </div>\n                        </div>`;\n                    });\n                    c.innerHTML = html;\n                }\n            }\n        };\n\n        let activeCharts = {}; let currentLayout = []; let currentRangeMinutes = 1; let lastTimestamp = 0; let maxDataPoints = 200;\n        Chart.defaults.color='#71717a'; Chart.defaults.borderColor='#27272a';\n\n        async function initDashboard() {\n            try { const sRes=await fetch('/api/config/widgets'); if(sRes.ok){ const d=await sRes.json(); if(d)widgetConfigs=d; } const lRes=await fetch('/api/config/layout'); if(lRes.ok)currentLayout=await lRes.json(); } catch(e){}\n            const c = document.getElementById('grid-container'); c.innerHTML='';\n            let i=0;\n            while(i<currentLayout.length) {\n                const k = currentLayout[i];\n                if(k === 'HIDDEN_SLOT') { i++; continue; }\n                try {\n                    const def = WIDGETS[k];\n                    if(!def) { const e=document.createElement('div'); e.className='empty-slot col-1'; c.appendChild(e); i++; continue; }\n                    const uid = `w_${i}_${k}`; const div=document.createElement('div');\n                    let cls=(def.type==='card'?'card ':'chart-card ')+def.size; if(def.type==='doughnut')cls+=' pie-card';\n                    div.className=cls; div.id=uid;\n                    if(def.render) div.innerHTML=def.render(uid); else if(def.type==='graph') div.innerHTML=`<canvas id=\"${uid}_canvas\"></canvas>`;\n                    c.appendChild(div);\n                    if(k==='custom_graph' || k==='player_list') activeCharts[uid]={type:'custom',instance:def.init?def.init(uid):null,def:def,buffer:[]};\n                    else if(def.type==='card'||def.type==='doughnut'||k==='multi_pie') { if(def.type==='doughnut'||k==='multi_pie') activeCharts[uid]={type:'doughnut',instance:def.init(uid),def:def}; else activeCharts[uid]={type:'card',def:def}; }\n                    else if(def.type==='graph') { const ctx=document.getElementById(uid+'_canvas'); const ch=new Chart(ctx,{type:'line',data:{labels:[],datasets:[{label:def.config.label,data:[],borderColor:def.config.color,backgroundColor:def.config.color+'20',fill:true,tension:def.config.step?0.1:0.4,stepped:def.config.step}]},options:{responsive:true,maintainAspectRatio:false,animation:false,interaction:{mode:'index',intersect:false},plugins:{legend:{display:false}},scales:{x:{ticks:{maxTicksLimit:8,maxRotation:0}},y:{beginAtZero:true,max:def.config.max}}}}); activeCharts[uid]={type:'graph',instance:ch,key:def.key,def:def,buffer:[]}; }\n                } catch(e){} i++;\n            }\n            loadHistory(); setInterval(fetchLatest, 2000);\n        }\n\n        function updateWidgets(data, isHist=false) {\n            if(!data)return; const arr=Array.isArray(data)?data:[data]; if(arr.length===0)return;\n            const lat=arr[arr.length-1];\n            const isR=document.body.getAttribute('data-style')==='retro'; const isL=document.body.getAttribute('data-theme')==='light';\n            if(isR){Chart.defaults.borderColor='#000';Chart.defaults.color='#000';} else if(isL){Chart.defaults.borderColor='#e4e4e7';Chart.defaults.color='#71717a';} else {Chart.defaults.borderColor='#27272a';Chart.defaults.color='#71717a';}\n\n            Object.keys(activeCharts).forEach(id => {\n                const o=activeCharts[id];\n                try {\n                    if(o.type==='card') { if(lat) o.def.update(id,lat); }\n                    else if(o.type==='doughnut') { if(lat) { o.def.update(o.instance,lat); o.instance.data.datasets[0].backgroundColor[1]=isR?'#fff':(isL?'#e4e4e7':'#27272a'); o.instance.update('none'); } }\n                    else if(o.type==='custom') {\n                        if(o.def.update) {\n                            if(o.instance) {\n                                const ch=o.instance;\n                                if(isHist) o.buffer=arr; else { if(lat){ o.buffer.push(lat); while(o.buffer.length>maxDataPoints)o.buffer.shift(); } }\n                                const buf=o.buffer; ch.data.labels=buf.map(d=>new Date(d.timestamp).toLocaleTimeString());\n                                ch.data.datasets[0].data=buf.map(d=>d.tps); ch.data.datasets[1].data=buf.map(d=>d.cpuLoad); ch.data.datasets[2].data=buf.map(d=>d.ramUsagePercent); ch.data.datasets[3].data=buf.map(d=>d.onlinePlayers);\n                                if(isR) { ch.options.scales.x.grid.color='#808080'; if(ch.options.scales.y_left)ch.options.scales.y_left.grid.color='#808080'; ch.options.elements.line.tension=0; }\n                                else { ch.options.scales.x.grid.color=isL?'#e4e4e7':'#27272a'; if(ch.options.scales.y_left)ch.options.scales.y_left.grid.color=isL?'#e4e4e7':'#27272a'; ch.options.elements.line.tension=0.4; }\n                                ch.update('none');\n                            } else {\n                                if(lat) o.def.update(id, lat);\n                            }\n                        }\n                    }\n                    else if(o.type==='graph') {\n                        const ch=o.instance;\n                        if(isHist) o.buffer=arr; else { if(lat){ o.buffer.push(lat); while(o.buffer.length>maxDataPoints)o.buffer.shift(); } }\n                        const buf=o.buffer; ch.data.labels=buf.map(d=>new Date(d.timestamp).toLocaleTimeString());\n\n                        if(o.key === 'CONST_1') ch.data.datasets[0].data = buf.map(d => (d.uptimeSeconds > 0 ? 1 : 0));\n                        else ch.data.datasets[0].data=buf.map(d=>d[o.key]);\n\n                        if(isR) { ch.options.scales.x.grid.color='#808080'; if(ch.options.scales.y_left)ch.options.scales.y_left.grid.color='#808080'; ch.options.elements.line.tension=0; }\n                        else { ch.options.scales.x.grid.color=isL?'#e4e4e7':'#27272a'; if(ch.options.scales.y_left)ch.options.scales.y_left.grid.color=isL?'#e4e4e7':'#27272a'; if(o.def&&(!o.def.config||!o.def.config.step)) ch.options.elements.line.tension=0.4; }\n                        ch.update('none');\n                    }\n                } catch(e){}\n            });\n            if(arr.length>0) { lastTimestamp=arr[arr.length-1].timestamp; document.getElementById('lastUpdate').innerText=\"Live: \"+new Date(lastTimestamp).toLocaleTimeString(); }\n        }\n\n        function toggleTheme() { const b=document.body; const n=b.getAttribute('data-theme')==='light'?'dark':'light'; b.setAttribute('data-theme',n); localStorage.setItem('theme',n); }\n        function toggleRetro() { const b=document.body; const n=b.getAttribute('data-style')==='retro'?'modern':'retro'; b.setAttribute('data-style',n); localStorage.setItem('style',n); }\n        document.body.setAttribute('data-theme', localStorage.getItem('theme')||'dark');\n        document.body.setAttribute('data-style', localStorage.getItem('style')||'modern');\n\n        async function loadHistory() { try{const r=await fetch(`/api/history?minutes=${currentRangeMinutes}`); const d=await r.json(); updateWidgets(d,true);}catch(e){} }\n        async function fetchLatest() { try{const r=await fetch('/api/latest'); const d=await r.json(); if(d&&d.timestamp>lastTimestamp)updateWidgets([d],false);}catch(e){} }\n        function setTimeRange(m) { currentRangeMinutes=m; maxDataPoints=Math.ceil(m*12*1.0); document.querySelectorAll('.controls .btn').forEach(b=>b.classList.remove('active')); document.querySelectorAll('.controls .btn').forEach(b=>{if(b.getAttribute('onclick').includes(`(${m})`))b.classList.add('active');}); loadHistory(); }\n        document.addEventListener('DOMContentLoaded', ()=>{ setTimeRange(10); initDashboard(); });\n    </script>\n</body>\n</html>\n".replace("{{CSS}}", "    :root {\n        --bg-body:#09090b; --bg-card:#18181b; --bg-card-hover:#27272a; --text-main:#fafafa; --text-muted:#a1a1aa;\n        --accent:#6366f1; --accent-glow:rgba(99,102,241,0.15); --border:#27272a; --slot-bg:#121214;\n        --font-main:'Inter',sans-serif; --font-mono:'JetBrains Mono',monospace;\n        --radius:12px; --shadow:none; --border-style:solid; --border-width:1px;\n        --success:#10b981; --warn:#f59e0b; --danger:#ef4444;\n        --card-height: 240px;\n    }\n    [data-theme=\"light\"] {\n        --bg-body:#f4f4f5; --bg-card:#ffffff; --bg-card-hover:#f4f4f5; --text-main:#18181b; --text-muted:#71717a;\n        --accent:#4f46e5; --accent-glow:rgba(79,70,229,0.1); --border:#e4e4e7; --slot-bg:#f4f4f5; --shadow:0 1px 3px rgba(0,0,0,0.1);\n    }\n    [data-style=\"retro\"] {\n        --bg-body:#008080; --bg-card:#c0c0c0; --bg-card-hover:#c0c0c0; --text-main:#000000; --text-muted:#404040;\n        --accent:#000080; --accent-glow:transparent; --border:#dfdfdf; --slot-bg:#ffffff;\n        --font-main:'Tahoma',sans-serif; --font-mono:'Courier New',monospace;\n        --radius:0px; --border-style:solid; --border-width:2px;\n        --success:#008000; --warn:#808000; --danger:#ff0000;\n    }\n    * { box-sizing:border-box; margin:0; padding:0; }\n    body { background-color:var(--bg-body); color:var(--text-main); font-family:var(--font-main); min-height:100vh; transition:background 0.3s, color 0.3s; }\n    .btn { background:var(--bg-card); border:1px solid var(--border); color:var(--text-muted); padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:600; transition:all 0.2s; white-space:nowrap; }\n    .btn:hover { background:var(--bg-card-hover); color:var(--text-main); border-color:var(--accent); }\n    .btn.active { background:var(--accent); color:white; border-color:var(--accent); }\n    .btn.danger { border-color:var(--danger); color:var(--danger); }\n    .btn.danger:hover { background:var(--danger); color:white; }\n    [data-style=\"retro\"] .btn { background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; color:black; border-radius:0; box-shadow:none; }\n    [data-style=\"retro\"] .btn:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n    .fab-container { position:fixed; bottom:20px; right:20px; display:flex; gap:10px; z-index:1000; }\n    .fab { width:48px; height:48px; border-radius:50%; background:var(--bg-card); border:1px solid var(--border); color:var(--text-main); display:flex; align-items:center; justify-content:center; cursor:pointer; font-size:1.2rem; box-shadow:0 4px 12px rgba(0,0,0,0.3); transition:transform 0.2s; }\n    .fab:hover { transform:scale(1.1); color:var(--accent); }\n    [data-style=\"retro\"] .fab { border-radius:0; background:#c0c0c0; border-top:2px solid #fff; border-left:2px solid #fff; border-right:2px solid #000; border-bottom:2px solid #000; box-shadow:none; color:black; }\n    [data-style=\"retro\"] .fab:active { border-top:2px solid #000; border-left:2px solid #000; border-right:2px solid #fff; border-bottom:2px solid #fff; }\n\n    .player-list-container { overflow-y: auto; flex: 1; display: flex; flex-direction: column; gap: 0.5rem; padding-right: 5px; height: 100%; min-height: 0; }\n    .player-row { display: flex; flex-direction:column; padding: 0.5rem; background: var(--slot-bg); border-radius: 6px; border: 1px solid var(--border); }\n    .player-row-top { display:flex; align-items:center; justify-content:space-between; margin-bottom:4px; }\n    .player-head { width: 24px; height: 24px; border-radius: 4px; }\n    .player-name { font-weight: 600; font-size: 0.9rem; margin-left:8px; }\n    .pt-row { display:flex; justify-content:space-between; font-size:0.7rem; color:var(--text-muted); font-family:var(--font-mono); margin-top:2px; }\n    .pt-val { color:var(--text-main); }\n    ::-webkit-scrollbar { width: 6px; height: 6px; }\n    ::-webkit-scrollbar-track { background: transparent; }\n    ::-webkit-scrollbar-thumb { background: var(--border); border-radius: 3px; }\n    ::-webkit-scrollbar-thumb:hover { background: var(--text-muted); }\n    [data-style=\"retro\"] .player-row { border-radius: 0; border: 1px solid #808080; background: white; color: black; box-shadow: inset 1px 1px 2px rgba(0,0,0,0.2); }\n    [data-style=\"retro\"] .player-head { border-radius: 0; border: 1px solid black; }\n");

    public WebServerService(ServerDataManager dataManager, ServerMonitorConfig config) {
        this.dataManager = dataManager;
        this.config = config;
    }

    public void start() {
        if (!this.config.webServerEnabled) {
            return;
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.config.webServerHost, this.config.webServerPort), 0);
            this.server.createContext("/", exchange -> {
                if (!exchange.getRequestURI().getPath().equals("/")) {
                    exchange.sendResponseHeaders(404, -1L);
                    return;
                }
                String html = INDEX_HTML.replace("Loading...", ServerMonitorLocale.get("web.loading")).replace("Live: ", ServerMonitorLocale.get("web.live")).replace("Performance", ServerMonitorLocale.get("web.head.tps")).replace("CPU Load", ServerMonitorLocale.get("web.head.cpu")).replace("Memory", ServerMonitorLocale.get("web.head.ram")).replace("<span>Online Players</span>", "<span>" + ServerMonitorLocale.get("web.list.header") + "</span>").replace("Online", ServerMonitorLocale.get("web.head.players")).replace("Disk", ServerMonitorLocale.get("web.head.storage")).replace("Uptime", ServerMonitorLocale.get("web.head.uptime")).replace("Target: 20.0", ServerMonitorLocale.get("web.sub.target")).replace("System Process", ServerMonitorLocale.get("web.sub.system")).replace("Since Restart", ServerMonitorLocale.get("web.sub.restart")).replace("GB free", ServerMonitorLocale.get("cmd.gb_free")).replace("Ping / Pos", ServerMonitorLocale.get("web.list.ping_pos")).replace("Total:", ServerMonitorLocale.get("web.list.total") + ":").replace("Sess:", ServerMonitorLocale.get("web.list.sess") + ":").replace("Today:", ServerMonitorLocale.get("web.list.today") + ":").replace("Yest:", ServerMonitorLocale.get("web.list.yest") + ":").replace("No players online", ServerMonitorLocale.get("web.list.none")).replace("'TPS'", "'" + ServerMonitorLocale.get("web.pie.tps") + "'").replace("'CPU'", "'" + ServerMonitorLocale.get("web.pie.cpu") + "'").replace("'RAM'", "'" + ServerMonitorLocale.get("web.pie.ram") + "'").replace("'Players'", "'" + ServerMonitorLocale.get("web.pie.players") + "'").replace("'Storage'", "'" + ServerMonitorLocale.get("web.pie.storage") + "'").replace("'Uptime (24h)'", "'" + ServerMonitorLocale.get("web.pie.uptime") + "'").replace("'Overview'", "'" + ServerMonitorLocale.get("web.pie.multi") + "'").replace("['Used','Free']", "['" + ServerMonitorLocale.get("web.legend.used") + "','" + ServerMonitorLocale.get("web.legend.free") + "']").replace("['Online', 'Offline']", "['" + ServerMonitorLocale.get("web.legend.online") + "','" + ServerMonitorLocale.get("web.legend.offline") + "']").replace("['TPS', 'CPU', 'RAM', 'Players']", "['" + ServerMonitorLocale.get("web.legend.tps") + "','" + ServerMonitorLocale.get("web.legend.cpu") + "','" + ServerMonitorLocale.get("web.legend.ram") + "','" + ServerMonitorLocale.get("web.legend.players") + "']").replace("txt = \"TPS: \"", "txt = \"" + ServerMonitorLocale.get("web.legend.tps") + ": \"").replace("TPS History", ServerMonitorLocale.get("web.graph.tps")).replace("CPU History", ServerMonitorLocale.get("web.graph.cpu")).replace("RAM History", ServerMonitorLocale.get("web.graph.ram")).replace("Player History", ServerMonitorLocale.get("web.graph.players")).replace("Storage History", ServerMonitorLocale.get("web.graph.storage")).replace("Heartbeat (1=Online)", ServerMonitorLocale.get("web.graph.uptime")).replace("Combined Monitor", ServerMonitorLocale.get("web.graph.combined")).replace("name:'TPS'", "name:'" + ServerMonitorLocale.get("web.pie.tps") + "'").replace("name:'CPU'", "name:'" + ServerMonitorLocale.get("web.pie.cpu") + "'").replace("name:'RAM'", "name:'" + ServerMonitorLocale.get("web.pie.ram") + "'").replace("name:'Players'", "name:'" + ServerMonitorLocale.get("web.pie.players") + "'").replace("name:'Storage'", "name:'" + ServerMonitorLocale.get("web.pie.storage") + "'").replace("name:'Uptime'", "name:'" + ServerMonitorLocale.get("web.pie.uptime") + "'").replace("name:'TPS Pie'", "name:'" + ServerMonitorLocale.get("web.pie.tps") + " Pie'").replace("name:'CPU Pie'", "name:'" + ServerMonitorLocale.get("web.pie.cpu") + " Pie'").replace("name:'RAM Pie'", "name:'" + ServerMonitorLocale.get("web.pie.ram") + " Pie'").replace("name:'Players Pie'", "name:'" + ServerMonitorLocale.get("web.pie.players") + " Pie'").replace("name:'Storage Pie'", "name:'" + ServerMonitorLocale.get("web.pie.storage") + " Pie'").replace("name:'Uptime Pie'", "name:'" + ServerMonitorLocale.get("web.pie.uptime") + " Pie'").replace("name:'Multi Pie'", "name:'" + ServerMonitorLocale.get("web.pie.multi") + "'").replace("name:'TPS History'", "name:'" + ServerMonitorLocale.get("web.graph.tps") + "'").replace("name:'CPU History'", "name:'" + ServerMonitorLocale.get("web.graph.cpu") + "'").replace("name:'RAM History'", "name:'" + ServerMonitorLocale.get("web.graph.ram") + "'").replace("name:'Player History'", "name:'" + ServerMonitorLocale.get("web.graph.players") + "'").replace("name:'Storage History'", "name:'" + ServerMonitorLocale.get("web.graph.storage") + "'").replace("name:'Uptime Status'", "name:'" + ServerMonitorLocale.get("web.graph.uptime") + "'").replace("name:'Player List'", "name:'" + ServerMonitorLocale.get("adm.widget.playerlist") + "'");
                this.sendHtml(exchange, html);
            });
            this.server.createContext("/login", exchange -> {
                if (this.checkAuth(exchange)) {
                    this.redirect(exchange, "/admin");
                    return;
                }
                String html = LOGIN_HTML.replace("Admin Login", ServerMonitorLocale.get("adm.login.title")).replace(">Login<", ">" + ServerMonitorLocale.get("adm.login.btn") + "<").replace("Username", ServerMonitorLocale.get("adm.login.user")).replace("Password", ServerMonitorLocale.get("adm.login.pass")).replace("Back to Dashboard", ServerMonitorLocale.get("adm.login.back"));
                this.sendHtml(exchange, html);
            });
            this.server.createContext("/admin", exchange -> {
                if (!this.checkAuth(exchange)) {
                    this.redirect(exchange, "/login");
                    return;
                }
                String html = ADMIN_HTML.replace("Layout Designer", ServerMonitorLocale.get("adm.panel.title")).replace(">Save<", ">" + ServerMonitorLocale.get("adm.btn.save") + "<").replace("To Dashboard", ServerMonitorLocale.get("adm.btn.dash")).replace("Logout", ServerMonitorLocale.get("adm.btn.logout")).replace("Available Widgets", ServerMonitorLocale.get("adm.sidebar.title")).replace("Active Dashboard (4x8 Grid)", ServerMonitorLocale.get("adm.grid.title")).replace("Saved!", ServerMonitorLocale.get("adm.toast.saved")).replace("Configure Widget", ServerMonitorLocale.get("adm.modal.title")).replace("Cancel", ServerMonitorLocale.get("adm.modal.cancel")).replace("Show ", ServerMonitorLocale.get("adm.modal.show") + " ").replace("name:'TPS'", "name:'" + ServerMonitorLocale.get("web.pie.tps") + "'").replace("name:'CPU'", "name:'" + ServerMonitorLocale.get("web.pie.cpu") + "'").replace("name:'RAM'", "name:'" + ServerMonitorLocale.get("web.pie.ram") + "'").replace("name:'Players'", "name:'" + ServerMonitorLocale.get("web.pie.players") + "'").replace("name:'Storage'", "name:'" + ServerMonitorLocale.get("web.pie.storage") + "'").replace("name:'Uptime'", "name:'" + ServerMonitorLocale.get("web.pie.uptime") + "'").replace("name:'TPS Pie'", "name:'" + ServerMonitorLocale.get("web.pie.tps") + " Pie'").replace("name:'CPU Pie'", "name:'" + ServerMonitorLocale.get("web.pie.cpu") + " Pie'").replace("name:'RAM Pie'", "name:'" + ServerMonitorLocale.get("web.pie.ram") + " Pie'").replace("name:'Players Pie'", "name:'" + ServerMonitorLocale.get("web.pie.players") + " Pie'").replace("name:'Storage Pie'", "name:'" + ServerMonitorLocale.get("web.pie.storage") + " Pie'").replace("name:'Uptime Pie'", "name:'" + ServerMonitorLocale.get("web.pie.uptime") + " Pie'").replace("name:'Multi Pie'", "name:'" + ServerMonitorLocale.get("web.pie.multi") + "'").replace("name:'Combined Monitor'", "name:'" + ServerMonitorLocale.get("web.graph.combined") + "'").replace("name:'Player List'", "name:'" + ServerMonitorLocale.get("adm.widget.playerlist") + "'").replace("name:'TPS History'", "name:'" + ServerMonitorLocale.get("web.graph.tps") + "'").replace("name:'CPU History'", "name:'" + ServerMonitorLocale.get("web.graph.cpu") + "'").replace("name:'RAM History'", "name:'" + ServerMonitorLocale.get("web.graph.ram") + "'").replace("name:'Player History'", "name:'" + ServerMonitorLocale.get("web.graph.players") + "'").replace("name:'Storage History'", "name:'" + ServerMonitorLocale.get("web.graph.storage") + "'").replace("name:'Uptime Status'", "name:'" + ServerMonitorLocale.get("web.graph.uptime") + "'");
                this.sendHtml(exchange, html);
            });
            this.server.createContext("/auth", exchange -> {
                if ("POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                    this.handleLoginPost(exchange);
                } else {
                    this.redirect(exchange, "/login");
                }
            });
            this.server.createContext("/logout", exchange -> {
                exchange.getResponseHeaders().add("Set-Cookie", "session=deleted; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT");
                this.redirect(exchange, "/login");
            });
            this.server.createContext("/api/latest", exchange -> this.sendJson(exchange, this.dataManager.getLatest()));
            this.server.createContext("/api/history", exchange -> {
                int minutes = 30;
                String query = exchange.getRequestURI().getQuery();
                if (query != null && query.contains("minutes=")) {
                    try {
                        minutes = Integer.parseInt(query.split("minutes=")[1].split("&")[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sendJson(exchange, this.dataManager.getHistory(minutes));
            });
            this.server.createContext("/api/config/layout", exchange -> {
                if ("POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                    if (!this.checkAuth(exchange)) {
                        exchange.sendResponseHeaders(403, -1L);
                        return;
                    }
                    InputStream is = exchange.getRequestBody();
                    String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    try {
                        List newLayout = (List)MainMod.GSON.fromJson(json, List.class);
                        if (newLayout != null) {
                            this.config.dashboardLayout = newLayout;
                            this.config.save();
                            this.sendJson(exchange, newLayout);
                        }
                    }
                    catch (Exception e) {
                        exchange.sendResponseHeaders(400, -1L);
                    }
                } else {
                    this.sendJson(exchange, this.config.dashboardLayout);
                }
            });
            this.server.createContext("/api/config/widgets", exchange -> {
                if ("POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                    if (!this.checkAuth(exchange)) {
                        exchange.sendResponseHeaders(403, -1L);
                        return;
                    }
                    InputStream is = exchange.getRequestBody();
                    String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    try {
                        Map newConfigs = (Map)MainMod.GSON.fromJson(json, Map.class);
                        if (newConfigs != null) {
                            this.config.widgetConfigs = newConfigs;
                            this.config.save();
                            this.sendJson(exchange, newConfigs);
                        }
                    }
                    catch (Exception e) {
                        exchange.sendResponseHeaders(400, -1L);
                    }
                } else {
                    this.sendJson(exchange, this.config.widgetConfigs);
                }
            });
            this.server.setExecutor(Executors.newCachedThreadPool());
            this.server.start();
            MainMod.LOGGER.info("Web server started at http://{}:{}", (Object)this.config.webServerHost, (Object)this.config.webServerPort);
        }
        catch (IOException e) {
            MainMod.LOGGER.error("Could not start web server", (Throwable)e);
        }
    }

    private void handleLoginPost(HttpExchange exchange) throws IOException {
        InputStream is = exchange.getRequestBody();
        String formData = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        Map<String, String> params = this.parseFormData(formData);
        if (this.config.adminUsername.equals(params.getOrDefault("username", "")) && this.config.adminPassword.equals(params.getOrDefault("password", ""))) {
            String token = UUID.randomUUID().toString();
            this.sessions.put(token, System.currentTimeMillis() + (long)(this.config.sessionTimeoutMinutes * 60) * 1000L);
            exchange.getResponseHeaders().add("Set-Cookie", "session=" + token + "; Path=/; HttpOnly; SameSite=Strict");
            this.redirect(exchange, "/admin");
        } else {
            this.redirect(exchange, "/login?error=1");
        }
    }

    private boolean checkAuth(HttpExchange exchange) {
        Object cookies = exchange.getRequestHeaders().get("Cookie");
        if (cookies != null) {
            Iterator iterator = cookies.iterator();
            while (iterator.hasNext()) {
                String header = (String)iterator.next();
                for (String cookie : header.split(";")) {
                    if (!(cookie = cookie.trim()).startsWith("session=")) continue;
                    String token = cookie.substring("session=".length());
                    Long expiry = this.sessions.get(token);
                    if (expiry != null && expiry > System.currentTimeMillis()) {
                        this.sessions.put(token, System.currentTimeMillis() + (long)(this.config.sessionTimeoutMinutes * 60) * 1000L);
                        return true;
                    }
                    this.sessions.remove(token);
                }
            }
        }
        return false;
    }

    private Map<String, String> parseFormData(String formData) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : formData.split("&")) {
            String[] kv = pair.split("=");
            if (kv.length != 2) continue;
            try {
                map.put(URLDecoder.decode(kv[0], StandardCharsets.UTF_8), URLDecoder.decode(kv[1], StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    private void sendHtml(HttpExchange exchange, String html) throws IOException {
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=utf-8");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void sendJson(HttpExchange exchange, Object data) throws IOException {
        String json = MainMod.GSON.toJson(data);
        byte[] response = json.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void redirect(HttpExchange exchange, String location) throws IOException {
        exchange.getResponseHeaders().set("Location", location);
        exchange.sendResponseHeaders(302, -1L);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.sessions.clear();
    }
}

