/*
 * Decompiled with CFR 0.152.
 */
package de.fabia.servermonitor;

import de.fabia.servermonitor.ServerMonitorMod;
import java.util.HashMap;
import java.util.Map;

public class Localization {
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();

    public static String get(String key) {
        String lang = ServerMonitorMod.config != null && translations.containsKey(ServerMonitorMod.config.language) ? ServerMonitorMod.config.language : "en";
        return translations.get(lang).getOrDefault(key, key);
    }

    public static String getFormatted(String key, Object ... args) {
        return String.format(Localization.get(key), args);
    }

    public static Map<String, String> getJsTranslations() {
        String lang = ServerMonitorMod.config != null && translations.containsKey(ServerMonitorMod.config.language) ? ServerMonitorMod.config.language : "en";
        return translations.get(lang);
    }

    static {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("web.header", "Server Monitor");
        en.put("stat.tps.title", "TPS");
        en.put("stat.tps.subtitle", "Tick: %.1fms");
        en.put("stat.ram.title", "RAM");
        en.put("stat.ram.subtitle", "Max: %d MB");
        en.put("stat.cpu.title", "CPU");
        en.put("stat.cpu.subtitle", "%d Cores");
        en.put("stat.players.title", "Players");
        en.put("stat.players.subtitle", "Online");
        en.put("stat.uptime.title", "Uptime");
        en.put("stat.uptime.subtitle", "Since server start");
        en.put("chart.tps.title", "TPS");
        en.put("chart.ram.title", "RAM (MB)");
        en.put("chart.cpu.title", "CPU (%)");
        en.put("chart.players.title", "Players");
        en.put("modal.players.title", "Online Players");
        en.put("modal.players.loading", "Loading...");
        en.put("modal.players.none", "No players online.");
        en.put("modal.players.error", "Error loading player list.");
        en.put("player.card.today", "Today");
        en.put("player.card.yesterday", "Yesterday");
        en.put("player.card.total", "Total");
        en.put("player.card.afk", "(AFK)");
        en.put("player.chart.hours", "Hours");
        en.put("page.loading", "Loading data...");
        en.put("page.error", "Error loading statistics. Check server log.");
        en.put("command.feedback", "Server statistics are available in the web interface at http://localhost:%d");
        translations.put("en", en);
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("web.header", "Server Monitor");
        de.put("stat.tps.title", "TPS");
        de.put("stat.tps.subtitle", "Tick: %.1fms");
        de.put("stat.ram.title", "RAM");
        de.put("stat.ram.subtitle", "Max: %d MB");
        de.put("stat.cpu.title", "CPU");
        de.put("stat.cpu.subtitle", "%d Kerne");
        de.put("stat.players.title", "Spieler");
        de.put("stat.players.subtitle", "Online");
        de.put("stat.uptime.title", "Uptime");
        de.put("stat.uptime.subtitle", "Seit Serverstart");
        de.put("chart.tps.title", "TPS");
        de.put("chart.ram.title", "RAM (MB)");
        de.put("chart.cpu.title", "CPU (%)");
        de.put("chart.players.title", "Spieler");
        de.put("modal.players.title", "Online Spieler");
        de.put("modal.players.loading", "Lade...");
        de.put("modal.players.none", "Keine Spieler online.");
        de.put("modal.players.error", "Fehler beim Laden der Spielerliste.");
        de.put("player.card.today", "Heute");
        de.put("player.card.yesterday", "Gestern");
        de.put("player.card.total", "Gesamt");
        de.put("player.card.afk", "(AFK)");
        de.put("player.chart.hours", "Stunden");
        de.put("page.loading", "Lade Daten...");
        de.put("page.error", "Fehler beim Laden der Statistiken. Server-Log pr\u00fcfen.");
        de.put("command.feedback", "Die Server-Statistiken sind im Webinterface unter http://localhost:%d verf\u00fcgbar.");
        translations.put("de", de);
    }
}

