/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cbrokentale.network;

import java.util.function.Supplier;
import net.mcreator.cbrokentale.CBrokenTaleMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CBrokenTaleModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CBrokenTaleMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CBrokenTaleMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.player_max_health_default = message.data.player_max_health_default;
                    variables.player_max_health_affected = message.data.player_max_health_affected;
                    variables.player_max_health_judgement = message.data.player_max_health_judgement;
                    variables.entity_movement_speed = message.data.entity_movement_speed;
                    variables.dizz_cooldown = message.data.dizz_cooldown;
                    variables.dizz_cooldown_sacred = message.data.dizz_cooldown_sacred;
                    variables.jewelry_slot0 = message.data.jewelry_slot0;
                    variables.jewelry_slot1 = message.data.jewelry_slot1;
                    variables.jewelry_slot2 = message.data.jewelry_slot2;
                    variables.jewelry_slot3 = message.data.jewelry_slot3;
                    variables.jewelry_slot4 = message.data.jewelry_slot4;
                    variables.ine_heal = message.data.ine_heal;
                    variables.inesummon = message.data.inesummon;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double player_max_health_default = 0.0;
        public double player_max_health_affected = 0.0;
        public boolean player_max_health_judgement = false;
        public double entity_movement_speed = 0.0;
        public double dizz_cooldown = 0.0;
        public double dizz_cooldown_sacred = 0.0;
        public ItemStack jewelry_slot0 = ItemStack.f_41583_;
        public ItemStack jewelry_slot1 = ItemStack.f_41583_;
        public ItemStack jewelry_slot2 = ItemStack.f_41583_;
        public ItemStack jewelry_slot3 = ItemStack.f_41583_;
        public ItemStack jewelry_slot4 = ItemStack.f_41583_;
        public double ine_heal = 0.0;
        public boolean inesummon = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("player_max_health_default", this.player_max_health_default);
            nbt.m_128347_("player_max_health_affected", this.player_max_health_affected);
            nbt.m_128379_("player_max_health_judgement", this.player_max_health_judgement);
            nbt.m_128347_("entity_movement_speed", this.entity_movement_speed);
            nbt.m_128347_("dizz_cooldown", this.dizz_cooldown);
            nbt.m_128347_("dizz_cooldown_sacred", this.dizz_cooldown_sacred);
            nbt.m_128365_("jewelry_slot0", (Tag)this.jewelry_slot0.m_41739_(new CompoundTag()));
            nbt.m_128365_("jewelry_slot1", (Tag)this.jewelry_slot1.m_41739_(new CompoundTag()));
            nbt.m_128365_("jewelry_slot2", (Tag)this.jewelry_slot2.m_41739_(new CompoundTag()));
            nbt.m_128365_("jewelry_slot3", (Tag)this.jewelry_slot3.m_41739_(new CompoundTag()));
            nbt.m_128365_("jewelry_slot4", (Tag)this.jewelry_slot4.m_41739_(new CompoundTag()));
            nbt.m_128347_("ine_heal", this.ine_heal);
            nbt.m_128379_("inesummon", this.inesummon);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.player_max_health_default = nbt.m_128459_("player_max_health_default");
            this.player_max_health_affected = nbt.m_128459_("player_max_health_affected");
            this.player_max_health_judgement = nbt.m_128471_("player_max_health_judgement");
            this.entity_movement_speed = nbt.m_128459_("entity_movement_speed");
            this.dizz_cooldown = nbt.m_128459_("dizz_cooldown");
            this.dizz_cooldown_sacred = nbt.m_128459_("dizz_cooldown_sacred");
            this.jewelry_slot0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("jewelry_slot0"));
            this.jewelry_slot1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("jewelry_slot1"));
            this.jewelry_slot2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("jewelry_slot2"));
            this.jewelry_slot3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("jewelry_slot3"));
            this.jewelry_slot4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("jewelry_slot4"));
            this.ine_heal = nbt.m_128459_("ine_heal");
            this.inesummon = nbt.m_128471_("inesummon");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("c_broken_tale", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "c_broken_tale_mapvars";
        public double entity_attack_speed = 0.0;
        public double furnace_time = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.entity_attack_speed = nbt.m_128459_("entity_attack_speed");
            this.furnace_time = nbt.m_128459_("furnace_time");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("entity_attack_speed", this.entity_attack_speed);
            nbt.m_128347_("furnace_time", this.furnace_time);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "c_broken_tale_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            if (!event.isWasDeath()) {
                clone.player_max_health_default = original.player_max_health_default;
                clone.player_max_health_affected = original.player_max_health_affected;
                clone.player_max_health_judgement = original.player_max_health_judgement;
                clone.entity_movement_speed = original.entity_movement_speed;
                clone.dizz_cooldown = original.dizz_cooldown;
                clone.dizz_cooldown_sacred = original.dizz_cooldown_sacred;
                clone.jewelry_slot0 = original.jewelry_slot0;
                clone.jewelry_slot1 = original.jewelry_slot1;
                clone.jewelry_slot2 = original.jewelry_slot2;
                clone.jewelry_slot3 = original.jewelry_slot3;
                clone.jewelry_slot4 = original.jewelry_slot4;
                clone.ine_heal = original.ine_heal;
                clone.inesummon = original.inesummon;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CBrokenTaleMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

