/*
 * Decompiled with CFR 0.152.
 */
package org.nosrp.nosgrammar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class main
extends JavaPlugin
implements CommandExecutor,
Listener {
    private Map<UUID, Boolean> grammarEnabledMap;
    private Map<String, String> spellingsMap;
    private Map<String, String> messages;
    private Set<String> whitelistedCommands;
    private Map<String, Integer> commandSubcommandCount;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("grammartoggle").setExecutor((CommandExecutor)this);
        this.getCommand("grammarforce").setExecutor((CommandExecutor)this);
        this.getCommand("grammar").setExecutor((CommandExecutor)this);
        this.getCommand("grammarcheck").setExecutor((CommandExecutor)this);
        this.getCommand("grammarreload").setExecutor((CommandExecutor)this);
        this.grammarEnabledMap = new HashMap<UUID, Boolean>();
        this.spellingsMap = new HashMap<String, String>();
        this.messages = new HashMap<String, String>();
        this.whitelistedCommands = new HashSet<String>();
        this.commandSubcommandCount = new HashMap<String, Integer>();
        this.loadMessages();
        this.loadSpellings();
        this.loadWhitelistedCommands();
        this.loadCommandSubcommandConfig();
    }

    private void loadMessages() {
        File file = new File(this.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            this.saveResource("messages.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String key : config.getKeys(false)) {
            this.messages.put(key, config.getString(key));
        }
    }

    private void loadSpellings() {
        File file = new File(this.getDataFolder(), "spellings.txt");
        if (!file.exists()) {
            this.saveResource("spellings.txt", false);
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                String correct;
                String incorrect;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("\"") && line.contains("\":")) {
                    int quoteEnd = line.indexOf("\":");
                    if (quoteEnd <= 1) continue;
                    incorrect = line.substring(1, quoteEnd);
                    correct = line.substring(quoteEnd + 2).trim();
                    this.spellingsMap.put(incorrect, correct);
                    continue;
                }
                String[] parts = line.split(":", 2);
                if (parts.length != 2) continue;
                incorrect = parts[0].trim().toLowerCase();
                correct = parts[1].trim();
                this.spellingsMap.put(incorrect, correct);
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to load spellings: " + e.getMessage());
        }
    }

    private void loadWhitelistedCommands() {
        YamlConfiguration config;
        List commands;
        File file = new File(this.getDataFolder(), "commands.yml");
        if (!file.exists()) {
            this.saveResource("commands.yml", false);
        }
        if ((commands = (config = YamlConfiguration.loadConfiguration((File)file)).getStringList("whitelisted-commands")) != null) {
            this.whitelistedCommands.clear();
            this.whitelistedCommands.addAll(commands);
            this.getLogger().info("Loaded whitelisted commands: " + String.join((CharSequence)", ", commands));
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String originalMessage = event.getMessage();
        if (originalMessage.startsWith("/")) {
            return;
        }
        String correctedMessage = this.correctSpelling(originalMessage);
        if (this.isGrammarEnabled(player)) {
            correctedMessage = this.correctGrammar(correctedMessage);
        }
        event.setMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)correctedMessage));
    }

    private String extractCommandName(String message) {
        String[] parts = message.substring(1).split(" ");
        return parts[0].toLowerCase();
    }

    private void loadCommandSubcommandConfig() {
        YamlConfiguration config;
        List commands;
        File file = new File(this.getDataFolder(), "commands.yml");
        if (!file.exists()) {
            this.saveResource("commands.yml", false);
        }
        if ((commands = (config = YamlConfiguration.loadConfiguration((File)file)).getStringList("whitelisted-commands")) != null) {
            this.whitelistedCommands.clear();
            this.whitelistedCommands.addAll(commands);
        }
        if (config.contains("command-structures")) {
            for (String commandName : config.getConfigurationSection("command-structures").getKeys(false)) {
                int subcommandCount = config.getInt("command-structures." + commandName, 1);
                this.commandSubcommandCount.put(commandName.toLowerCase(), subcommandCount);
            }
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String originalMessage = event.getMessage();
        String commandName = this.extractCommandName(originalMessage);
        if (this.isWhitelistedCommand(commandName)) {
            int subcommandCount = this.commandSubcommandCount.getOrDefault(commandName.toLowerCase(), 1);
            String[] parts = originalMessage.substring(1).split(" ", subcommandCount + 2);
            if (parts.length >= subcommandCount + 1) {
                StringBuilder commandPrefix = new StringBuilder(parts[0]);
                for (int i = 1; i <= subcommandCount; ++i) {
                    if (i >= parts.length) continue;
                    commandPrefix.append(" ").append(parts[i]);
                }
                String messageContent = "";
                if (parts.length > subcommandCount + 1) {
                    messageContent = parts[subcommandCount + 1];
                }
                if (!messageContent.isEmpty()) {
                    String correctedMessage = this.correctSpelling(messageContent);
                    if (this.isGrammarEnabled(player)) {
                        correctedMessage = this.correctGrammar(correctedMessage);
                    }
                    String correctedCommand = "/" + commandPrefix + " " + correctedMessage;
                    event.setMessage(correctedCommand);
                }
            }
        }
    }

    private boolean isWhitelistedCommand(String commandName) {
        return this.whitelistedCommands.contains(commandName);
    }

    private boolean isGrammarEnabled(Player player) {
        return this.grammarEnabledMap.computeIfAbsent(player.getUniqueId(), uuid -> true);
    }

    private void setGrammarEnabled(Player player, boolean enabled) {
        this.grammarEnabledMap.put(player.getUniqueId(), enabled);
    }

    private String stripColorCodes(String input) {
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)input));
    }

    private String reapplyColorCodes(String input, String original) {
        StringBuilder result = new StringBuilder();
        int colorIndex = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (colorIndex < original.length() && original.charAt(colorIndex) == '&') {
                result.append(original.charAt(colorIndex));
                if (++colorIndex < original.length()) {
                    result.append(original.charAt(colorIndex));
                    ++colorIndex;
                }
            }
            if (i >= input.length()) continue;
            result.append(input.charAt(i));
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String correctGrammar(String input) {
        String[] sentences = input.split("(?<=[.!?])\\s*");
        StringBuilder correctedText = new StringBuilder();
        for (String string : sentences) {
            void var7_7;
            int firstCharIndex;
            String string2 = string.trim();
            if (string2.isEmpty()) continue;
            for (firstCharIndex = 0; firstCharIndex < string2.length() && string2.charAt(firstCharIndex) == '&'; firstCharIndex += 2) {
            }
            if (firstCharIndex < string2.length()) {
                char firstChar = Character.toUpperCase(string2.charAt(firstCharIndex));
                String string3 = string2.substring(0, firstCharIndex) + firstChar + string2.substring(firstCharIndex + 1);
            }
            if (var7_7.endsWith("?") || var7_7.endsWith("!") || var7_7.endsWith(".")) {
                correctedText.append((String)var7_7).append(" ");
                continue;
            }
            correctedText.append((String)var7_7).append(". ");
        }
        return correctedText.toString().trim();
    }

    private String correctSpelling(String input) {
        String strippedInput = this.stripColorCodes(input);
        for (Map.Entry<String, String> entry : this.spellingsMap.entrySet()) {
            String incorrect = entry.getKey();
            String correct = entry.getValue();
            strippedInput = strippedInput.replace("\"" + incorrect + "\"", correct);
            strippedInput = strippedInput.replaceAll("(?i)\\b" + Pattern.quote(incorrect) + "\\b", correct);
        }
        return this.reapplyColorCodes(strippedInput, input);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("grammartoggle")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("nosrp.grammartoggle")) {
                    boolean grammarEnabled = this.isGrammarEnabled(player);
                    this.setGrammarEnabled(player, !grammarEnabled);
                    String messageKey = grammarEnabled ? "togglegrammar_disabled" : "togglegrammar_enabled";
                    String message = this.messages.get(messageKey);
                    if (message != null) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                    } else {
                        player.sendMessage(ChatColor.RED + "Grammar toggle message was not found. Contact an Administrator.");
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("no_permission")));
                }
                return true;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("authorized_player")));
            return false;
        }
        if (command.getName().equalsIgnoreCase("grammarforce")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("nosrp.grammarforce")) {
                    if (args.length == 2) {
                        Player targetPlayer = this.getServer().getPlayer(args[0]);
                        if (targetPlayer != null) {
                            boolean enableGrammar;
                            try {
                                enableGrammar = Boolean.parseBoolean(args[1]);
                            }
                            catch (Exception e) {
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("grammarforce_torf")));
                                return false;
                            }
                            this.setGrammarEnabled(targetPlayer, enableGrammar);
                            String status = enableGrammar ? "enabled" : "disabled";
                            String message = String.format(this.messages.get("grammarcheck_status_informed"), targetPlayer.getName());
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("{player}", targetPlayer.getName())));
                            targetPlayer.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(this.messages.get("grammarcheck_status"), status)));
                        } else {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("player_not_found")));
                        }
                    } else {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("usage_forcegrammar")));
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("no_permission")));
                }
                return true;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("authorized_player")));
            return false;
        }
        if (command.getName().equalsIgnoreCase("grammar")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("nosrp.grammarstatus")) {
                    boolean grammarEnabled = this.isGrammarEnabled(player);
                    String status = grammarEnabled ? "enabled" : "disabled";
                    String messageKey = grammarEnabled ? "togglegrammar_enabled" : "togglegrammar_disabled";
                    String message = this.messages.get(messageKey);
                    if (message != null) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                    } else {
                        player.sendMessage(ChatColor.RED + "Grammar toggle message was not found.");
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("no_permission")));
                }
                return true;
            }
            sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            return false;
        }
        if (command.getName().equalsIgnoreCase("grammarcheck")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("nosrp.grammarcheck")) {
                    if (args.length == 1) {
                        Player targetPlayer = this.getServer().getPlayer(args[0]);
                        if (targetPlayer != null) {
                            String grammarStatusMessage = this.messages.get("grammarcheck_status");
                            if (grammarStatusMessage != null) {
                                boolean isGrammarEnabled = this.isGrammarEnabled(targetPlayer);
                                String status = isGrammarEnabled ? "enabled" : "disabled";
                                String formattedMessage = grammarStatusMessage.replace("{player}", targetPlayer.getName()).replace("{status}", status);
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)formattedMessage));
                            } else {
                                sender.sendMessage(ChatColor.RED + "Grammar check status message was not found.");
                            }
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("player_not_found")));
                        }
                    } else {
                        boolean grammarEnabled = this.isGrammarEnabled(player);
                        String status = grammarEnabled ? "enabled" : "disabled";
                        String messageKey = grammarEnabled ? "togglegrammar_enabled" : "togglegrammar_disabled";
                        String message = this.messages.get(messageKey);
                        if (message != null) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                        } else {
                            player.sendMessage(ChatColor.RED + "Grammar check status message was not found.");
                        }
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("no_permission")));
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("grammarreload")) {
            if (sender.hasPermission("nosrp.reload")) {
                this.loadSpellings();
                this.loadMessages();
                this.loadWhitelistedCommands();
                String reloadSuccessMessage = this.messages.get("reload_success");
                if (reloadSuccessMessage == null) {
                    sender.sendMessage(ChatColor.RED + "The reload_success message was not found!");
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)reloadSuccessMessage));
                }
                return true;
            }
            String noPermissionMessage = this.messages.get("no_permission");
            if (noPermissionMessage == null) {
                sender.sendMessage(ChatColor.RED + "No permission message was not found!");
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)noPermissionMessage));
            }
            return false;
        }
        return false;
    }
}

