# Increment move counter
scoreboard players add @e[type=armor_stand,tag=moving_rod] moves 1

# Add trail particles
execute as @e[type=armor_stand,tag=moving_rod] at @s run particle end_rod ^ ^1.5 ^0.7 0.1 0.1 0.1 0.01 2
execute as @e[type=armor_stand,tag=moving_rod] at @s run particle end_rod ^ ^1.5 ^0.7 0.1 0.1 0.1 0.01 2
execute as @e[type=armor_stand,tag=moving_rod] at @s run particle campfire_cosy_smoke ^ ^1.5 ^ 0.1 0.1 0.1 0.01 1

## ENTITY COLLISION
######################################
#### SET Light Rod COLLISION RADIUS HERE #####
# Check for entity collision - if entity found, mark for death and kill entity
execute as @e[type=armor_stand,tag=moving_rod] at @s if entity @e[distance=..1.3,type=!player,type=!armor_stand,type=!item,type=!experience_orb,type=!area_effect_cloud,type=!arrow,type=!trident,type=!block_display] run tag @s add hit_entity
execute as @e[type=armor_stand,tag=moving_rod] at @s if entity @e[distance=..1.3,type=!player,type=!armor_stand,type=!item,type=!experience_orb,type=!area_effect_cloud,type=!arrow,type=!trident,type=!block_display] run kill @e[distance=..1.3,type=!player,type=!armor_stand,type=!item,type=!experience_orb,type=!area_effect_cloud,type=!arrow,type=!trident,type=!block_display]
# If armor stand mount is marked for death due to entity hit
# Add particle burst effect at armor stand location
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run setblock ~ ~1 ~ air
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle flash ~ ~1 ~ 0 0 0 0 1
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle lava ~ ~1 ~ 0.3 0.3 0.3 0.1 15
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle flame ~ ~1 ~ 0.4 0.4 0.4 0.05 20
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle large_smoke ~ ~1 ~ 0.2 0.2 0.2 0.1 8
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle end_rod ~ ~2 ~ 1 3 1 0.2 150
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] at @s run particle end_rod ~ ~1 ~ 1 1 1 0.8 100
## Add sound at the block location
# Store the coordinates of the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords x int 1 run data get entity @s Pos[0]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords y int 1 run data get entity @s Pos[1]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords z int 1 run data get entity @s Pos[2]
# Pass block coords to macro, playsound at location
execute if entity @e[type=armor_stand,tag=moving_rod,tag=hit_entity] run function rod_chain:playsound_when_entity_hit with storage rod_chain:coords
# Kill the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod,tag=hit_entity] run kill @s

## BLOCK COLLISION
######################################
# Check for block collision, if so, burst effect and kill
execute as @e[type=armor_stand,tag=moving_rod] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run tag @s add rc_block_hit
# Replace end rod with air
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets run setblock ~ ~1 ~ air
# Add particle burst effect at armor stand location
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle flash ~ ~ ~ 0 0 0 0 1
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle lava ~ ~ ~ 0.3 0.3 0.3 0.1 4
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle flame ~ ~ ~ 0.4 0.4 0.4 0.05 4
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle large_smoke ~ ~-0.2 ~ 0.2 0.2 0.2 0.03 4
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle end_rod ~ ~1 ~ 1 1 1 0.4 12
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^0.5 ^1 run particle electric_spark ~ ~ ~ 1.5 1.5 1.5 0.3 80
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s unless block ^ ^1 ^1 #rod_chain:passthrough unless block ^ ^1 ^1 #minecraft:wool_carpets positioned ^ ^1 ^1 run particle minecraft:block{block_state:"minecraft:dirt"} ~ ~1 ~ 1.6 1.0 1.6 0.2 80
# Replace 'impact' block with air
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s run setblock ^ ^1 ^1 air
## Add sound at the block location
# Store the coordinates of the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords x int 1 run data get entity @s Pos[0]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords y int 1 run data get entity @s Pos[1]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords z int 1 run data get entity @s Pos[2]
# Pass block coords to macro, playsound at location
execute if entity @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] run function rod_chain:playsound_when_block_hit with storage rod_chain:coords
# Kill the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod,tag=rc_block_hit] at @s run kill @s

## NO COLLISION
######################################
# If no collision detected, continue moving
execute at @e[type=armor_stand,tag=moving_rod] run setblock ~ ~1 ~ air
execute as @e[type=armor_stand,tag=moving_rod] at @s run tp @s ^ ^ ^1
execute as @e[type=armor_stand,tag=moving_rod] at @s run function rod_chain:place_rod
# Schedule next move if less than max moves
execute as @e[type=armor_stand,tag=moving_rod,scores={moves=1..29}] run schedule function rod_chain:next_link 1t

## TIMEOUT
######################################
# If timeout cleanup with burst effect
execute as @e[type=armor_stand,tag=moving_rod,scores={moves=30..}] at @s run setblock ~ ~1 ~ air
execute as @e[type=armor_stand,tag=moving_rod,scores={moves=30..}] at @s run particle flash ~ ~1 ~ 0 0 0 0 1
execute as @e[type=armor_stand,tag=moving_rod,scores={moves=30..}] at @s run particle large_smoke ~ ~1 ~ 0.2 0.2 0.2 0.1 8
## Add sound at the block location
# Store the coordinates of the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords x int 1 run data get entity @s Pos[0]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords y int 1 run data get entity @s Pos[1]
execute as @e[type=armor_stand,tag=moving_rod] store result storage rod_chain:coords z int 1 run data get entity @s Pos[2]
# Pass block coords to macro, playsound at location
execute if entity @e[type=armor_stand,tag=moving_rod,scores={moves=30..}] run function rod_chain:playsound_when_timeout with storage rod_chain:coords
# Kill the armor stand mount
execute as @e[type=armor_stand,tag=moving_rod,scores={moves=30..}] run kill @s