/*
 * Decompiled with CFR 0.152.
 */
package cn.ningmo.tpagui;

import cn.ningmo.tpagui.TpaGui;
import cn.ningmo.tpagui.menu.GuiManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MenuListener
implements Listener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null || !event.getClickedInventory().equals((Object)event.getView().getTopInventory())) {
            return;
        }
        String titleTemplate = TpaGui.getInstance().getMessage("gui.title");
        int pagePlaceholderIndex = titleTemplate.indexOf("{page}");
        if (pagePlaceholderIndex == -1) {
            return;
        }
        String titlePrefix = titleTemplate.substring(0, pagePlaceholderIndex);
        if (!event.getView().getTitle().startsWith(titlePrefix)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String title = event.getView().getTitle();
        int currentPage = this.extractPageFromTitle(title);
        if (currentPage <= 0) {
            return;
        }
        int pageIndex = currentPage - 1;
        if (clicked.getType() == Material.ARROW) {
            ItemMeta itemMeta = clicked.getItemMeta();
            if (itemMeta == null || !itemMeta.hasDisplayName()) {
                return;
            }
            String itemName = itemMeta.getDisplayName();
            String nextPageName = TpaGui.getInstance().getMessage("gui.navigation.next-page");
            String prevPageName = TpaGui.getInstance().getMessage("gui.navigation.previous-page");
            if (itemName.equals(nextPageName)) {
                player.openInventory(GuiManager.createTpaMenu(player, pageIndex + 1));
            } else if (itemName.equals(prevPageName) && pageIndex > 0) {
                player.openInventory(GuiManager.createTpaMenu(player, pageIndex - 1));
            }
        } else if (clicked.getType() == Material.PLAYER_HEAD) {
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null || !(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta skullMeta = (SkullMeta)meta;
            if (skullMeta.getOwningPlayer() == null) {
                return;
            }
            Player target = skullMeta.getOwningPlayer().getPlayer();
            if (target == null || !target.isOnline()) {
                player.sendMessage(TpaGui.getInstance().getMessage("player-offline"));
                return;
            }
            String tpaCommand = TpaGui.getInstance().getConfig().getString("commands.tpa.to-player", "tpa");
            String tpaHereCommand = TpaGui.getInstance().getConfig().getString("commands.tpa.here", "tpahere");
            String command = event.isLeftClick() ? "/" + tpaCommand + " " + target.getName() : "/" + tpaHereCommand + " " + target.getName();
            TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("gui-command-executed", "{player}", player.getName(), "{command}", command));
            player.setMetadata("TPAGUI_COMMAND", (MetadataValue)new FixedMetadataValue((Plugin)TpaGui.getInstance(), (Object)true));
            try {
                player.chat(command);
            }
            finally {
                player.removeMetadata("TPAGUI_COMMAND", (Plugin)TpaGui.getInstance());
            }
            player.closeInventory();
        }
    }

    private int extractPageFromTitle(String title) {
        try {
            String titleTemplate = TpaGui.getInstance().getMessage("gui.title");
            int placeholderIndex = titleTemplate.indexOf("{page}");
            if (placeholderIndex == -1) {
                return 0;
            }
            String prefix = titleTemplate.substring(0, placeholderIndex);
            String suffix = titleTemplate.substring(placeholderIndex + 6);
            if (title.startsWith(prefix) && title.endsWith(suffix)) {
                String pageStr = title.substring(prefix.length(), title.length() - suffix.length());
                int page = Integer.parseInt(pageStr.trim());
                return page > 0 ? page : 0;
            }
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            String errorMsg = TpaGui.getInstance().getMessage("gui.error.extract-page-failed", title);
            TpaGui.getInstance().getLogger().warning(errorMsg);
        }
        return 0;
    }
}

