/*
 * Decompiled with CFR 0.152.
 */
package cn.ningmo.tpagui;

import cn.ningmo.tpagui.MenuListener;
import cn.ningmo.tpagui.TpaGuiCommand;
import cn.ningmo.tpagui.TpaGuiTabCompleter;
import cn.ningmo.tpagui.UpdateChecker;
import cn.ningmo.tpagui.listener.TpaRequestListener;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TpaGui
extends JavaPlugin {
    private static TpaGui instance;
    private boolean floodgateEnabled = false;
    private UpdateChecker updateChecker;

    public void onEnable() {
        PluginCommand command;
        instance = this;
        this.saveDefaultConfig();
        if (this.getServer().getPluginManager().getPlugin("floodgate") != null) {
            this.floodgateEnabled = true;
            this.getLogger().info(this.getLogMessage("floodgate-enabled", new String[0]));
        }
        if ((command = this.getCommand("tpagui")) != null) {
            command.setExecutor((CommandExecutor)new TpaGuiCommand());
            command.setTabCompleter((TabCompleter)new TpaGuiTabCompleter());
        }
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TpaRequestListener(), (Plugin)this);
        this.updateChecker = new UpdateChecker(this);
        this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> this.checkForUpdates(), 100L);
    }

    private void checkForUpdates() {
        if (!this.getConfig().getBoolean("update-check.enabled", true)) {
            return;
        }
        this.updateChecker.checkForUpdates().thenAccept(hasUpdate -> {
            if (hasUpdate.booleanValue()) {
                this.updateChecker.notifyUpdate();
            } else {
                this.getLogger().info(this.getLogMessage("update-latest", "{version}", this.updateChecker.getCurrentVersion()));
            }
        });
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public static TpaGui getInstance() {
        return instance;
    }

    public boolean isFloodgateEnabled() {
        return this.floodgateEnabled;
    }

    public String getMessage(String path) {
        String message = this.getConfig().getString("messages." + path, path);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String path, String ... placeholders) {
        String message = this.getMessage(path);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }

    public String getLogMessage(String path, String ... placeholders) {
        String message = this.getConfig().getString("messages.log." + path, path);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }
}

