/*
 * Decompiled with CFR 0.152.
 */
package cn.ningmo.tpagui;

import cn.ningmo.tpagui.TpaGui;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String GITHUB_API_URL = "https://api.github.com/repos/RunicWonders/tpagui/releases/latest";
    private static final String GITHUB_RELEASES_URL = "https://github.com/RunicWonders/tpagui/releases";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final TpaGui plugin;
    private final String currentVersion;
    private String latestVersion;
    private String downloadUrl;

    public UpdateChecker(TpaGui plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public CompletableFuture<Boolean> checkForUpdates() {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            if (!this.plugin.getConfig().getBoolean("update-check.enabled", true)) {
                return false;
            }
            URL url = new URL(GITHUB_API_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setInstanceFollowRedirects(true);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                this.plugin.getLogger().fine(this.plugin.getLogMessage("update-check-failed", "{error}", "HTTP " + responseCode));
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            try {
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse(response.toString()).getAsJsonObject();
                String tagName = json.get("tag_name").getAsString();
                String string = this.latestVersion = tagName.startsWith("v") ? tagName.substring(1) : tagName;
                if (json.has("assets") && json.get("assets").getAsJsonArray().size() > 0) {
                    JsonObject asset = json.get("assets").getAsJsonArray().get(0).getAsJsonObject();
                    this.downloadUrl = asset.get("browser_download_url").getAsString();
                } else {
                    this.downloadUrl = GITHUB_RELEASES_URL;
                }
                bl = this.isNewerVersion(this.latestVersion, this.currentVersion);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.plugin.getLogger().fine(this.plugin.getLogMessage("update-check-error", "{error}", e.getMessage()));
                    return false;
                }
            }
            reader.close();
            return bl;
        });
    }

    private boolean isNewerVersion(String latest, String current) {
        try {
            Matcher latestMatcher = VERSION_PATTERN.matcher(latest);
            Matcher currentMatcher = VERSION_PATTERN.matcher(current);
            if (!latestMatcher.find() || !currentMatcher.find()) {
                return false;
            }
            int latestMajor = Integer.parseInt(latestMatcher.group(1));
            int latestMinor = Integer.parseInt(latestMatcher.group(2));
            int latestPatch = Integer.parseInt(latestMatcher.group(3));
            int currentMajor = Integer.parseInt(currentMatcher.group(1));
            int currentMinor = Integer.parseInt(currentMatcher.group(2));
            int currentPatch = Integer.parseInt(currentMatcher.group(3));
            if (latestMajor > currentMajor) {
                return true;
            }
            if (latestMajor == currentMajor) {
                if (latestMinor > currentMinor) {
                    return true;
                }
                if (latestMinor == currentMinor) {
                    return latestPatch > currentPatch;
                }
            }
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(this.plugin.getLogMessage("update-version-compare-error", "{error}", e.getMessage()));
            return false;
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getDownloadUrl() {
        return this.downloadUrl != null ? this.downloadUrl : GITHUB_RELEASES_URL;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void notifyUpdate() {
        if (this.latestVersion == null) {
            return;
        }
        String message = this.plugin.getLogMessage("update-available", "{current}", this.currentVersion, "{latest}", this.latestVersion, "{url}", this.getDownloadUrl());
        this.plugin.getLogger().info("==========================================");
        this.plugin.getLogger().info(message);
        this.plugin.getLogger().info("==========================================");
        if (Bukkit.isPrimaryThread()) {
            this.sendUpdateMessageToAdmins();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, this::sendUpdateMessageToAdmins);
        }
    }

    private void sendUpdateMessageToAdmins() {
        if (this.latestVersion == null) {
            return;
        }
        String playerMessage = this.plugin.getMessage("update-available", "{current}", this.currentVersion, "{latest}", this.latestVersion, "{url}", this.getDownloadUrl());
        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("tpagui.admin")).forEach(player -> player.sendMessage(playerMessage));
    }
}

