/*
 * Decompiled with CFR 0.152.
 */
package cn.ningmo.tpagui.form;

import cn.ningmo.tpagui.TpaGui;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.CustomForm;
import org.geysermc.cumulus.Form;
import org.geysermc.cumulus.SimpleForm;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BedrockFormManager {
    public static void openTpaForm(Player player) {
        ArrayList<String> playerNames = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p == player) continue;
            playerNames.add(p.getName());
        }
        if (playerNames.isEmpty()) {
            player.sendMessage(TpaGui.getInstance().getMessage("no-players-online"));
            return;
        }
        CustomForm form = (CustomForm)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title(TpaGui.getInstance().getMessage("form.title"))).dropdown(TpaGui.getInstance().getMessage("form.player-select"), playerNames.toArray(new String[0])).toggle(TpaGui.getInstance().getMessage("form.tpahere-toggle")).responseHandler((form1, response) -> {
            block7: {
                if (response == null) {
                    TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("form-closed", "{player}", player.getName()));
                    return;
                }
                try {
                    JsonParser parser = new JsonParser();
                    JsonArray jsonArray = parser.parse((String)response).getAsJsonArray();
                    int selectedIndex = jsonArray.get(0).getAsInt();
                    boolean isTpaHere = jsonArray.get(1).getAsBoolean();
                    String targetName = (String)playerNames.get(selectedIndex);
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target == null || !target.isOnline()) {
                        player.sendMessage(TpaGui.getInstance().getMessage("player-offline"));
                        return;
                    }
                    String tpaCommand = TpaGui.getInstance().getConfig().getString("commands.tpa.to-player", "tpa");
                    String tpaHereCommand = TpaGui.getInstance().getConfig().getString("commands.tpa.here", "tpahere");
                    String command = isTpaHere ? "/" + tpaHereCommand + " " + targetName : "/" + tpaCommand + " " + targetName;
                    TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("gui-command-executed", "{player}", player.getName(), "{command}", command));
                    player.setMetadata("TPAGUI_COMMAND", (MetadataValue)new FixedMetadataValue((Plugin)TpaGui.getInstance(), (Object)true));
                    try {
                        player.chat(command);
                    }
                    finally {
                        player.removeMetadata("TPAGUI_COMMAND", (Plugin)TpaGui.getInstance());
                    }
                }
                catch (Exception e) {
                    if (response == null) break block7;
                    player.sendMessage(TpaGui.getInstance().getMessage("form-error"));
                    TpaGui.getInstance().getLogger().warning(TpaGui.getInstance().getLogMessage("form-response-error", "{error}", e.getMessage()));
                }
            }
        })).build();
        try {
            FloodgateApi api = FloodgateApi.getInstance();
            if (api == null) {
                TpaGui.getInstance().getLogger().warning(TpaGui.getInstance().getLogMessage("floodgate-api-unavailable", new String[0]));
                return;
            }
            FloodgatePlayer floodgatePlayer = api.getPlayer(player.getUniqueId());
            if (floodgatePlayer != null) {
                floodgatePlayer.sendForm((Form)form);
            } else {
                TpaGui.getInstance().getLogger().warning(TpaGui.getInstance().getLogMessage("floodgate-player-unavailable", "{player}", player.getName()));
            }
        }
        catch (Exception e) {
            TpaGui.getInstance().getLogger().severe(TpaGui.getInstance().getLogMessage("floodgate-send-form-error", "{error}", e.getMessage()));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeDenyCommands(Player player) {
        List denyCommands = TpaGui.getInstance().getConfig().getStringList("commands.deny");
        player.setMetadata("TPAGUI_COMMAND", (MetadataValue)new FixedMetadataValue((Plugin)TpaGui.getInstance(), (Object)true));
        try {
            for (String cmd : denyCommands) {
                player.chat("/" + cmd);
            }
        }
        finally {
            player.removeMetadata("TPAGUI_COMMAND", (Plugin)TpaGui.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeAcceptCommands(Player player, String requester) {
        List acceptCommands = TpaGui.getInstance().getConfig().getStringList("commands.accept");
        player.setMetadata("TPAGUI_COMMAND", (MetadataValue)new FixedMetadataValue((Plugin)TpaGui.getInstance(), (Object)true));
        try {
            for (String cmd : acceptCommands) {
                player.chat("/" + cmd + " " + requester);
            }
        }
        finally {
            player.removeMetadata("TPAGUI_COMMAND", (Plugin)TpaGui.getInstance());
        }
    }

    public static void sendTpaRequestForm(Player target, String requester, boolean isTpaHere) {
        block6: {
            TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("preparing-send-form", "{player}", target.getName()));
            try {
                String title = TpaGui.getInstance().getMessage("form.request.title");
                String content = TpaGui.getInstance().getMessage(isTpaHere ? "form.request.content-here" : "form.request.content-to", "{player}", requester);
                TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("form-content", "{title}", title, "{content}", content));
                SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(title)).content(content).button(TpaGui.getInstance().getMessage("form.request.accept")).button(TpaGui.getInstance().getMessage("form.request.deny")).responseHandler((form1, response) -> {
                    if (response == null || response.trim().isEmpty()) {
                        TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("request-form-closed", "{player}", target.getName(), "{requester}", requester));
                        target.sendMessage(TpaGui.getInstance().getMessage("form.request.closed", "{player}", requester));
                        BedrockFormManager.executeDenyCommands(target);
                        return;
                    }
                    try {
                        int buttonId = Integer.parseInt(response.trim());
                        if (buttonId == 0) {
                            TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("request-accepted", "{player}", target.getName(), "{requester}", requester));
                            BedrockFormManager.executeAcceptCommands(target, requester);
                            target.sendMessage(TpaGui.getInstance().getMessage("form.request.accepted", "{player}", requester));
                        } else {
                            TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("request-denied", "{player}", target.getName(), "{requester}", requester));
                            target.sendMessage(TpaGui.getInstance().getMessage("form.request.denied", "{player}", requester));
                            BedrockFormManager.executeDenyCommands(target);
                        }
                    }
                    catch (NumberFormatException e) {
                        TpaGui.getInstance().getLogger().fine(TpaGui.getInstance().getLogMessage("form-response-parse", "{error}", e.getMessage()));
                        TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("request-form-closed", "{player}", target.getName(), "{requester}", requester));
                        target.sendMessage(TpaGui.getInstance().getMessage("form.request.closed", "{player}", requester));
                        BedrockFormManager.executeDenyCommands(target);
                    }
                })).build();
                try {
                    FloodgateApi api = FloodgateApi.getInstance();
                    if (api == null) {
                        TpaGui.getInstance().getLogger().warning(TpaGui.getInstance().getLogMessage("floodgate-api-unavailable", new String[0]));
                        return;
                    }
                    FloodgatePlayer floodgatePlayer = api.getPlayer(target.getUniqueId());
                    if (floodgatePlayer != null) {
                        floodgatePlayer.sendForm((Form)form);
                        TpaGui.getInstance().getLogger().info(TpaGui.getInstance().getLogMessage("form-sent", "{player}", target.getName()));
                        break block6;
                    }
                    TpaGui.getInstance().getLogger().warning(TpaGui.getInstance().getLogMessage("floodgate-player-error", "{player}", target.getName()));
                }
                catch (Exception e) {
                    TpaGui.getInstance().getLogger().severe(TpaGui.getInstance().getLogMessage("floodgate-send-form-error", "{error}", e.getMessage()));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                TpaGui.getInstance().getLogger().severe(TpaGui.getInstance().getLogMessage("floodgate-send-form-error", "{error}", e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

