/*
 * Decompiled with CFR 0.152.
 */
package cn.ningmo.tpagui.menu;

import cn.ningmo.tpagui.TpaGui;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GuiManager {
    private static final int ROWS = 6;
    private static final int SLOTS_PER_PAGE = 45;

    public static Inventory createTpaMenu(Player player, int page) {
        TpaGui plugin = TpaGui.getInstance();
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)plugin.getMessage("gui.title", "{page}", String.valueOf(page + 1)));
        ArrayList<Player> availablePlayers = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p == player) continue;
            availablePlayers.add(p);
        }
        int totalPlayers = availablePlayers.size();
        int totalPages = totalPlayers > 0 ? (totalPlayers - 1) / 45 + 1 : 1;
        int startIndex = page * 45;
        int slotIndex = 0;
        for (int i = startIndex; i < availablePlayers.size() && slotIndex < 45; ++i) {
            ItemStack skull;
            Player target = (Player)availablePlayers.get(i);
            if (target == null || !target.isOnline() || (skull = GuiManager.createPlayerSkull(target)) == null || skull.getItemMeta() == null) continue;
            inv.setItem(slotIndex, skull);
            ++slotIndex;
        }
        if (page > 0) {
            inv.setItem(45, GuiManager.createNavigationItem(Material.ARROW, plugin.getMessage("gui.navigation.previous-page")));
        }
        if (totalPlayers > 0 && page < totalPages - 1) {
            inv.setItem(53, GuiManager.createNavigationItem(Material.ARROW, plugin.getMessage("gui.navigation.next-page")));
        }
        return inv;
    }

    private static ItemStack createPlayerSkull(Player player) {
        TpaGui plugin = TpaGui.getInstance();
        if (player == null || !player.isOnline()) {
            plugin.getLogger().fine(plugin.getLogMessage("skull-create-offline", "{player}", player != null ? player.getName() : "null"));
            return null;
        }
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta == null) {
            plugin.getLogger().warning(plugin.getLogMessage("skull-itemmeta-error", new String[0]));
            return null;
        }
        try {
            meta.setOwningPlayer((OfflinePlayer)player);
        }
        catch (Exception e) {
            plugin.getLogger().warning(plugin.getLogMessage("skull-owner-error", "{player}", player.getName(), "{error}", e.getMessage()));
            return null;
        }
        meta.setDisplayName(plugin.getMessage("gui.skull.name", "{player}", player.getName()));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : plugin.getConfig().getStringList("messages.gui.skull.lore")) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        meta.setLore(lore);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private static ItemStack createNavigationItem(Material material, String name) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }
}

