/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidIngredient
implements Predicate<FluidStack> {
    private final List<Fluid> fluids = new ArrayList<Fluid>();
    protected final Value value;

    public List<Fluid> getFluid() {
        return this.fluids;
    }

    public static FluidIngredient of(FriendlyByteBuf buff) {
        byte type = buff.readByte();
        if (type == 0) {
            return new FluidIngredient(new FluidValue(buff.readFluidStack()));
        }
        if (type == 1) {
            return new FluidIngredient(new TagValue((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)buff.m_130281_())));
        }
        throw new IllegalArgumentException();
    }

    public static FluidIngredient of(JsonElement json) {
        if (json != null && json.isJsonObject()) {
            JsonObject obj = (JsonObject)json;
            if (obj.has("fluid")) {
                Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(obj.get("fluid").getAsString()));
                return new FluidIngredient(new FluidValue(new FluidStack(fluid, 1000)));
            }
            if (obj.has("tag")) {
                ResourceLocation tag = new ResourceLocation(obj.get("tag").getAsString());
                return new FluidIngredient(new TagValue((TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)tag)));
            }
        }
        return new FluidIngredient(new FluidValue(FluidStack.EMPTY));
    }

    public static FluidIngredient of(FluidStack fluid) {
        return new FluidIngredient(new FluidValue(fluid));
    }

    public static FluidIngredient of(TagKey<Fluid> fluid) {
        return new FluidIngredient(new TagValue(fluid));
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        Value value = this.value;
        if (value instanceof FluidValue) {
            FluidValue f = (FluidValue)value;
            json.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)f.fluid.getFluid()).toString());
        } else {
            value = this.value;
            if (value instanceof TagValue) {
                TagValue f = (TagValue)value;
                json.addProperty("tag", f.fluid.f_203868_().toString());
            }
        }
        return json;
    }

    public void to(FriendlyByteBuf buff) {
        Value value = this.value;
        if (value instanceof FluidValue) {
            FluidValue f = (FluidValue)value;
            buff.writeByte(0);
            buff.writeFluidStack(f.fluid);
        } else {
            value = this.value;
            if (value instanceof TagValue) {
                TagValue f = (TagValue)value;
                buff.writeByte(1);
                buff.m_130085_(f.fluid.f_203868_());
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public FluidIngredient(Value v) {
        this.value = v;
        if (v instanceof FluidValue) {
            FluidValue fluid = (FluidValue)v;
            if (!fluid.fluid.isEmpty()) {
                this.fluids.add(fluid.fluid.getFluid());
            }
        } else if (v instanceof TagValue) {
            TagValue fluid = (TagValue)v;
            for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(fluid.fluid)) {
                this.fluids.add((Fluid)holder.m_203334_());
            }
        }
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        if (this.fluids.isEmpty()) {
            return fluidStack.isEmpty();
        }
        if (fluidStack.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        for (Fluid tf : this.fluids) {
            if (!tf.m_6212_(fluid)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Value value = this.value;
        if (value instanceof TagValue) {
            TagValue f = (TagValue)value;
            return "tag: " + f.fluid;
        }
        value = this.value;
        if (value instanceof FluidValue) {
            FluidValue f = (FluidValue)value;
            return "fluid: " + f.fluid;
        }
        return super.toString();
    }

    public record FluidValue(FluidStack fluid) implements Value
    {
    }

    public static interface Value {
    }

    public record TagValue(TagKey<Fluid> fluid) implements Value
    {
    }
}

