/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.sterner.guardvillagers.GuardVillagers;
import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.entity.GuardEntityLootTables;
import dev.sterner.guardvillagers.common.entity.goal.ArmorerRepairGuardArmorGoal;
import dev.sterner.guardvillagers.common.entity.goal.FollowShieldGuards;
import dev.sterner.guardvillagers.common.entity.goal.GuardEatFoodGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardInteractDoorGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardLookAtAndStopMovingWhenBeingTheInteractionTarget;
import dev.sterner.guardvillagers.common.entity.goal.GuardRunToEatGoal;
import dev.sterner.guardvillagers.common.entity.goal.HeroHurtByTargetGoal;
import dev.sterner.guardvillagers.common.entity.goal.HeroHurtTargetGoal;
import dev.sterner.guardvillagers.common.entity.goal.KickGoal;
import dev.sterner.guardvillagers.common.entity.goal.RaiseShieldGoal;
import dev.sterner.guardvillagers.common.entity.goal.RangedBowAttackPassiveGoal;
import dev.sterner.guardvillagers.common.entity.goal.RangedCrossbowAttackPassiveGoal;
import dev.sterner.guardvillagers.common.entity.goal.RunToClericGoal;
import dev.sterner.guardvillagers.common.entity.goal.WalkBackToCheckPointGoal;
import dev.sterner.guardvillagers.common.network.GuardData;
import dev.sterner.guardvillagers.common.screenhandler.GuardVillagerScreenHandler;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_10179;
import net.minecraft.class_10215;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1368;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1538;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1603;
import net.minecraft.class_1640;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1811;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3763;
import net.minecraft.class_3854;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4094;
import net.minecraft.class_4136;
import net.minecraft.class_4151;
import net.minecraft.class_4291;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5274;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public class GuardEntity
extends class_1314
implements class_3745,
class_1603,
class_5354,
class_1265,
class_4094 {
    protected static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13313);
    private static final class_1322 USE_ITEM_SPEED_PENALTY = new class_1322(GuardVillagers.id("speed_penalty"), -0.25, class_1322.class_1323.field_6328);
    private static final class_2940<Optional<class_2338>> GUARD_POS = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<Boolean> PATROLLING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GUARD_VARIANT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> RUNNING_TO_EAT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_CHARGING_STATE = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> KICKING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FOLLOWING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final Map<class_4050, class_4048> SIZE_BY_POSE = ImmutableMap.builder().put((Object)class_4050.field_18076, (Object)class_4048.method_18384((float)0.6f, (float)1.95f)).put((Object)class_4050.field_18078, (Object)field_18072).put((Object)class_4050.field_18077, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18079, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18080, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18081, (Object)class_4048.method_18384((float)0.6f, (float)1.75f)).put((Object)class_4050.field_18082, (Object)class_4048.method_18385((float)0.2f, (float)0.2f)).build();
    private static final class_6019 angerTime = class_4802.method_24505((int)20, (int)39);
    public static final Map<class_1304, class_5321<class_52>> EQUIPMENT_SLOT_ITEMS = (Map)class_156.method_654((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(class_1304.field_6173, GuardEntityLootTables.GUARD_MAIN_HAND);
        slotItems.put(class_1304.field_6171, GuardEntityLootTables.GUARD_OFF_HAND);
        slotItems.put(class_1304.field_6169, GuardEntityLootTables.GUARD_HELMET);
        slotItems.put(class_1304.field_6174, GuardEntityLootTables.GUARD_CHEST);
        slotItems.put(class_1304.field_6172, GuardEntityLootTables.GUARD_LEGGINGS);
        slotItems.put(class_1304.field_6166, GuardEntityLootTables.GUARD_FEET);
    });
    private final class_4136 gossips = new class_4136();
    public long lastGossipTime;
    public long lastGossipDecayTime;
    public class_1277 guardInventory = new class_1277(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    public boolean spawnWithArmor;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    static final int consumeEventId = 2003;

    public int method_5850() {
        return 3;
    }

    public GuardEntity(class_1299<? extends GuardEntity> type, class_1937 world) {
        super(type, world);
        this.guardInventory.method_5489((class_1265)this);
        this.method_5971();
        if (GuardVillagersConfig.guardEntitysOpenDoors) {
            ((class_1409)this.method_5942()).method_6363(true);
        }
    }

    public static int slotToInventoryIndex(class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6174 -> 1;
            case class_1304.field_6166 -> 3;
            case class_1304.field_6172 -> 2;
            default -> 0;
        };
    }

    public static int getRandomTypeForBiome(class_1936 world, class_2338 pos) {
        class_3854 type = class_3854.method_16930((class_6880)world.method_23753(pos));
        if (type == class_3854.field_17075) {
            return 6;
        }
        if (type == class_3854.field_17077) {
            return 5;
        }
        if (type == class_3854.field_17072) {
            return 4;
        }
        if (type == class_3854.field_17076) {
            return 3;
        }
        if (type == class_3854.field_17074) {
            return 2;
        }
        if (type == class_3854.field_17071) {
            return 1;
        }
        return 0;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, GuardVillagersConfig.healthModifier).method_26868(class_5134.field_23719, GuardVillagersConfig.speedModifier).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, GuardVillagersConfig.followRangeModifier);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_5971();
        int type = GuardEntity.getRandomTypeForBiome((class_1936)world, this.method_24515());
        if (entityData instanceof GuardEntityData) {
            type = ((GuardEntityData)entityData).variantData;
            entityData = new GuardEntityData(type);
        }
        this.setGuardEntityVariant(type);
        class_5819 random = world.method_8409();
        this.method_5964(random, difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_6087(class_1297 entity) {
        if (entity instanceof class_1314) {
            boolean attackTargets;
            class_1314 living = (class_1314)entity;
            boolean bl = attackTargets = living.method_5968() instanceof class_1646 || living.method_5968() instanceof class_1439 || living.method_5968() instanceof GuardEntity;
            if (attackTargets) {
                this.method_5980((class_1309)living);
            }
        }
        super.method_6087(entity);
    }

    @Nullable
    public class_2338 getPatrolPos() {
        return ((Optional)this.field_6011.method_12789(GUARD_POS)).orElse(null);
    }

    @Nullable
    public void setPatrolPos(class_2338 position) {
        this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(position));
    }

    protected class_3414 method_5994() {
        return GuardVillagers.GUARD_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        if (this.method_6039()) {
            return class_3417.field_15150;
        }
        return GuardVillagers.GUARD_HURT;
    }

    protected class_3414 method_6002() {
        return GuardVillagers.GUARD_DEATH;
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            class_5819 random = this.method_37908().method_8409();
            if (itemstack.method_7960() || class_1890.method_60142((class_1799)itemstack, (class_9331)class_9701.field_51655) || !(random.method_43057() < GuardVillagersConfig.chanceToDropEquipment)) continue;
            this.method_5775(world, itemstack);
        }
    }

    public void method_5749(class_2487 nbt) {
        UUID uuid;
        super.method_5749(nbt);
        UUID uUID = uuid = nbt.method_25928("Owner") ? nbt.method_25926("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.setGuardEntityVariant(nbt.method_10550("Type"));
        this.kickTicks = nbt.method_10550("KickTicks");
        this.setFollowing(nbt.method_10577("Following"));
        this.interacting = nbt.method_10577("Interacting");
        this.setPatrolling(nbt.method_10577("Patrolling"));
        this.shieldCoolDown = nbt.method_10550("KickCooldown");
        this.kickCoolDown = nbt.method_10550("ShieldCooldown");
        this.lastGossipDecayTime = nbt.method_10537("LastGossipDecay");
        this.lastGossipTime = nbt.method_10537("LastGossipTime");
        this.spawnWithArmor = nbt.method_10577("SpawnWithArmor");
        if (nbt.method_10545("PatrolPosX")) {
            int x = nbt.method_10550("PatrolPosX");
            int y = nbt.method_10550("PatrolPosY");
            int z = nbt.method_10550("PatrolPosZ");
            this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(new class_2338(x, y, z)));
        }
        class_2499 listtag = nbt.method_10554("Gossips", 10);
        this.gossips.method_19066(new Dynamic((DynamicOps)class_2509.field_11560, (Object)listtag));
        class_2499 listnbt = nbt.method_10554("Inventory", 9);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 nbtnbt = listnbt.method_10602(i);
            int j = nbtnbt.method_10571("Slot") & 0xFF;
            this.guardInventory.method_5447(j, (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbtnbt).get());
        }
        if (nbt.method_10573("ArmorItems", 9)) {
            class_2499 armorItems = nbt.method_10554("ArmorItems", 10);
            for (int i = 0; i < this.field_6205.size(); ++i) {
                class_1799 stack = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)armorItems.method_10602(i));
                if (!stack.method_7960()) {
                    int index = GuardEntity.slotToInventoryIndex(this.method_32326(class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)armorItems.method_10602(i)).orElse(class_1799.field_8037)));
                    this.guardInventory.method_5447(index, stack);
                    continue;
                }
                listtag.add((Object)new class_2487());
            }
        }
        if (nbt.method_10573("HandItems", 9)) {
            class_2499 handItems = nbt.method_10554("HandItems", 10);
            for (int i = 0; i < this.field_6195.size(); ++i) {
                int handSlot;
                int n = handSlot = i == 0 ? 5 : 4;
                if (!class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)handItems.method_10602(i)).method_7960()) {
                    this.guardInventory.method_5447(handSlot, class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)handItems.method_10602(i)));
                    continue;
                }
                listtag.add((Object)new class_2487());
            }
            if (!this.method_37908().field_9236) {
                this.method_29512(this.method_37908(), nbt);
            }
        }
    }

    protected void method_6040() {
        if (this.method_6115()) {
            class_1268 hand = this.method_6058();
            if (!this.field_6277.equals(this.method_5998(hand))) {
                this.method_6075();
            } else if (!this.field_6277.method_7960() && this.method_6115()) {
                this.method_37908().method_20290(2003, this.method_24515(), class_1792.method_7880((class_1792)this.field_6277.method_7909()));
                class_1799 itemStack = this.field_6277.method_7910(this.method_37908(), (class_1309)this);
                if (itemStack != this.field_6277) {
                    this.method_6122(hand, itemStack);
                }
                if (this.field_6277.method_7976() != class_1839.field_8950) {
                    this.field_6277.method_7934(1);
                }
                this.method_6075();
            }
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Type", this.getGuardEntityVariant());
        nbt.method_10569("KickTicks", this.kickTicks);
        nbt.method_10569("ShieldCooldown", this.shieldCoolDown);
        nbt.method_10569("KickCooldown", this.kickCoolDown);
        nbt.method_10556("Following", this.isFollowing());
        nbt.method_10556("Interacting", this.interacting);
        nbt.method_10556("Patrolling", this.isPatrolling());
        nbt.method_10556("SpawnWithArmor", this.spawnWithArmor);
        nbt.method_10544("LastGossipTime", this.lastGossipTime);
        nbt.method_10544("LastGossipDecay", this.lastGossipDecayTime);
        if (this.getOwnerId() != null) {
            nbt.method_25927("Owner", this.getOwnerId());
        }
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            class_2487 nbtnbt = new class_2487();
            nbtnbt.method_10567("Slot", (byte)i);
            listnbt.add((Object)itemstack.method_57358((class_7225.class_7874)this.method_56673()));
        }
        nbt.method_10566("Inventory", (class_2520)listnbt);
        if (this.getPatrolPos() != null) {
            nbt.method_10569("PatrolPosX", this.getPatrolPos().method_10263());
            nbt.method_10569("PatrolPosY", this.getPatrolPos().method_10264());
            nbt.method_10569("PatrolPosZ", this.getPatrolPos().method_10260());
        }
        nbt.method_10566("Gossips", (class_2520)this.gossips.method_19067((DynamicOps)class_2509.field_11560));
        this.method_29517(nbt);
    }

    private void maybeDecayGossip() {
        long i = this.method_37908().method_8510();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.method_20651();
            this.lastGossipDecayTime = i;
        }
    }

    public class_1799 method_6118(class_1304 slot) {
        switch (slot) {
            case field_6169: {
                return this.guardInventory.method_5438(0);
            }
            case field_6174: {
                return this.guardInventory.method_5438(1);
            }
            case field_6172: {
                return this.guardInventory.method_5438(2);
            }
            case field_6166: {
                return this.guardInventory.method_5438(3);
            }
            case field_6171: {
                return this.guardInventory.method_5438(4);
            }
            case field_6173: {
                return this.guardInventory.method_5438(5);
            }
        }
        return class_1799.field_8037;
    }

    public class_4136 getGossips() {
        return this.gossips;
    }

    public int getPlayerEntityReputation(class_1657 player) {
        return this.gossips.method_19073(player.method_5667(), gossipType -> true);
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            boolean heroOfTheVillage = uuid != null && this.method_37908().method_18470(uuid) != null && this.method_37908().method_18470(uuid).method_6059(class_1294.field_18980);
            return uuid == null || this.method_37908().method_18470(uuid) != null && !heroOfTheVillage && GuardVillagersConfig.followHero || !GuardVillagersConfig.followHero && this.method_37908().method_18470(uuid) == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(class_1309 entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean method_6121(class_3218 world, class_1297 target) {
        if (this.isKicking()) {
            ((class_1309)target).method_6005(1.0, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            world.method_8421((class_1297)this, (byte)4);
            this.method_5951(target, 90.0f, 90.0f);
        }
        class_1799 hand = this.method_6047();
        hand.method_7970(1, (class_1309)this, class_1304.field_6173);
        return super.method_6121(world, target);
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.kickTicks = 10;
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_6062() {
        return this.interacting || super.method_6062();
    }

    public void method_6078(class_1282 damageSource) {
        if ((this.method_37908().method_8407() == class_1267.field_5802 || this.method_37908().method_8407() == class_1267.field_5807) && damageSource.method_5529() instanceof class_1642) {
            class_1641 zombieguard = (class_1641)this.method_29243(class_1299.field_6054, class_10179.method_63607((class_1308)this, (boolean)true, (boolean)false), zv -> {});
            if (this.method_37908().method_8407() != class_1267.field_5807 && this.field_5974.method_43056() || zombieguard == null) {
                return;
            }
            zombieguard.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(zombieguard.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true));
            if (!this.method_5701()) {
                this.method_37908().method_8444(null, 1026, this.method_24515(), 0);
            }
            this.method_31472();
        }
        super.method_6078(damageSource);
    }

    public void method_6007() {
        class_1304[] class_1304Array;
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.method_6032() < this.method_6063() && this.field_6012 % 200 == 0) {
            this.method_6025(GuardVillagersConfig.amountOfHealthRegenerated);
        }
        if (this.spawnWithArmor && (class_1304Array = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_1304Array;
            for (class_1304 equipmentslottype : class_1304.values()) {
                for (class_1799 stack : this.getStacksFromLootTable(equipmentslottype, serverWorld)) {
                    this.method_5673(equipmentslottype, stack);
                }
            }
            this.spawnWithArmor = false;
        }
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        this.method_6119();
        super.method_6007();
    }

    public void method_5773() {
        this.maybeDecayGossip();
        super.method_5773();
    }

    protected class_4048 method_55694(class_4050 pose) {
        return SIZE_BY_POSE.getOrDefault(pose, class_4048.method_18384((float)0.6f, (float)1.95f));
    }

    protected void method_6090(class_1309 entityIn) {
        super.method_6090(entityIn);
        if (entityIn.method_6047().method_7909() instanceof class_1743) {
            this.disableShield(true, entityIn.method_6047().method_7909());
        }
    }

    public void method_6056(float amount) {
        if (this.field_6277.method_7909() == class_1802.field_8255 && amount >= 3.0f) {
            int i = 1 + class_3532.method_15375((float)amount);
            class_1268 hand = this.method_6058();
            this.field_6277.method_7970(i, (class_1309)this, class_1304.field_6171);
            if (this.field_6277.method_7960()) {
                if (hand == class_1268.field_5808) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    this.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                this.field_6277 = class_1799.field_8037;
                this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
            }
        }
    }

    public void method_6019(class_1268 hand) {
        super.method_6019(hand);
        class_1799 itemstack = this.method_5998(hand);
        if (itemstack.method_7909() == class_1802.field_8255) {
            class_1324 modifiableattributeinstance = this.method_5996(class_5134.field_23719);
            modifiableattributeinstance.method_6202(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.method_26835(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void method_6075() {
        super.method_6075();
        if (this.method_5996(class_5134.field_23719).method_6196(USE_ITEM_SPEED_PENALTY.comp_2447())) {
            this.method_5996(class_5134.field_23719).method_6202(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void disableShield(boolean increase, class_1792 item) {
        float chance = 0.25f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.field_5974.method_43057() < chance) {
            this.shieldCoolDown = 100;
            this.method_6075();
            this.method_37908().method_8421((class_1297)this, (byte)30);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(GUARD_VARIANT, (Object)0);
        builder.method_56912(DATA_CHARGING_STATE, (Object)false);
        builder.method_56912(KICKING, (Object)false);
        builder.method_56912(OWNER_UNIQUE_ID, Optional.empty());
        builder.method_56912(FOLLOWING, (Object)false);
        builder.method_56912(GUARD_POS, Optional.empty());
        builder.method_56912(PATROLLING, (Object)false);
        builder.method_56912(RUNNING_TO_EAT, (Object)false);
        super.method_5693(builder);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(DATA_CHARGING_STATE);
    }

    public void setChargingCrossbow(boolean charging) {
        this.field_6011.method_12778(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.field_6011.method_12789(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.field_6011.method_12778(KICKING, (Object)kicking);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.field_6187[class_1304.field_6173.method_5927()] = 100.0f;
        this.field_6187[class_1304.field_6171.method_5927()] = 100.0f;
        this.spawnWithArmor = true;
    }

    public List<class_1799> getStacksFromLootTable(class_1304 slot, class_3218 serverWorld) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            class_52 loot = serverWorld.method_8503().method_58576().method_58295(EQUIPMENT_SLOT_ITEMS.get(slot));
            class_8567.class_8568 worldCtx = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this);
            class_243 origin = this.method_19538();
            class_1282 ds = this.method_6081();
            if (ds == null) {
                ds = serverWorld.method_48963().method_48830();
            }
            worldCtx.method_51874(class_181.field_24424, (Object)origin);
            worldCtx.method_51874(class_181.field_1231, (Object)ds);
            class_8567 ctx = worldCtx.method_51875(class_173.field_1173);
            return loot.method_51878(ctx);
        }
        return List.of();
    }

    public int getGuardEntityVariant() {
        return (Integer)this.field_6011.method_12789(GUARD_VARIANT);
    }

    public void setGuardEntityVariant(int typeId) {
        this.field_6011.method_12778(GUARD_VARIANT, (Object)typeId);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new KickGoal(this));
        this.field_6201.method_6277(0, (class_1352)new GuardEatFoodGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RaiseShieldGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GuardRunToEatGoal(this));
        this.field_6201.method_6277(2, new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f));
        this.field_6201.method_6277(2, new RangedBowAttackPassiveGoal<GuardEntity>(this, 0.5, 20, 15.0f));
        this.field_6201.method_6277(2, (class_1352)new GuardEntityMeleeGoal(this, 0.8, true));
        this.field_6201.method_6277(3, (class_1352)new FollowHeroGoal(this));
        if (GuardVillagersConfig.guardEntitysRunFromPolarBears) {
            this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1456.class, 12.0f, 1.0, 1.2));
        }
        this.field_6201.method_6277(3, (class_1352)new class_4291((class_1314)this, 0.5, false));
        this.field_6201.method_6277(3, (class_1352)new class_5274((class_1314)this, 0.5));
        this.field_6201.method_6277(3, (class_1352)new class_1368((class_1314)this, 0.5, false, 4, () -> false));
        if (GuardVillagersConfig.guardEntitysOpenDoors) {
            this.field_6201.method_6277(3, (class_1352)new GuardInteractDoorGoal(this, true));
        }
        if (GuardVillagersConfig.guardEntityFormation) {
            this.field_6201.method_6277(5, (class_1352)new FollowShieldGuards(this));
        }
        if (GuardVillagersConfig.clericHealing) {
            this.field_6201.method_6277(6, (class_1352)new RunToClericGoal(this));
        }
        if (GuardVillagersConfig.armorerRepairGuardEntityArmor) {
            this.field_6201.method_6277(6, (class_1352)new ArmorerRepairGuardArmorGoal(this));
        }
        this.field_6201.method_6277(4, (class_1352)new WalkBackToCheckPointGoal(this, 0.5));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_3988.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(this));
        this.field_6185.method_6277(5, (class_1352)new DefendVillageGuardEntityGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1584.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{GuardEntity.class, class_1439.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1640.class, true));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtByTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        if (GuardVillagersConfig.attackAllMobs) {
            this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, true, true, (mob, owner) -> mob instanceof class_1569 && !GuardVillagersConfig.mobBlackList.contains(mob.method_5653())));
        }
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (arg_0, arg_1) -> ((GuardEntity)this).method_29515(arg_0, arg_1)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public boolean method_5931() {
        return false;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.shieldCoolDown = 8;
        if (this.method_6047().method_7909() instanceof class_1764) {
            this.shootCrossbowLowered(target);
        } else if (this.method_6047().method_7909() instanceof class_1753) {
            int punchLevel;
            class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102)));
            class_1799 bow = this.method_6047();
            class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)itemStack);
            class_1665 persistentProjectileEntity = class_1675.method_18813((class_1309)this, (class_1799)itemStack, (float)pullProgress, (class_1799)bow);
            class_2378 impl = this.method_56673().method_30530(class_7924.field_41265);
            itemEnchantmentsComponent.method_57536((class_6880)impl.method_46747(class_1893.field_9103));
            int powerLevel = itemEnchantmentsComponent.method_57536((class_6880)impl.method_46747(class_1893.field_9103));
            if (powerLevel > 0) {
                persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = itemEnchantmentsComponent.method_57536((class_6880)impl.method_46747(class_1893.field_9116))) > 0) {
                // empty if block
            }
            if (itemEnchantmentsComponent.method_57536((class_6880)impl.method_46747(class_1893.field_9126)) > 0) {
                persistentProjectileEntity.method_20803(100);
            }
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            persistentProjectileEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)persistentProjectileEntity);
            bow.method_7970(1, (class_1309)this, class_1304.field_6173);
        }
    }

    private void shootCrossbowLowered(class_1309 target) {
        class_1799 itemstack = this.method_6047();
        class_1792 class_17922 = itemstack.method_7909();
        if (!(class_17922 instanceof class_1764)) {
            return;
        }
        class_1764 cb = (class_1764)class_17922;
        float speed = 3.15f;
        float divergence = this.dynamicDivergenceByDistance(this.method_5739((class_1297)target));
        double dist = this.method_5739((class_1297)target);
        double yAdj = (double)target.method_17682() * 0.25 + 0.1 * dist;
        class_243 aim = new class_243(target.method_23317(), target.method_23318() + yAdj, target.method_23321());
        float oldYaw = this.method_36454();
        float oldPitch = this.method_36455();
        float oldHead = this.field_6241;
        class_243 from = this.method_19538().method_1031(0.0, (double)this.method_18381(this.method_18376()), 0.0);
        class_243 v = aim.method_1020(from);
        double dx = v.field_1352;
        double dy = v.field_1351;
        double dz = v.field_1350;
        float newYaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        float newPitch = (float)(-Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))));
        this.method_36456(newYaw);
        this.field_6241 = newYaw;
        this.method_36457(newPitch);
        cb.method_7777(this.method_37908(), (class_1309)this, class_1268.field_5808, itemstack, speed, divergence, null);
        this.method_36456(oldYaw);
        this.field_6241 = oldHead;
        this.method_36457(oldPitch);
    }

    private float dynamicDivergenceByDistance(float horiz) {
        float MIN = 0.35f;
        float MAX = 3.0f;
        float START = 4.0f;
        float END = 28.0f;
        float t = class_3532.method_15363((float)((horiz - 4.0f) / 24.0f), (float)0.0f, (float)1.0f);
        t *= t;
        return class_3532.method_16439((float)t, (float)0.35f, (float)3.0f);
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
        super.method_5673(slotIn, stack);
        switch (slotIn) {
            case field_6174: {
                if (!this.guardInventory.method_5438(1).method_7960()) break;
                this.guardInventory.method_5447(1, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6166: {
                if (!this.guardInventory.method_5438(3).method_7960()) break;
                this.guardInventory.method_5447(3, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6169: {
                if (!this.guardInventory.method_5438(0).method_7960()) break;
                this.guardInventory.method_5447(0, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6172: {
                if (!this.guardInventory.method_5438(2).method_7960()) break;
                this.guardInventory.method_5447(2, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6173: {
                this.guardInventory.method_5447(5, (class_1799)this.field_6195.get(slotIn.method_5927()));
                break;
            }
            case field_6171: {
                this.guardInventory.method_5447(4, (class_1799)this.field_6195.get(slotIn.method_5927()));
            }
        }
    }

    public int getGuardVariant() {
        return (Integer)this.field_6011.method_12789(GUARD_VARIANT);
    }

    public class_1799 method_18808(class_1799 shootable) {
        if (shootable.method_7909() instanceof class_1811) {
            Predicate predicate = ((class_1811)shootable.method_7909()).method_20310();
            class_1799 itemstack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return itemstack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemstack;
        }
        return class_1799.field_8037;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean isFollowing() {
        return (Boolean)this.field_6011.method_12789(FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.field_6011.method_12778(FOLLOWING, (Object)following);
    }

    public boolean method_18395(class_1309 target) {
        return !GuardVillagersConfig.mobBlackList.contains(target.method_5653()) && !target.method_6059(class_1294.field_18980) && !this.isOwner(target) && !(target instanceof class_1646) && !(target instanceof class_1439) && !(target instanceof GuardEntity) && super.method_18395(target);
    }

    public void method_5842() {
        super.method_5842();
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof class_1314) {
            class_1314 creatureentity = (class_1314)class_12972;
            this.field_6283 = creatureentity.field_6283;
        }
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    public void method_5980(class_1309 entity) {
        if (entity instanceof GuardEntity || entity instanceof class_1646 || entity instanceof class_1439) {
            return;
        }
        super.method_5980(entity);
    }

    public void gossip(class_1646 villager, long gameTime) {
        if (!(gameTime >= this.lastGossipTime && gameTime < this.lastGossipTime + 1200L || gameTime >= villager.field_18535 && gameTime < villager.field_18535 + 1200L)) {
            this.gossips.method_19061(villager.method_21651(), this.field_5974, 10);
            this.lastGossipTime = gameTime;
            villager.field_18535 = gameTime;
        }
    }

    public void method_7110(boolean charging) {
    }

    public void method_6060(class_1309 entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.method_6060((class_1309)this);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean inventoryRequirements;
        boolean configValues = player.method_6059(class_1294.field_18980) && GuardVillagersConfig.giveGuardStuffHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.setGuardPatrolHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.giveGuardStuffHotv && GuardVillagersConfig.setGuardPatrolHotv || this.getPlayerEntityReputation(player) >= GuardVillagersConfig.reputationRequirement || player.method_6059(class_1294.field_18980) && !GuardVillagersConfig.giveGuardStuffHotv && !GuardVillagersConfig.setGuardPatrolHotv || this.getOwnerId() != null && this.getOwnerId().equals(player.method_5667());
        boolean bl = inventoryRequirements = !player.method_21823();
        if (inventoryRequirements) {
            if (this.method_5968() != player && this.method_6034() && configValues && player instanceof class_3222) {
                this.openGui((class_3222)player);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public void method_18870(class_4151 interaction, class_1297 entity) {
    }

    public void method_5453(class_1263 sender) {
    }

    public void method_6105(class_1282 damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
                class_1799 itemstack = this.guardInventory.method_5438(i);
                if (!(itemstack.method_7909() instanceof class_1738)) continue;
                class_10215 resist = (class_10215)itemstack.method_57824(class_9334.field_54273);
                if (resist != null && resist.method_64198(damageSource)) {
                    return;
                }
                int j = i;
                List<class_1304> list = Arrays.stream(class_1304.values()).filter(class_1304::method_46643).toList();
                itemstack.method_7970((int)damage, (class_1309)this, list.get(j));
            }
        }
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        if (world.method_8407() != class_1267.field_5801) {
            class_1640 witchentity = (class_1640)class_1299.field_6145.method_5883((class_1937)world, class_3730.field_16471);
            if (witchentity == null) {
                return;
            }
            witchentity.method_5719((class_1297)this);
            witchentity.method_5943((class_5425)world, world.method_8404(witchentity.method_24515()), class_3730.field_16468, null);
            witchentity.method_5977(this.method_5987());
            witchentity.method_5665(this.method_5797());
            witchentity.method_5880(this.method_5807());
            witchentity.method_5971();
            world.method_30736((class_1297)witchentity);
            this.method_31472();
        } else {
            super.method_5800(world, lightning);
        }
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void method_29509() {
        this.method_29514(angerTime.method_35008(this.field_5974));
    }

    public void openGui(class_3222 player) {
        this.setOwnerId(player.method_5667());
        if (player.field_7512 != player.field_7498) {
            player.method_7346();
        }
        this.interacting = true;
        if (!this.method_37908().method_8608()) {
            player.method_17355((class_3908)new GuardScreenHandlerFactory());
        }
    }

    public void setGuardVariant(int i) {
        this.field_6011.method_12778(GUARD_VARIANT, (Object)i);
    }

    public boolean isEating() {
        return GuardEatFoodGoal.isConsumable(this.method_6030()) && this.method_6115();
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_6011.method_12789(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.field_6011.method_12778(PATROLLING, (Object)patrolling);
    }

    public boolean method_25938(class_1811 item) {
        return item instanceof class_1753 || item instanceof class_1764 || super.method_25938(item);
    }

    public static class GuardEntityData
    implements class_1315 {
        public final int variantData;

        public GuardEntityData(int type) {
            this.variantData = type;
        }
    }

    public static class GuardEntityMeleeGoal
    extends class_1366 {
        public final GuardEntity guard;

        public GuardEntityMeleeGoal(GuardEntity guard, double speedIn, boolean useLongMemory) {
            super((class_1314)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean method_6264() {
            return !(this.guard.method_6047().method_7909() instanceof class_1764) && this.guard.method_5968() != null && !this.guard.isEating() && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && this.guard.method_5968() != null;
        }

        public void method_6268() {
            class_1309 target = this.guard.method_5968();
            if (target != null) {
                if ((double)target.method_5739((class_1297)this.guard) <= 3.0 && !this.guard.method_6039()) {
                    float[] strafeForwardOptions = new float[]{-1.0f, -0.5f};
                    float[] strafeSidewaysOptions = new float[]{-1.0f, -0.5f, 0.5f, 1.0f};
                    float forward = strafeForwardOptions[this.guard.method_59922().method_43048(strafeForwardOptions.length)];
                    float sideways = strafeSidewaysOptions[this.guard.method_59922().method_43048(strafeSidewaysOptions.length)];
                    this.guard.method_5962().method_6243(forward, sideways);
                    this.guard.method_5951((class_1297)target, 30.0f, 30.0f);
                }
                if (this.field_6509 != null && (double)target.method_5739((class_1297)this.guard) <= 2.0) {
                    this.guard.method_5942().method_6340();
                }
                super.method_6268();
            }
        }

        protected void method_6288(class_1309 target) {
            if (this.guard.method_42150(target) && this.method_28348() <= 0) {
                class_1937 class_19372 = this.guard.method_37908();
                if (!(class_19372 instanceof class_3218)) {
                    return;
                }
                class_3218 serverWorld = (class_3218)class_19372;
                this.method_28346();
                this.guard.method_6075();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.method_6104(class_1268.field_5808);
                this.guard.method_6121(serverWorld, (class_1297)target);
            }
        }
    }

    public static class FollowHeroGoal
    extends class_1352 {
        public final GuardEntity guard;

        public FollowHeroGoal(GuardEntity mob) {
            this.guard = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public void method_6268() {
            if (this.guard.getOwner() != null && (double)this.guard.getOwner().method_5739((class_1297)this.guard) > 3.0) {
                this.guard.method_5942().method_6335((class_1297)this.guard.getOwner(), 0.7);
                this.guard.method_5988().method_35111((class_1297)this.guard.getOwner());
            } else {
                this.guard.method_5942().method_6340();
            }
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public boolean method_6264() {
            return this.guard.isFollowing() && this.guard.getOwner() != null;
        }

        public void method_6270() {
            this.guard.method_5942().method_6340();
        }
    }

    public static class DefendVillageGuardEntityGoal
    extends class_1405 {
        private final GuardEntity guard;
        private class_1309 villageAggressorTarget;

        public DefendVillageGuardEntityGoal(GuardEntity guardIn) {
            super((class_1308)guardIn, false, true);
            this.guard = guardIn;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_238 box = this.guard.method_5829().method_1009(10.0, 8.0, 10.0);
            List list = this.guard.method_37908().method_18467(class_1646.class, box);
            List list1 = this.guard.method_37908().method_18467(class_1657.class, box);
            for (class_1646 villager : list) {
                for (class_1657 player : list1) {
                    int i = villager.method_20594(player);
                    if (i > GuardVillagersConfig.reputationRequirementToBeAttacked) continue;
                    this.villageAggressorTarget = player;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.method_6059(class_1294.field_18980) && !this.villageAggressorTarget.method_7325() && !((class_1657)this.villageAggressorTarget).method_7337();
        }

        public void method_6269() {
            this.guard.method_5980(this.villageAggressorTarget);
            super.method_6269();
        }
    }

    private class GuardScreenHandlerFactory
    implements ExtendedScreenHandlerFactory {
        private GuardScreenHandlerFactory() {
        }

        private GuardEntity guard() {
            return GuardEntity.this;
        }

        public class_2561 method_5476() {
            return this.guard().method_5476();
        }

        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            class_1277 guardInv = this.guard().guardInventory;
            return new GuardVillagerScreenHandler(syncId, inv, (class_1263)guardInv, this.guard());
        }

        public Object getScreenOpeningData(class_3222 player) {
            return new GuardData(this.guard().method_5628());
        }
    }
}

