/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.deathquota.mod.death.DeathQuotaConfig;
import net.deathquota.mod.death.DeathQuotaManager;
import net.deathquota.mod.death.DeathQuotaState;
import net.deathquota.mod.death.DeathRecord;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public final class DeathQuotaCommands {
    private DeathQuotaCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deathquota").executes(DeathQuotaCommands::selfInfo)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> DeathQuotaCommands.infoAbout((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> DeathQuotaCommands.resetTarget((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetall").requires(source -> source.method_9259(2))).executes(DeathQuotaCommands::resetAllPlayers))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setmax").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)99)).executes(ctx -> DeathQuotaCommands.setMaxLives((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))))));
    }

    private static int selfInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        ((class_2168)ctx.getSource()).method_9226(() -> DeathQuotaManager.describe(player), false);
        return 1;
    }

    private static int infoAbout(CommandContext<class_2168> ctx, class_3222 target) {
        ((class_2168)ctx.getSource()).method_9226(() -> DeathQuotaManager.describe(target), false);
        return 1;
    }

    private static int resetTarget(CommandContext<class_2168> ctx, class_3222 target) {
        DeathRecord record = DeathQuotaManager.reset(target);
        class_5250 text = class_2561.method_43470((String)"Reset death quota for ").method_10852(target.method_5476()).method_10852((class_2561)class_2561.method_43470((String)(" (" + record.getDeathCount() + " deaths now)")));
        ((class_2168)ctx.getSource()).method_9226(() -> DeathQuotaCommands.lambda$resetTarget$9((class_2561)text), true);
        target.method_7353((class_2561)class_2561.method_43470((String)"[Death Quota] An operator reset your lives."), false);
        return 1;
    }

    private static int resetAllPlayers(CommandContext<class_2168> ctx) {
        int affected = DeathQuotaManager.resetAll(((class_2168)ctx.getSource()).method_9211());
        class_5250 feedback = class_2561.method_43470((String)("Reset death quotas for " + affected + " stored player(s)."));
        ((class_2168)ctx.getSource()).method_9226(() -> DeathQuotaCommands.lambda$resetAllPlayers$10((class_2561)feedback), true);
        ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"[Death Quota] An operator reset everyone's lives."), false));
        return affected;
    }

    private static int setMaxLives(CommandContext<class_2168> ctx, int value) {
        class_2168 source = (class_2168)ctx.getSource();
        MinecraftServer server = source.method_9211();
        DeathQuotaConfig config = DeathQuotaConfig.get(server);
        config.setMaxLives(value);
        int changes = DeathQuotaState.get(server).reconcileLocks(config.getMaxLives());
        server.method_3760().method_14571().forEach(DeathQuotaManager::applyPostRespawnState);
        class_5250 feedback = class_2561.method_43470((String)("Set max lives to " + config.getMaxLives() + ". Adjusted " + changes + " stored record(s)."));
        source.method_9226(() -> DeathQuotaCommands.lambda$setMaxLives$12((class_2561)feedback), true);
        return config.getMaxLives();
    }

    private static /* synthetic */ class_2561 lambda$setMaxLives$12(class_2561 feedback) {
        return feedback;
    }

    private static /* synthetic */ class_2561 lambda$resetAllPlayers$10(class_2561 feedback) {
        return feedback;
    }

    private static /* synthetic */ class_2561 lambda$resetTarget$9(class_2561 text) {
        return text;
    }
}

