/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.death;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.deathquota.mod.death.LegacyPersistentDataMigrator;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public final class DeathQuotaConfig
extends class_18 {
    private static final String STORAGE_KEY = "death_quota_config";
    public static final Codec<DeathQuotaConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("maxLives", (Object)3).forGetter(config -> config.maxLives)).apply((Applicative)instance, DeathQuotaConfig::fromMaxLives));
    public static final class_10741<DeathQuotaConfig> STATE_TYPE = new class_10741("death_quota_config", DeathQuotaConfig::new, CODEC, class_4284.field_45082);
    private int maxLives = 3;

    private static DeathQuotaConfig fromMaxLives(int maxLives) {
        DeathQuotaConfig config = new DeathQuotaConfig();
        config.maxLives = Math.max(1, maxLives);
        return config;
    }

    public static DeathQuotaConfig get(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        LegacyPersistentDataMigrator.migrate(server, "three_life_config", STORAGE_KEY);
        class_26 manager = overworld.method_17983();
        return (DeathQuotaConfig)manager.method_17924(STATE_TYPE);
    }

    public int getMaxLives() {
        return this.maxLives;
    }

    public void setMaxLives(int maxLives) {
        int clamped = Math.max(1, maxLives);
        if (this.maxLives != clamped) {
            this.maxLives = clamped;
            this.method_80();
        }
    }
}

