/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.death;

import java.util.Collections;
import java.util.Optional;
import net.deathquota.mod.DeathQuotaMod;
import net.deathquota.mod.death.DeathQuotaConfig;
import net.deathquota.mod.death.DeathQuotaState;
import net.deathquota.mod.death.DeathRecord;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class DeathQuotaManager {
    private DeathQuotaManager() {
    }

    public static void registerEventHooks() {
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                DeathQuotaManager.handleDeath(player, damageSource);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> newPlayer.method_5682().execute(() -> DeathQuotaManager.applyPostRespawnState(newPlayer)));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> DeathQuotaManager.applyPostRespawnState(handler.field_14140)));
    }

    private static void handleDeath(class_3222 player, class_1282 source) {
        MinecraftServer server = player.method_5682();
        DeathQuotaState state = DeathQuotaState.get(server);
        DeathRecord record = state.recordDeath(player.method_5667());
        int maxLives = DeathQuotaManager.getMaxLives(server);
        record.increment(maxLives);
        record.setLastDeath(player.method_24515(), player.method_51469().method_27983().method_29177().toString(), player.method_36454(), player.method_36455(), player.method_51469().method_8510());
        record.setLastDeathMessage(source.method_5506((class_1309)player).getString());
        state.overwrite(player.method_5667(), record);
        int remaining = Math.max(0, maxLives - record.getDeathCount());
        class_5250 feedback = class_2561.method_43470((String)"[Death Quota] ");
        if (record.isSpectatorLocked()) {
            feedback.method_10852((class_2561)class_2561.method_43470((String)"No remaining lives. You'll respawn as a spectator."));
        } else {
            feedback.method_10852((class_2561)class_2561.method_43470((String)("Lives remaining: " + remaining + "/" + maxLives)));
        }
        player.method_7353((class_2561)feedback, false);
        DeathQuotaMod.LOGGER.debug("Player {} now has {} deaths recorded", (Object)player.method_7334().getName(), (Object)record.getDeathCount());
    }

    public static void applyPostRespawnState(class_3222 player) {
        DeathQuotaState state = DeathQuotaState.get(player.method_5682());
        Optional<DeathRecord> record = state.get(player.method_5667());
        record.ifPresent(current -> {
            if (current.isSpectatorLocked()) {
                DeathQuotaManager.forceSpectator(player, current);
            } else {
                DeathQuotaManager.notifyLives(player, current);
            }
        });
    }

    private static void notifyLives(class_3222 player, DeathRecord record) {
        int configuredMax = DeathQuotaManager.getMaxLives(player.method_5682());
        int remaining = Math.max(0, configuredMax - record.getDeathCount());
        player.method_7353((class_2561)class_2561.method_43470((String)("[Death Quota] Lives remaining: " + remaining + "/" + configuredMax)), true);
    }

    public static boolean isSpectatorLocked(class_3222 player) {
        return DeathQuotaState.get(player.method_5682()).get(player.method_5667()).map(DeathRecord::isSpectatorLocked).orElse(false);
    }

    public static DeathRecord ensureRecord(class_3222 player) {
        DeathQuotaState state = DeathQuotaState.get(player.method_5682());
        return state.get(player.method_5667()).orElseGet(() -> {
            DeathRecord record = new DeathRecord();
            state.overwrite(player.method_5667(), record);
            return record;
        });
    }

    public static DeathRecord reset(class_3222 player) {
        DeathQuotaState state = DeathQuotaState.get(player.method_5682());
        DeathRecord record = DeathQuotaManager.ensureRecord(player);
        record.reset();
        state.overwrite(player.method_5667(), record);
        return record;
    }

    public static int resetAll(MinecraftServer server) {
        return DeathQuotaState.get(server).resetAll();
    }

    public static int getMaxLives(MinecraftServer server) {
        return DeathQuotaConfig.get(server).getMaxLives();
    }

    public static class_2561 describe(class_3222 player) {
        DeathRecord record = DeathQuotaManager.ensureRecord(player);
        int maxLives = DeathQuotaManager.getMaxLives(player.method_5682());
        int remaining = Math.max(0, maxLives - record.getDeathCount());
        class_5250 text = class_2561.method_43470((String)player.method_5477().getString()).method_10852((class_2561)class_2561.method_43470((String)(": deaths=" + record.getDeathCount()))).method_10852((class_2561)class_2561.method_43470((String)(", remaining=" + remaining)));
        if (record.isSpectatorLocked()) {
            text.method_10852((class_2561)class_2561.method_43470((String)" (LOCKED)"));
        }
        record.getLastDeathDimension().ifPresent(dim -> text.method_10852((class_2561)class_2561.method_43470((String)(" dim=" + dim))));
        record.getLastDeathPos().ifPresent(pos -> text.method_10852((class_2561)class_2561.method_43470((String)(" pos=" + pos.method_23854()))));
        return text;
    }

    private static void forceSpectator(class_3222 player, DeathRecord record) {
        record.setSpectatorLocked(true);
        DeathQuotaState.get(player.method_5682()).overwrite(player.method_5667(), record);
        if (player.field_13974.method_14257() != class_1934.field_9219) {
            player.method_7336(class_1934.field_9219);
        }
        DeathQuotaManager.teleportToLastDeath(player, record);
        player.method_7353((class_2561)class_2561.method_43470((String)"[Death Quota] You exhausted all lives. Spectate or disconnect."), false);
    }

    private static void teleportToLastDeath(class_3222 player, DeathRecord record) {
        if (record.getLastDeathPos().isEmpty()) {
            return;
        }
        record.getLastDeathDimension().ifPresentOrElse(dimensionId -> {
            class_3218 targetWorld = player.method_5682().method_3847(class_3218.field_25179);
            for (class_3218 world : player.method_5682().method_3738()) {
                if (!world.method_27983().method_29177().toString().equals(dimensionId)) continue;
                targetWorld = world;
                break;
            }
            class_2338 pos = record.getLastDeathPos().orElse(player.method_24515());
            player.method_48105(targetWorld, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, Collections.emptySet(), record.getLastYaw(), record.getLastPitch(), false);
        }, () -> {
            class_2338 pos = record.getLastDeathPos().orElse(player.method_24515());
            player.method_48105(player.method_51469(), (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, Collections.emptySet(), record.getLastYaw(), record.getLastPitch(), false);
        });
    }
}

