/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.death;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.deathquota.mod.death.DeathRecord;
import net.deathquota.mod.death.LegacyPersistentDataMigrator;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public final class DeathQuotaState
extends class_18 {
    private static final String STORAGE_KEY = "death_quota_quota";
    public static final Codec<DeathQuotaState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_40825, DeathRecord.CODEC).optionalFieldOf("records", Map.of()).forGetter(state -> state.records)).apply((Applicative)instance, DeathQuotaState::fromRecords));
    public static final class_10741<DeathQuotaState> STATE_TYPE = new class_10741("death_quota_quota", DeathQuotaState::new, CODEC, class_4284.field_45082);
    private final Map<UUID, DeathRecord> records = new Object2ObjectOpenHashMap();

    private static DeathQuotaState fromRecords(Map<UUID, DeathRecord> records) {
        DeathQuotaState state = new DeathQuotaState();
        state.records.putAll(records);
        return state;
    }

    public static DeathQuotaState get(MinecraftServer server) {
        class_3218 overworld = server.method_30002();
        LegacyPersistentDataMigrator.migrate(server, "three_life_quota", STORAGE_KEY);
        class_26 manager = overworld.method_17983();
        return (DeathQuotaState)manager.method_17924(STATE_TYPE);
    }

    public DeathRecord recordDeath(UUID uuid) {
        DeathRecord record = this.records.computeIfAbsent(uuid, ignored -> new DeathRecord());
        this.method_80();
        return record;
    }

    public Optional<DeathRecord> get(UUID uuid) {
        return Optional.ofNullable(this.records.get(uuid));
    }

    public void overwrite(UUID uuid, DeathRecord updated) {
        this.records.put(uuid, updated);
        this.method_80();
    }

    public void remove(UUID uuid) {
        if (this.records.remove(uuid) != null) {
            this.method_80();
        }
    }

    public int resetAll() {
        if (this.records.isEmpty()) {
            return 0;
        }
        this.records.values().forEach(DeathRecord::reset);
        this.method_80();
        return this.records.size();
    }

    public int reconcileLocks(int maxLives) {
        if (this.records.isEmpty()) {
            return 0;
        }
        int changes = 0;
        for (DeathRecord record : this.records.values()) {
            boolean shouldLock;
            boolean bl = shouldLock = record.getDeathCount() >= maxLives;
            if (record.isSpectatorLocked() == shouldLock) continue;
            record.setSpectatorLocked(shouldLock);
            ++changes;
        }
        if (changes > 0) {
            this.method_80();
        }
        return changes;
    }
}

