/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.death;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

public final class DeathRecord {
    public static final Codec<DeathRecord> CODEC = class_2487.field_25128.xmap(DeathRecord::fromNbt, DeathRecord::toNbt);
    private int deathCount;
    private boolean spectatorLocked;
    private class_2338 lastDeathPos;
    private String lastDeathDimension;
    private String lastDeathMessage;
    private long lastDeathGameTime;
    private float lastYaw;
    private float lastPitch;

    public int increment(int maxLives) {
        ++this.deathCount;
        if (this.deathCount >= maxLives) {
            this.spectatorLocked = true;
        }
        return this.deathCount;
    }

    public int getDeathCount() {
        return this.deathCount;
    }

    public boolean isSpectatorLocked() {
        return this.spectatorLocked;
    }

    public void setSpectatorLocked(boolean spectatorLocked) {
        this.spectatorLocked = spectatorLocked;
    }

    public Optional<class_2338> getLastDeathPos() {
        return Optional.ofNullable(this.lastDeathPos);
    }

    public Optional<String> getLastDeathDimension() {
        return Optional.ofNullable(this.lastDeathDimension);
    }

    public Optional<String> getLastDeathMessage() {
        return Optional.ofNullable(this.lastDeathMessage);
    }

    public long getLastDeathGameTime() {
        return this.lastDeathGameTime;
    }

    public float getLastYaw() {
        return this.lastYaw;
    }

    public float getLastPitch() {
        return this.lastPitch;
    }

    public void setLastDeath(class_2338 pos, String dimensionId, float yaw, float pitch, long gameTime) {
        this.lastDeathPos = pos;
        this.lastDeathDimension = dimensionId;
        this.lastYaw = yaw;
        this.lastPitch = pitch;
        this.lastDeathGameTime = gameTime;
    }

    public void setLastDeathMessage(String message) {
        this.lastDeathMessage = message;
    }

    public void reset() {
        this.deathCount = 0;
        this.spectatorLocked = false;
        this.lastDeathPos = null;
        this.lastDeathDimension = null;
        this.lastDeathMessage = null;
        this.lastDeathGameTime = 0L;
        this.lastYaw = 0.0f;
        this.lastPitch = 0.0f;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("deaths", this.deathCount);
        nbt.method_10556("locked", this.spectatorLocked);
        if (this.lastDeathPos != null) {
            nbt.method_10544("pos", this.lastDeathPos.method_10063());
        }
        if (this.lastDeathDimension != null) {
            nbt.method_10582("dimension", this.lastDeathDimension);
        }
        if (this.lastDeathMessage != null) {
            nbt.method_10582("message", this.lastDeathMessage);
        }
        nbt.method_10544("time", this.lastDeathGameTime);
        nbt.method_10548("yaw", this.lastYaw);
        nbt.method_10548("pitch", this.lastPitch);
        return nbt;
    }

    public static DeathRecord fromNbt(class_2487 nbt) {
        DeathRecord record = new DeathRecord();
        record.deathCount = nbt.method_10550("deaths").orElse(0);
        record.spectatorLocked = nbt.method_10577("locked").orElse(false);
        nbt.method_10537("pos").ifPresent(value -> {
            record.lastDeathPos = class_2338.method_10092((long)value);
        });
        nbt.method_10558("dimension").ifPresent(value -> {
            record.lastDeathDimension = value;
        });
        nbt.method_10558("message").ifPresent(value -> {
            record.lastDeathMessage = value;
        });
        record.lastDeathGameTime = nbt.method_10537("time").orElse(0L);
        record.lastYaw = nbt.method_10583("yaw").orElse(Float.valueOf(0.0f)).floatValue();
        record.lastPitch = nbt.method_10583("pitch").orElse(Float.valueOf(0.0f)).floatValue();
        return record;
    }
}

