/*
 * Decompiled with CFR 0.152.
 */
package net.deathquota.mod.death;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.deathquota.mod.DeathQuotaMod;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

final class LegacyPersistentDataMigrator {
    private LegacyPersistentDataMigrator() {
    }

    static void migrate(MinecraftServer server, String legacyKey, String targetKey) {
        Path dataDir = server.method_27050(class_5218.field_24188).resolve("data");
        LegacyPersistentDataMigrator.migrateFile(dataDir, legacyKey + ".dat", targetKey + ".dat");
        LegacyPersistentDataMigrator.migrateFile(dataDir, legacyKey + ".dat_old", targetKey + ".dat_old");
    }

    private static void migrateFile(Path dataDir, String legacyName, String targetName) {
        Path legacyFile = dataDir.resolve(legacyName);
        if (!Files.exists(legacyFile, new LinkOption[0])) {
            return;
        }
        Path targetFile = dataDir.resolve(targetName);
        if (Files.exists(targetFile, new LinkOption[0])) {
            DeathQuotaMod.LOGGER.warn("Legacy data file {} detected but {} already exists; skipping migration.", (Object)legacyName, (Object)targetName);
            return;
        }
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
            Files.move(legacyFile, targetFile, new CopyOption[0]);
            DeathQuotaMod.LOGGER.info("Migrated legacy data file {} -> {}", (Object)legacyName, (Object)targetName);
        }
        catch (IOException e) {
            DeathQuotaMod.LOGGER.error("Failed to migrate legacy data file {} -> {}", new Object[]{legacyName, targetName, e});
        }
    }
}

