/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.components;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkCache {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final ConcurrentLinkedQueue<Chunk> chunkQueue = new ConcurrentLinkedQueue();
    private final Set<Chunk> chunksToKeepLoaded = ConcurrentHashMap.newKeySet();
    private final Map<Chunk, Long> chunkCache;
    private final int maxCacheSize;
    private final int cacheExpirationTime;

    public ChunkCache(JavaPlugin plugin, final int maxCacheSize, int cacheExpirationTime) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.maxCacheSize = maxCacheSize;
        this.cacheExpirationTime = cacheExpirationTime;
        this.chunkCache = Collections.synchronizedMap(new LinkedHashMap<Chunk, Long>(maxCacheSize + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Chunk, Long> eldest) {
                return this.size() > maxCacheSize;
            }
        });
    }

    public void addToQueue(Chunk chunk) {
        if (!this.chunkQueue.contains(chunk) && !this.chunksToKeepLoaded.contains(chunk)) {
            this.chunkQueue.add(chunk);
            this.chunksToKeepLoaded.add(chunk);
            if (this.chunkCache.containsKey(chunk)) {
                this.chunkCache.remove(chunk);
            }
        }
    }

    public Chunk pollFromQueue() {
        return this.chunkQueue.poll();
    }

    public boolean isQueueEmpty() {
        return this.chunkQueue.isEmpty();
    }

    public int getQueueSize() {
        return this.chunkQueue.size();
    }

    public void addToCache(Chunk chunk) {
        this.chunkCache.put(chunk, System.currentTimeMillis());
    }

    public void removeFromCache(Chunk chunk) {
        this.chunkCache.remove(chunk);
    }

    public boolean isCached(Chunk chunk) {
        return this.chunkCache.containsKey(chunk);
    }

    public void addToKeepLoaded(Chunk chunk) {
        this.chunksToKeepLoaded.add(chunk);
    }

    public void removeFromKeepLoaded(Chunk chunk) {
        this.chunksToKeepLoaded.remove(chunk);
    }

    public boolean shouldKeepLoaded(Chunk chunk) {
        return this.chunksToKeepLoaded.contains(chunk);
    }

    public Set<Chunk> getChunksToKeepLoaded() {
        return new HashSet<Chunk>(this.chunksToKeepLoaded);
    }

    public int getKeepLoadedSize() {
        return this.chunksToKeepLoaded.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredCache() {
        long currentTime = System.currentTimeMillis();
        Map<Chunk, Long> map = this.chunkCache;
        synchronized (map) {
            this.chunkCache.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > (long)this.cacheExpirationTime);
        }
    }

    public void clearAll() {
        this.chunkQueue.clear();
        this.chunksToKeepLoaded.clear();
        this.chunkCache.clear();
    }

    public boolean isChunkNearPlayer(Chunk chunk, Player player, int radius) {
        if (chunk == null || player == null || player.getLocation() == null) {
            return false;
        }
        if (chunk.getWorld() != player.getWorld()) {
            return false;
        }
        int chunkX = player.getLocation().getBlockX() >> 4;
        int chunkZ = player.getLocation().getBlockZ() >> 4;
        int deltaX = Math.abs(chunk.getX() - chunkX);
        int deltaZ = Math.abs(chunk.getZ() - chunkZ);
        return deltaX <= radius && deltaZ <= radius;
    }

    public Set<Chunk> getChunksAroundLocation(World world, int centerX, int centerZ, int radius) {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        if (world == null) {
            return chunks;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                chunks.add(world.getChunkAt(centerX + x, centerZ + z));
            }
        }
        return chunks;
    }

    public int unloadDistantChunks(Set<World> blacklistedWorlds, int dynamicRadius) {
        int unloadedCount = 0;
        HashSet<Chunk> snapshot = new HashSet<Chunk>(this.chunksToKeepLoaded);
        for (Chunk chunk : snapshot) {
            if (blacklistedWorlds.contains(chunk.getWorld())) continue;
            boolean shouldUnload = true;
            for (Player player : chunk.getWorld().getPlayers()) {
                if (!this.isChunkNearPlayer(chunk, player, dynamicRadius)) continue;
                shouldUnload = false;
                break;
            }
            if (!shouldUnload || !chunk.isLoaded()) continue;
            try {
                chunk.unload();
                this.chunksToKeepLoaded.remove(chunk);
                ++unloadedCount;
            }
            catch (Exception ex) {
                this.logger.severe("Failed to unload chunk: " + chunk.toString());
            }
        }
        return unloadedCount;
    }
}

