/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.components;

import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigurationManager {
    private final JavaPlugin plugin;
    private int cacheExpirationTime;
    private int maxChunksToLoad;
    private int dynamicRadius;
    private int maxCacheSize;
    private boolean dynamicRadiusEnabled;
    private double highTickThreshold;
    private double highMemoryThreshold;
    private double lowTickThreshold;
    private double lowMemoryThreshold;
    private boolean maintenanceModeEnabled;
    private int maintenanceModeRadius;
    private double maintenanceModeTickTimeThreshold;
    private double maintenanceModeMemoryThreshold;
    private int defaultRadius;
    private List<String> worldBlacklist;
    private boolean broadcastMaintenanceChanges;
    private Level logLevel;
    private String language;

    public ConfigurationManager(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.loadGeneralConfig(config);
        this.loadMaintenanceConfig(config);
        this.loadDynamicRadiusConfig(config);
    }

    private void loadGeneralConfig(FileConfiguration config) {
        this.cacheExpirationTime = Math.max(1000, config.getInt("cache-expiration-time", 30000));
        this.maxChunksToLoad = Math.max(1, Math.min(20, config.getInt("max-chunks-to-load", 5)));
        this.defaultRadius = this.dynamicRadius = Math.max(1, Math.min(16, config.getInt("chunk-loading-radius", 3)));
        this.maxCacheSize = Math.max(10, Math.min(1000, config.getInt("max-cache-size", 100)));
        this.worldBlacklist = config.getStringList("world-blacklist");
        this.broadcastMaintenanceChanges = config.getBoolean("broadcast-maintenance-changes", false);
        this.language = config.getString("language", "en");
        String logLevelStr = config.getString("logging-level", "INFO");
        try {
            this.logLevel = Level.parse(logLevelStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.logLevel = Level.INFO;
            this.plugin.getLogger().warning("Invalid logging-level in config. Using INFO.");
        }
        this.plugin.getLogger().setLevel(this.logLevel);
    }

    private void loadMaintenanceConfig(FileConfiguration config) {
        this.maintenanceModeEnabled = config.getBoolean("maintenance.enabled", false);
        this.maintenanceModeRadius = Math.max(1, Math.min(8, config.getInt("maintenance.radius", 2)));
        this.maintenanceModeTickTimeThreshold = Math.max(50.0, Math.min(200.0, config.getDouble("maintenance.tick-time-threshold", 70.0)));
        this.maintenanceModeMemoryThreshold = Math.max(50.0, Math.min(95.0, config.getDouble("maintenance.memory-threshold", 80.0)));
    }

    private void loadDynamicRadiusConfig(FileConfiguration config) {
        this.dynamicRadiusEnabled = config.getBoolean("dynamic-radius.enabled", true);
        this.highTickThreshold = Math.max(30.0, Math.min(100.0, config.getDouble("dynamic-radius.high-tick-threshold", 50.0)));
        this.highMemoryThreshold = Math.max(50.0, Math.min(95.0, config.getDouble("dynamic-radius.high-memory-threshold", 75.0)));
        this.lowTickThreshold = Math.max(20.0, Math.min(80.0, config.getDouble("dynamic-radius.low-tick-threshold", 40.0)));
        this.lowMemoryThreshold = Math.max(30.0, Math.min(90.0, config.getDouble("dynamic-radius.low-memory-threshold", 60.0)));
    }

    public void saveMaintenanceMode(boolean enabled) {
        FileConfiguration config = this.plugin.getConfig();
        config.set("maintenance.enabled", (Object)enabled);
        this.plugin.saveConfig();
    }

    public void saveAutoMaintenance(boolean enabled) {
        FileConfiguration config = this.plugin.getConfig();
        config.set("maintenance.auto-maintenance", (Object)enabled);
        this.plugin.saveConfig();
    }

    public int getCacheExpirationTime() {
        return this.cacheExpirationTime;
    }

    public int getMaxChunksToLoad() {
        return this.maxChunksToLoad;
    }

    public int getDynamicRadius() {
        return this.dynamicRadius;
    }

    public void setDynamicRadius(int radius) {
        this.dynamicRadius = radius;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public boolean isDynamicRadiusEnabled() {
        return this.dynamicRadiusEnabled;
    }

    public double getHighTickThreshold() {
        return this.highTickThreshold;
    }

    public double getHighMemoryThreshold() {
        return this.highMemoryThreshold;
    }

    public double getLowTickThreshold() {
        return this.lowTickThreshold;
    }

    public double getLowMemoryThreshold() {
        return this.lowMemoryThreshold;
    }

    public boolean isMaintenanceModeEnabled() {
        return this.maintenanceModeEnabled;
    }

    public int getMaintenanceModeRadius() {
        return this.maintenanceModeRadius;
    }

    public double getMaintenanceModeTickTimeThreshold() {
        return this.maintenanceModeTickTimeThreshold;
    }

    public double getMaintenanceModeMemoryThreshold() {
        return this.maintenanceModeMemoryThreshold;
    }

    public int getDefaultRadius() {
        return this.defaultRadius;
    }

    public List<String> getWorldBlacklist() {
        return this.worldBlacklist;
    }

    public boolean shouldBroadcastMaintenanceChanges() {
        return this.broadcastMaintenanceChanges;
    }

    public String getLanguage() {
        return this.language;
    }
}

