/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.components;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private final Map<String, YamlConfiguration> languages;
    private YamlConfiguration currentLanguage;
    private String currentLanguageCode;
    private static final Map<String, String> LANGUAGE_NAMES = new HashMap<String, String>();

    public LanguageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.languages = new HashMap<String, YamlConfiguration>();
        this.generateDefaultLanguages();
        this.loadLanguages();
    }

    private void generateDefaultLanguages() {
        this.generateEnglish();
        this.generateSpanish();
        this.generateFrench();
        this.generateGerman();
        this.generatePortuguese();
        this.generateItalian();
        this.generateRussian();
        this.generateJapanese();
        this.generateKorean();
        this.generateChinese();
    }

    private void saveLanguageFile(String langCode, Map<String, String> translations) {
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + langCode + ".yml");
        langFile.getParentFile().mkdirs();
        YamlConfiguration config = new YamlConfiguration();
        translations.forEach((arg_0, arg_1) -> ((YamlConfiguration)config).set(arg_0, arg_1));
        try {
            config.save(langFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save language file: " + langCode);
        }
    }

    private void generateEnglish() {
        HashMap<String, String> en = new HashMap<String, String>();
        en.put("no-permission", "&cYou don't have permission to use this command!");
        en.put("config-reloaded", "&aConfiguration reloaded successfully!");
        en.put("chunks-in-queue", "&bChunks in queue: &f%size%");
        en.put("chunks-kept-loaded", "&bChunks kept loaded: &f%size%");
        en.put("online-players", "&bOnline players: &f%count%");
        en.put("total-loaded-chunks", "&bTotal loaded chunks: &f%count%");
        en.put("average-tick-time", "&bAverage tick time: &f%time%ms");
        en.put("heap-memory-usage", "&bHeap memory usage: &f%usage% MB");
        en.put("non-heap-memory-usage", "&bNon-heap memory usage: &f%usage% MB");
        en.put("dynamic-radius", "&bDynamic radius: &f%radius%");
        en.put("maintenance-mode-enabled", "&eMaintenance mode enabled! Radius reduced to %radius%");
        en.put("maintenance-mode-disabled", "&aMaintenance mode disabled! Radius restored to %radius%");
        en.put("maintenance-mode-status", "&eStatus: &f%status% &7| &eRadius: &f%radius%");
        en.put("auto-maintenance-status", "&eAuto-maintenance: &f%auto%");
        en.put("auto-maintenance-toggle", "&eAuto-maintenance %state%");
        en.put("chunk-optimization-complete", "&aChunk optimization complete. Unloaded %unloaded_chunks% chunks.");
        en.put("chunk-load-failed", "&cFailed to load chunk: %chunk%");
        en.put("chunk-unload-failed", "&cFailed to unload chunk: %chunk%");
        en.put("garbage-collection-complete", "&aGarbage collection complete. Freed %freed_memory% MB.");
        en.put("chunk-summary-generated", "&aChunk summary generated.");
        en.put("radius-reduced", "&ePerformance alert: Radius reduced to %radius%");
        en.put("radius-increased", "&aPerformance improved: Radius increased to %radius%");
        en.put("unloaded-chunks", "&bUnloaded chunks: &f%unloaded_chunks%");
        en.put("current-memory-usage", "&bCurrent memory usage: &f%memory_usage% MB");
        en.put("current-average-tick-time", "&bCurrent average tick time: &f%average_tick_time%ms");
        en.put("memory-before-gc", "&bMemory before GC: &f%before_gc% MB");
        en.put("memory-after-gc", "&bMemory after GC: &f%after_gc% MB");
        en.put("freed-memory", "&bFreed memory: &a%freed_memory% MB");
        en.put("world-name", "&bWorld: &f%world%");
        en.put("loaded-chunks", "&bLoaded chunks: &f%count%");
        en.put("active-chunks", "&bActive chunks: &f%active_chunks%");
        en.put("total-entities", "&bTotal entities: &f%total_entities%");
        en.put("total-tile-entities", "&bTotal tile entities: &f%total_tile_entities%");
        en.put("total-players", "&bTotal players: &f%total_players%");
        en.put("total-loaded-entities", "&bTotal loaded entities: &f%total_loaded_entities%");
        en.put("total-tile-entities-world", "&bTotal tile entities in world: &f%total_tile_entities_world%");
        en.put("gui-opened", "&aOpened ChunkManager GUI");
        en.put("heat-map-updated", "&aChunk heat map updated");
        en.put("smart-unload-complete", "&aSmart unloading complete. Unloaded %count% cold chunks");
        this.saveLanguageFile("en", en);
    }

    private void generateSpanish() {
        HashMap<String, String> es = new HashMap<String, String>();
        es.put("no-permission", "&c\u00a1No tienes permiso para usar este comando!");
        es.put("config-reloaded", "&a\u00a1Configuraci\u00f3n recargada exitosamente!");
        es.put("chunks-in-queue", "&bChunks en cola: &f%size%");
        es.put("chunks-kept-loaded", "&bChunks mantenidos cargados: &f%size%");
        es.put("online-players", "&bJugadores en l\u00ednea: &f%count%");
        es.put("total-loaded-chunks", "&bTotal de chunks cargados: &f%count%");
        es.put("average-tick-time", "&bTiempo promedio de tick: &f%time%ms");
        es.put("heap-memory-usage", "&bUso de memoria heap: &f%usage% MB");
        es.put("non-heap-memory-usage", "&bUso de memoria no heap: &f%usage% MB");
        es.put("dynamic-radius", "&bRadio din\u00e1mico: &f%radius%");
        es.put("maintenance-mode-enabled", "&e\u00a1Modo de mantenimiento activado! Radio reducido a %radius%");
        es.put("maintenance-mode-disabled", "&a\u00a1Modo de mantenimiento desactivado! Radio restaurado a %radius%");
        es.put("maintenance-mode-status", "&eEstado: &f%status% &7| &eRadio: &f%radius%");
        es.put("auto-maintenance-status", "&eMantenimiento autom\u00e1tico: &f%auto%");
        es.put("auto-maintenance-toggle", "&eMantenimiento autom\u00e1tico %state%");
        es.put("chunk-optimization-complete", "&aOptimizaci\u00f3n completa. %unloaded_chunks% chunks descargados.");
        es.put("chunk-load-failed", "&cFallo al cargar chunk: %chunk%");
        es.put("chunk-unload-failed", "&cFallo al descargar chunk: %chunk%");
        es.put("garbage-collection-complete", "&aRecolecci\u00f3n de basura completa. %freed_memory% MB liberados.");
        es.put("chunk-summary-generated", "&aResumen de chunks generado.");
        es.put("radius-reduced", "&eAlerta de rendimiento: Radio reducido a %radius%");
        es.put("radius-increased", "&aRendimiento mejorado: Radio aumentado a %radius%");
        es.put("unloaded-chunks", "&bChunks descargados: &f%unloaded_chunks%");
        es.put("current-memory-usage", "&bUso actual de memoria: &f%memory_usage% MB");
        es.put("current-average-tick-time", "&bTiempo promedio actual de tick: &f%average_tick_time%ms");
        es.put("memory-before-gc", "&bMemoria antes de GC: &f%before_gc% MB");
        es.put("memory-after-gc", "&bMemoria despu\u00e9s de GC: &f%after_gc% MB");
        es.put("freed-memory", "&bMemoria liberada: &a%freed_memory% MB");
        es.put("world-name", "&bMundo: &f%world%");
        es.put("loaded-chunks", "&bChunks cargados: &f%count%");
        es.put("active-chunks", "&bChunks activos: &f%active_chunks%");
        es.put("total-entities", "&bTotal de entidades: &f%total_entities%");
        es.put("total-tile-entities", "&bTotal de entidades de bloque: &f%total_tile_entities%");
        es.put("total-players", "&bTotal de jugadores: &f%total_players%");
        es.put("total-loaded-entities", "&bTotal de entidades cargadas: &f%total_loaded_entities%");
        es.put("total-tile-entities-world", "&bTotal de entidades de bloque en el mundo: &f%total_tile_entities_world%");
        es.put("gui-opened", "&aGUI de ChunkManager abierta");
        es.put("heat-map-updated", "&aMapa de calor de chunks actualizado");
        es.put("smart-unload-complete", "&aDescarga inteligente completa. %count% chunks fr\u00edos descargados");
        this.saveLanguageFile("es", es);
    }

    private void generateFrench() {
        HashMap<String, String> fr = new HashMap<String, String>();
        fr.put("no-permission", "&cVous n'avez pas la permission d'utiliser cette commande!");
        fr.put("config-reloaded", "&aConfiguration recharg\u00e9e avec succ\u00e8s!");
        fr.put("chunks-in-queue", "&bChunks en file d'attente: &f%size%");
        fr.put("chunks-kept-loaded", "&bChunks maintenus charg\u00e9s: &f%size%");
        fr.put("online-players", "&bJoueurs en ligne: &f%count%");
        fr.put("total-loaded-chunks", "&bTotal des chunks charg\u00e9s: &f%count%");
        fr.put("average-tick-time", "&bTemps de tick moyen: &f%time%ms");
        fr.put("heap-memory-usage", "&bUtilisation m\u00e9moire heap: &f%usage% MB");
        fr.put("dynamic-radius", "&bRayon dynamique: &f%radius%");
        fr.put("maintenance-mode-enabled", "&eMode maintenance activ\u00e9! Rayon r\u00e9duit \u00e0 %radius%");
        fr.put("maintenance-mode-disabled", "&aMode maintenance d\u00e9sactiv\u00e9! Rayon restaur\u00e9 \u00e0 %radius%");
        fr.put("maintenance-mode-status", "&eStatut: &f%status% &7| &eRayon: &f%radius%");
        fr.put("auto-maintenance-status", "&eMaintenance automatique: &f%auto%");
        fr.put("auto-maintenance-toggle", "&eMaintenance automatique %state%");
        fr.put("chunk-optimization-complete", "&aOptimisation termin\u00e9e. %unloaded_chunks% chunks d\u00e9charg\u00e9s.");
        fr.put("chunk-load-failed", "&c\u00c9chec du chargement du chunk: %chunk%");
        fr.put("chunk-unload-failed", "&c\u00c9chec du d\u00e9chargement du chunk: %chunk%");
        fr.put("garbage-collection-complete", "&aCollecte des d\u00e9chets termin\u00e9e. %freed_memory% MB lib\u00e9r\u00e9s.");
        fr.put("chunk-summary-generated", "&aR\u00e9sum\u00e9 des chunks g\u00e9n\u00e9r\u00e9.");
        fr.put("radius-reduced", "&eAlerte performance: Rayon r\u00e9duit \u00e0 %radius%");
        fr.put("radius-increased", "&aPerformance am\u00e9lior\u00e9e: Rayon augment\u00e9 \u00e0 %radius%");
        fr.put("gui-opened", "&aGUI ChunkManager ouverte");
        fr.put("heat-map-updated", "&aCarte thermique des chunks mise \u00e0 jour");
        fr.put("smart-unload-complete", "&aD\u00e9chargement intelligent termin\u00e9. %count% chunks froids d\u00e9charg\u00e9s");
        this.saveLanguageFile("fr", fr);
    }

    private void generateGerman() {
        HashMap<String, String> de = new HashMap<String, String>();
        de.put("no-permission", "&cDu hast keine Berechtigung diesen Befehl zu benutzen!");
        de.put("config-reloaded", "&aKonfiguration erfolgreich neu geladen!");
        de.put("chunks-in-queue", "&bChunks in Warteschlange: &f%size%");
        de.put("chunks-kept-loaded", "&bGeladene Chunks: &f%size%");
        de.put("online-players", "&bSpieler online: &f%count%");
        de.put("total-loaded-chunks", "&bGesamte geladene Chunks: &f%count%");
        de.put("average-tick-time", "&bDurchschnittliche Tick-Zeit: &f%time%ms");
        de.put("heap-memory-usage", "&bHeap-Speichernutzung: &f%usage% MB");
        de.put("dynamic-radius", "&bDynamischer Radius: &f%radius%");
        de.put("maintenance-mode-enabled", "&eWartungsmodus aktiviert! Radius reduziert auf %radius%");
        de.put("maintenance-mode-disabled", "&aWartungsmodus deaktiviert! Radius wiederhergestellt auf %radius%");
        de.put("maintenance-mode-status", "&eStatus: &f%status% &7| &eRadius: &f%radius%");
        de.put("auto-maintenance-status", "&eAutomatische Wartung: &f%auto%");
        de.put("auto-maintenance-toggle", "&eAutomatische Wartung %state%");
        de.put("chunk-optimization-complete", "&aOptimierung abgeschlossen. %unloaded_chunks% Chunks entladen.");
        de.put("chunk-load-failed", "&cFehler beim Laden des Chunks: %chunk%");
        de.put("chunk-unload-failed", "&cFehler beim Entladen des Chunks: %chunk%");
        de.put("garbage-collection-complete", "&aSpeicherbereinigung abgeschlossen. %freed_memory% MB freigegeben.");
        de.put("chunk-summary-generated", "&aChunk-Zusammenfassung generiert.");
        de.put("radius-reduced", "&eLeistungswarnung: Radius reduziert auf %radius%");
        de.put("radius-increased", "&aLeistung verbessert: Radius erh\u00f6ht auf %radius%");
        de.put("gui-opened", "&aChunkManager GUI ge\u00f6ffnet");
        de.put("heat-map-updated", "&aChunk-Heatmap aktualisiert");
        de.put("smart-unload-complete", "&aIntelligentes Entladen abgeschlossen. %count% kalte Chunks entladen");
        this.saveLanguageFile("de", de);
    }

    private void generatePortuguese() {
        HashMap<String, String> pt = new HashMap<String, String>();
        pt.put("no-permission", "&cVoc\u00ea n\u00e3o tem permiss\u00e3o para usar este comando!");
        pt.put("config-reloaded", "&aConfigura\u00e7\u00e3o recarregada com sucesso!");
        pt.put("chunks-in-queue", "&bChunks na fila: &f%size%");
        pt.put("chunks-kept-loaded", "&bChunks mantidos carregados: &f%size%");
        pt.put("online-players", "&bJogadores online: &f%count%");
        pt.put("total-loaded-chunks", "&bTotal de chunks carregados: &f%count%");
        pt.put("average-tick-time", "&bTempo m\u00e9dio de tick: &f%time%ms");
        pt.put("heap-memory-usage", "&bUso de mem\u00f3ria heap: &f%usage% MB");
        pt.put("dynamic-radius", "&bRaio din\u00e2mico: &f%radius%");
        pt.put("maintenance-mode-enabled", "&eModo manuten\u00e7\u00e3o ativado! Raio reduzido para %radius%");
        pt.put("maintenance-mode-disabled", "&aModo manuten\u00e7\u00e3o desativado! Raio restaurado para %radius%");
        pt.put("maintenance-mode-status", "&eStatus: &f%status% &7| &eRaio: &f%radius%");
        pt.put("auto-maintenance-status", "&eManuten\u00e7\u00e3o autom\u00e1tica: &f%auto%");
        pt.put("auto-maintenance-toggle", "&eManuten\u00e7\u00e3o autom\u00e1tica %state%");
        pt.put("chunk-optimization-complete", "&aOtimiza\u00e7\u00e3o completa. %unloaded_chunks% chunks descarregados.");
        pt.put("chunk-load-failed", "&cFalha ao carregar chunk: %chunk%");
        pt.put("chunk-unload-failed", "&cFalha ao descarregar chunk: %chunk%");
        pt.put("garbage-collection-complete", "&aColeta de lixo completa. %freed_memory% MB liberados.");
        pt.put("chunk-summary-generated", "&aResumo de chunks gerado.");
        pt.put("radius-reduced", "&eAlerta de desempenho: Raio reduzido para %radius%");
        pt.put("radius-increased", "&aDesempenho melhorado: Raio aumentado para %radius%");
        pt.put("gui-opened", "&aGUI do ChunkManager aberta");
        pt.put("heat-map-updated", "&aMapa de calor dos chunks atualizado");
        pt.put("smart-unload-complete", "&aDescarregamento inteligente completo. %count% chunks frios descarregados");
        this.saveLanguageFile("pt", pt);
    }

    private void generateItalian() {
        HashMap<String, String> it = new HashMap<String, String>();
        it.put("no-permission", "&cNon hai il permesso di usare questo comando!");
        it.put("config-reloaded", "&aConfigurazione ricaricata con successo!");
        it.put("chunks-in-queue", "&bChunk in coda: &f%size%");
        it.put("chunks-kept-loaded", "&bChunk mantenuti caricati: &f%size%");
        it.put("online-players", "&bGiocatori online: &f%count%");
        it.put("total-loaded-chunks", "&bTotale chunk caricati: &f%count%");
        it.put("average-tick-time", "&bTempo medio tick: &f%time%ms");
        it.put("heap-memory-usage", "&bUtilizzo memoria heap: &f%usage% MB");
        it.put("dynamic-radius", "&bRaggio dinamico: &f%radius%");
        it.put("maintenance-mode-enabled", "&eModalit\u00e0 manutenzione attivata! Raggio ridotto a %radius%");
        it.put("maintenance-mode-disabled", "&aModalit\u00e0 manutenzione disattivata! Raggio ripristinato a %radius%");
        it.put("maintenance-mode-status", "&eStato: &f%status% &7| &eRaggio: &f%radius%");
        it.put("auto-maintenance-status", "&eManutenzione automatica: &f%auto%");
        it.put("auto-maintenance-toggle", "&eManutenzione automatica %state%");
        it.put("chunk-optimization-complete", "&aOttimizzazione completata. %unloaded_chunks% chunk scaricati.");
        it.put("chunk-load-failed", "&cErrore nel caricamento del chunk: %chunk%");
        it.put("chunk-unload-failed", "&cErrore nello scaricamento del chunk: %chunk%");
        it.put("garbage-collection-complete", "&aRaccolta memoria completata. %freed_memory% MB liberati.");
        it.put("chunk-summary-generated", "&aRiepilogo chunk generato.");
        it.put("radius-reduced", "&eAvviso prestazioni: Raggio ridotto a %radius%");
        it.put("radius-increased", "&aPrestazioni migliorate: Raggio aumentato a %radius%");
        it.put("gui-opened", "&aGUI ChunkManager aperta");
        it.put("heat-map-updated", "&aMappa termica chunk aggiornata");
        it.put("smart-unload-complete", "&aScaricamento intelligente completato. %count% chunk freddi scaricati");
        this.saveLanguageFile("it", it);
    }

    private void generateRussian() {
        HashMap<String, String> ru = new HashMap<String, String>();
        ru.put("no-permission", "&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
        ru.put("config-reloaded", "&a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
        ru.put("chunks-in-queue", "&b\u0427\u0430\u043d\u043a\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: &f%size%");
        ru.put("chunks-kept-loaded", "&b\u0427\u0430\u043d\u043a\u043e\u0432 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e: &f%size%");
        ru.put("online-players", "&b\u0418\u0433\u0440\u043e\u043a\u043e\u0432 \u043e\u043d\u043b\u0430\u0439\u043d: &f%count%");
        ru.put("total-loaded-chunks", "&b\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e \u0447\u0430\u043d\u043a\u043e\u0432: &f%count%");
        ru.put("average-tick-time", "&b\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0442\u0438\u043a\u0430: &f%time%\u043c\u0441");
        ru.put("heap-memory-usage", "&b\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 heap \u043f\u0430\u043c\u044f\u0442\u0438: &f%usage% \u041c\u0411");
        ru.put("dynamic-radius", "&b\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0434\u0438\u0443\u0441: &f%radius%");
        ru.put("maintenance-mode-enabled", "&e\u0420\u0435\u0436\u0438\u043c \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0435\u043d! \u0420\u0430\u0434\u0438\u0443\u0441 \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d \u0434\u043e %radius%");
        ru.put("maintenance-mode-disabled", "&a\u0420\u0435\u0436\u0438\u043c \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d! \u0420\u0430\u0434\u0438\u0443\u0441 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0434\u043e %radius%");
        ru.put("maintenance-mode-status", "&e\u0421\u0442\u0430\u0442\u0443\u0441: &f%status% &7| &e\u0420\u0430\u0434\u0438\u0443\u0441: &f%radius%");
        ru.put("auto-maintenance-status", "&e\u0410\u0432\u0442\u043e-\u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435: &f%auto%");
        ru.put("auto-maintenance-toggle", "&e\u0410\u0432\u0442\u043e-\u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 %state%");
        ru.put("chunk-optimization-complete", "&a\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430. \u0412\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e %unloaded_chunks% \u0447\u0430\u043d\u043a\u043e\u0432.");
        ru.put("chunk-load-failed", "&c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0447\u0430\u043d\u043a\u0430: %chunk%");
        ru.put("chunk-unload-failed", "&c\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0447\u0430\u043d\u043a\u0430: %chunk%");
        ru.put("garbage-collection-complete", "&a\u0421\u0431\u043e\u0440\u043a\u0430 \u043c\u0443\u0441\u043e\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430. \u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u043e %freed_memory% \u041c\u0411.");
        ru.put("chunk-summary-generated", "&a\u0421\u0432\u043e\u0434\u043a\u0430 \u043f\u043e \u0447\u0430\u043d\u043a\u0430\u043c \u0441\u043e\u0437\u0434\u0430\u043d\u0430.");
        ru.put("radius-reduced", "&e\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u0420\u0430\u0434\u0438\u0443\u0441 \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d \u0434\u043e %radius%");
        ru.put("radius-increased", "&a\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0430: \u0420\u0430\u0434\u0438\u0443\u0441 \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d \u0434\u043e %radius%");
        ru.put("gui-opened", "&aGUI ChunkManager \u043e\u0442\u043a\u0440\u044b\u0442");
        ru.put("heat-map-updated", "&a\u0422\u0435\u043f\u043b\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u0447\u0430\u043d\u043a\u043e\u0432 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
        ru.put("smart-unload-complete", "&a\u0423\u043c\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430. \u0412\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e %count% \u0445\u043e\u043b\u043e\u0434\u043d\u044b\u0445 \u0447\u0430\u043d\u043a\u043e\u0432");
        this.saveLanguageFile("ru", ru);
    }

    private void generateJapanese() {
        HashMap<String, String> ja = new HashMap<String, String>();
        ja.put("no-permission", "&c\u3053\u306e\u30b3\u30de\u30f3\u30c9\u3092\u4f7f\u7528\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\uff01");
        ja.put("config-reloaded", "&a\u8a2d\u5b9a\u304c\u6b63\u5e38\u306b\u518d\u8aad\u307f\u8fbc\u307f\u3055\u308c\u307e\u3057\u305f\uff01");
        ja.put("chunks-in-queue", "&b\u30ad\u30e5\u30fc\u5185\u306e\u30c1\u30e3\u30f3\u30af: &f%size%");
        ja.put("chunks-kept-loaded", "&b\u8aad\u307f\u8fbc\u307f\u7dad\u6301\u30c1\u30e3\u30f3\u30af: &f%size%");
        ja.put("online-players", "&b\u30aa\u30f3\u30e9\u30a4\u30f3\u30d7\u30ec\u30a4\u30e4\u30fc: &f%count%");
        ja.put("total-loaded-chunks", "&b\u7dcf\u8aad\u307f\u8fbc\u307f\u30c1\u30e3\u30f3\u30af: &f%count%");
        ja.put("average-tick-time", "&b\u5e73\u5747\u30c6\u30a3\u30c3\u30af\u6642\u9593: &f%time%ms");
        ja.put("heap-memory-usage", "&b\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u4f7f\u7528\u91cf: &f%usage% MB");
        ja.put("dynamic-radius", "&b\u52d5\u7684\u534a\u5f84: &f%radius%");
        ja.put("maintenance-mode-enabled", "&e\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u30e2\u30fc\u30c9\u6709\u52b9\uff01\u534a\u5f84\u3092%radius%\u306b\u7e2e\u5c0f");
        ja.put("maintenance-mode-disabled", "&a\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u30e2\u30fc\u30c9\u7121\u52b9\uff01\u534a\u5f84\u3092%radius%\u306b\u5fa9\u5143");
        ja.put("maintenance-mode-status", "&e\u30b9\u30c6\u30fc\u30bf\u30b9: &f%status% &7| &e\u534a\u5f84: &f%radius%");
        ja.put("auto-maintenance-status", "&e\u81ea\u52d5\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9: &f%auto%");
        ja.put("auto-maintenance-toggle", "&e\u81ea\u52d5\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9 %state%");
        ja.put("chunk-optimization-complete", "&a\u6700\u9069\u5316\u5b8c\u4e86\u3002%unloaded_chunks%\u500b\u306e\u30c1\u30e3\u30f3\u30af\u3092\u30a2\u30f3\u30ed\u30fc\u30c9\u3002");
        ja.put("chunk-load-failed", "&c\u30c1\u30e3\u30f3\u30af\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557: %chunk%");
        ja.put("chunk-unload-failed", "&c\u30c1\u30e3\u30f3\u30af\u306e\u30a2\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557: %chunk%");
        ja.put("garbage-collection-complete", "&a\u30ac\u30d9\u30fc\u30b8\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u5b8c\u4e86\u3002%freed_memory% MB\u89e3\u653e\u3002");
        ja.put("chunk-summary-generated", "&a\u30c1\u30e3\u30f3\u30af\u30b5\u30de\u30ea\u30fc\u3092\u751f\u6210\u3057\u307e\u3057\u305f\u3002");
        ja.put("radius-reduced", "&e\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9\u8b66\u544a\uff1a\u534a\u5f84\u3092%radius%\u306b\u7e2e\u5c0f");
        ja.put("radius-increased", "&a\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9\u6539\u5584\uff1a\u534a\u5f84\u3092%radius%\u306b\u62e1\u5927");
        ja.put("gui-opened", "&aChunkManager GUI\u3092\u958b\u304d\u307e\u3057\u305f");
        ja.put("heat-map-updated", "&a\u30c1\u30e3\u30f3\u30af\u30d2\u30fc\u30c8\u30de\u30c3\u30d7\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f");
        ja.put("smart-unload-complete", "&a\u30b9\u30de\u30fc\u30c8\u30a2\u30f3\u30ed\u30fc\u30c9\u5b8c\u4e86\u3002%count%\u500b\u306e\u30b3\u30fc\u30eb\u30c9\u30c1\u30e3\u30f3\u30af\u3092\u30a2\u30f3\u30ed\u30fc\u30c9");
        this.saveLanguageFile("ja", ja);
    }

    private void generateKorean() {
        HashMap<String, String> ko = new HashMap<String, String>();
        ko.put("no-permission", "&c\uc774 \uba85\ub839\uc5b4\ub97c \uc0ac\uc6a9\ud560 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4!");
        ko.put("config-reloaded", "&a\uc124\uc815\uc774 \uc131\uacf5\uc801\uc73c\ub85c \ub2e4\uc2dc \ub85c\ub4dc\ub418\uc5c8\uc2b5\ub2c8\ub2e4!");
        ko.put("chunks-in-queue", "&b\ub300\uae30\uc5f4\uc758 \uccad\ud06c: &f%size%");
        ko.put("chunks-kept-loaded", "&b\ub85c\ub4dc \uc720\uc9c0 \uccad\ud06c: &f%size%");
        ko.put("online-players", "&b\uc628\ub77c\uc778 \ud50c\ub808\uc774\uc5b4: &f%count%");
        ko.put("total-loaded-chunks", "&b\ucd1d \ub85c\ub4dc\ub41c \uccad\ud06c: &f%count%");
        ko.put("average-tick-time", "&b\ud3c9\uade0 \ud2f1 \uc2dc\uac04: &f%time%ms");
        ko.put("heap-memory-usage", "&b\ud799 \uba54\ubaa8\ub9ac \uc0ac\uc6a9\ub7c9: &f%usage% MB");
        ko.put("dynamic-radius", "&b\ub3d9\uc801 \ubc18\uacbd: &f%radius%");
        ko.put("maintenance-mode-enabled", "&e\uc720\uc9c0\ubcf4\uc218 \ubaa8\ub4dc \ud65c\uc131\ud654! \ubc18\uacbd\uc774 %radius%\ub85c \uac10\uc18c");
        ko.put("maintenance-mode-disabled", "&a\uc720\uc9c0\ubcf4\uc218 \ubaa8\ub4dc \ube44\ud65c\uc131\ud654! \ubc18\uacbd\uc774 %radius%\ub85c \ubcf5\uc6d0");
        ko.put("maintenance-mode-status", "&e\uc0c1\ud0dc: &f%status% &7| &e\ubc18\uacbd: &f%radius%");
        ko.put("auto-maintenance-status", "&e\uc790\ub3d9 \uc720\uc9c0\ubcf4\uc218: &f%auto%");
        ko.put("auto-maintenance-toggle", "&e\uc790\ub3d9 \uc720\uc9c0\ubcf4\uc218 %state%");
        ko.put("chunk-optimization-complete", "&a\ucd5c\uc801\ud654 \uc644\ub8cc. %unloaded_chunks%\uac1c \uccad\ud06c \uc5b8\ub85c\ub4dc.");
        ko.put("chunk-load-failed", "&c\uccad\ud06c \ub85c\ub4dc \uc2e4\ud328: %chunk%");
        ko.put("chunk-unload-failed", "&c\uccad\ud06c \uc5b8\ub85c\ub4dc \uc2e4\ud328: %chunk%");
        ko.put("garbage-collection-complete", "&a\uac00\ube44\uc9c0 \uceec\ub809\uc158 \uc644\ub8cc. %freed_memory% MB \ud574\uc81c.");
        ko.put("chunk-summary-generated", "&a\uccad\ud06c \uc694\uc57d \uc0dd\uc131\ub428.");
        ko.put("radius-reduced", "&e\uc131\ub2a5 \uacbd\uace0: \ubc18\uacbd\uc774 %radius%\ub85c \uac10\uc18c");
        ko.put("radius-increased", "&a\uc131\ub2a5 \uac1c\uc120: \ubc18\uacbd\uc774 %radius%\ub85c \uc99d\uac00");
        ko.put("gui-opened", "&aChunkManager GUI \uc5f4\ub9bc");
        ko.put("heat-map-updated", "&a\uccad\ud06c \ud788\ud2b8\ub9f5 \uc5c5\ub370\uc774\ud2b8\ub428");
        ko.put("smart-unload-complete", "&a\uc2a4\ub9c8\ud2b8 \uc5b8\ub85c\ub4dc \uc644\ub8cc. %count%\uac1c\uc758 \ucf5c\ub4dc \uccad\ud06c \uc5b8\ub85c\ub4dc\ub428");
        this.saveLanguageFile("ko", ko);
    }

    private void generateChinese() {
        HashMap<String, String> zh = new HashMap<String, String>();
        zh.put("no-permission", "&c\u60a8\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
        zh.put("config-reloaded", "&a\u914d\u7f6e\u91cd\u65b0\u52a0\u8f7d\u6210\u529f\uff01");
        zh.put("chunks-in-queue", "&b\u961f\u5217\u4e2d\u7684\u533a\u5757: &f%size%");
        zh.put("chunks-kept-loaded", "&b\u4fdd\u6301\u52a0\u8f7d\u7684\u533a\u5757: &f%size%");
        zh.put("online-players", "&b\u5728\u7ebf\u73a9\u5bb6: &f%count%");
        zh.put("total-loaded-chunks", "&b\u603b\u52a0\u8f7d\u533a\u5757: &f%count%");
        zh.put("average-tick-time", "&b\u5e73\u5747\u523b\u65f6\u95f4: &f%time%\u6beb\u79d2");
        zh.put("heap-memory-usage", "&b\u5806\u5185\u5b58\u4f7f\u7528: &f%usage% MB");
        zh.put("dynamic-radius", "&b\u52a8\u6001\u534a\u5f84: &f%radius%");
        zh.put("maintenance-mode-enabled", "&e\u7ef4\u62a4\u6a21\u5f0f\u5df2\u542f\u7528\uff01\u534a\u5f84\u51cf\u5c11\u5230%radius%");
        zh.put("maintenance-mode-disabled", "&a\u7ef4\u62a4\u6a21\u5f0f\u5df2\u7981\u7528\uff01\u534a\u5f84\u6062\u590d\u5230%radius%");
        zh.put("maintenance-mode-status", "&e\u72b6\u6001: &f%status% &7| &e\u534a\u5f84: &f%radius%");
        zh.put("auto-maintenance-status", "&e\u81ea\u52a8\u7ef4\u62a4: &f%auto%");
        zh.put("auto-maintenance-toggle", "&e\u81ea\u52a8\u7ef4\u62a4 %state%");
        zh.put("chunk-optimization-complete", "&a\u4f18\u5316\u5b8c\u6210\u3002\u5378\u8f7d\u4e86%unloaded_chunks%\u4e2a\u533a\u5757\u3002");
        zh.put("chunk-load-failed", "&c\u52a0\u8f7d\u533a\u5757\u5931\u8d25: %chunk%");
        zh.put("chunk-unload-failed", "&c\u5378\u8f7d\u533a\u5757\u5931\u8d25: %chunk%");
        zh.put("garbage-collection-complete", "&a\u5783\u573e\u56de\u6536\u5b8c\u6210\u3002\u91ca\u653e\u4e86%freed_memory% MB\u3002");
        zh.put("chunk-summary-generated", "&a\u533a\u5757\u6458\u8981\u5df2\u751f\u6210\u3002");
        zh.put("radius-reduced", "&e\u6027\u80fd\u8b66\u544a\uff1a\u534a\u5f84\u51cf\u5c11\u5230%radius%");
        zh.put("radius-increased", "&a\u6027\u80fd\u6539\u5584\uff1a\u534a\u5f84\u589e\u52a0\u5230%radius%");
        zh.put("gui-opened", "&aChunkManager GUI\u5df2\u6253\u5f00");
        zh.put("heat-map-updated", "&a\u533a\u5757\u70ed\u529b\u56fe\u5df2\u66f4\u65b0");
        zh.put("smart-unload-complete", "&a\u667a\u80fd\u5378\u8f7d\u5b8c\u6210\u3002\u5378\u8f7d\u4e86%count%\u4e2a\u51b7\u533a\u5757");
        this.saveLanguageFile("zh", zh);
    }

    private void loadLanguages() {
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String langCode : LANGUAGE_NAMES.keySet()) {
            this.loadLanguage(langCode);
        }
        String configLang = this.plugin.getConfig().getString("language", "en");
        this.setLanguage(configLang);
    }

    private void loadLanguage(String langCode) {
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + langCode + ".yml");
        if (!langFile.exists()) {
            this.plugin.getLogger().info("Generating language file: " + langCode);
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            this.languages.put(langCode, config);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load language file: " + langCode);
        }
    }

    public void setLanguage(String langCode) {
        if (!this.languages.containsKey(langCode)) {
            this.plugin.getLogger().warning("Language '" + langCode + "' not found. Using English.");
            langCode = "en";
        }
        this.currentLanguageCode = langCode;
        this.currentLanguage = this.languages.get(langCode);
        this.plugin.getLogger().info("Language set to: " + LANGUAGE_NAMES.get(langCode));
    }

    public String getMessage(String key) {
        if (this.currentLanguage == null) {
            return "Language not loaded: " + key;
        }
        Object message = this.currentLanguage.getString(key);
        if (message == null) {
            YamlConfiguration fallback = this.languages.get("en");
            message = fallback != null ? fallback.getString(key, "Missing: " + key) : "Missing: " + key;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return message;
    }

    public String getCurrentLanguageCode() {
        return this.currentLanguageCode;
    }

    public String getCurrentLanguageName() {
        return LANGUAGE_NAMES.get(this.currentLanguageCode);
    }

    public Map<String, String> getAvailableLanguages() {
        return new HashMap<String, String>(LANGUAGE_NAMES);
    }

    public void reloadLanguages() {
        this.languages.clear();
        this.loadLanguages();
    }

    static {
        LANGUAGE_NAMES.put("en", "English");
        LANGUAGE_NAMES.put("es", "Espa\u00f1ol");
        LANGUAGE_NAMES.put("fr", "Fran\u00e7ais");
        LANGUAGE_NAMES.put("de", "Deutsch");
        LANGUAGE_NAMES.put("pt", "Portugu\u00eas");
        LANGUAGE_NAMES.put("it", "Italiano");
        LANGUAGE_NAMES.put("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        LANGUAGE_NAMES.put("ja", "\u65e5\u672c\u8a9e");
        LANGUAGE_NAMES.put("ko", "\ud55c\uad6d\uc5b4");
        LANGUAGE_NAMES.put("zh", "\u4e2d\u6587");
        LANGUAGE_NAMES.put("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629");
        LANGUAGE_NAMES.put("tr", "T\u00fcrk\u00e7e");
        LANGUAGE_NAMES.put("pl", "Polski");
        LANGUAGE_NAMES.put("nl", "Nederlands");
        LANGUAGE_NAMES.put("sv", "Svenska");
    }
}

