/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.components;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TaskManager {
    private final JavaPlugin plugin;
    private final Map<String, BukkitTask> tasks = new HashMap<String, BukkitTask>();

    public TaskManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void startTask(String name, final Runnable task, long delay, long period) {
        this.cancelTask(name);
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }.runTaskTimer((Plugin)this.plugin, delay, period);
        this.tasks.put(name, bukkitTask);
    }

    public void startAsyncTask(String name, final Runnable task, long delay, long period) {
        this.cancelTask(name);
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, delay, period);
        this.tasks.put(name, bukkitTask);
    }

    public void runTask(String name, final Runnable task) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }.runTask((Plugin)this.plugin);
        this.tasks.put(name, bukkitTask);
    }

    public void runTaskLater(final String name, final Runnable task, long delay) {
        this.cancelTask(name);
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.run();
                TaskManager.this.tasks.remove(name);
            }
        }.runTaskLater((Plugin)this.plugin, delay);
        this.tasks.put(name, bukkitTask);
    }

    public void runAsyncTask(String name, final Runnable task) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
        this.tasks.put(name, bukkitTask);
    }

    public void cancelTask(String name) {
        BukkitTask task = this.tasks.get(name);
        if (task != null && !task.isCancelled()) {
            task.cancel();
            this.tasks.remove(name);
        }
    }

    public void cancelAllTasks() {
        this.tasks.values().forEach(task -> {
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
        });
        this.tasks.clear();
        this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
    }

    public boolean isTaskRunning(String name) {
        BukkitTask task = this.tasks.get(name);
        return task != null && !task.isCancelled();
    }
}

