/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkEventManager {
    private final JavaPlugin plugin;
    private final Map<ChunkEventType, List<Consumer<ChunkEvent>>> listeners;

    public ChunkEventManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.listeners = new ConcurrentHashMap<ChunkEventType, List<Consumer<ChunkEvent>>>();
        for (ChunkEventType type : ChunkEventType.values()) {
            this.listeners.put(type, new ArrayList());
        }
    }

    public void registerListener(ChunkEventType type, Consumer<ChunkEvent> listener) {
        this.listeners.get((Object)type).add(listener);
    }

    public void unregisterListener(ChunkEventType type, Consumer<ChunkEvent> listener) {
        this.listeners.get((Object)type).remove(listener);
    }

    public void fireEvent(ChunkEvent event) {
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        List<Consumer<ChunkEvent>> typeListeners = this.listeners.get((Object)event.getEventType());
        for (Consumer<ChunkEvent> listener : typeListeners) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error in chunk event listener: " + e.getMessage());
            }
        }
    }

    public void fireLoadEvent(Chunk chunk, boolean isAsync, Player requester) {
        ChunkLoadEvent event = new ChunkLoadEvent(chunk, isAsync, requester);
        this.fireEvent(event);
    }

    public void fireUnloadEvent(Chunk chunk, ChunkUnloadEvent.UnloadReason reason) {
        ChunkUnloadEvent event = new ChunkUnloadEvent(chunk, reason);
        this.fireEvent(event);
    }

    public void fireOptimizationEvent(Chunk chunk, ChunkOptimizationEvent.OptimizationType type, int affected, double gain) {
        ChunkOptimizationEvent event = new ChunkOptimizationEvent(chunk, type, affected, gain);
        this.fireEvent(event);
    }

    public void fireHeatChangeEvent(Chunk chunk, double oldHeat, double newHeat, ChunkHeatChangeEvent.HeatChangeReason reason) {
        ChunkHeatChangeEvent event = new ChunkHeatChangeEvent(chunk, oldHeat, newHeat, reason);
        this.fireEvent(event);
    }

    public Map<ChunkEventType, Integer> getListenerCounts() {
        HashMap<ChunkEventType, Integer> counts = new HashMap<ChunkEventType, Integer>();
        for (Map.Entry<ChunkEventType, List<Consumer<ChunkEvent>>> entry : this.listeners.entrySet()) {
            counts.put(entry.getKey(), entry.getValue().size());
        }
        return counts;
    }

    public static enum ChunkEventType {
        PRE_LOAD,
        POST_LOAD,
        PRE_UNLOAD,
        POST_UNLOAD,
        OPTIMIZATION_START,
        OPTIMIZATION_END,
        HEAT_CHANGE,
        PRIORITY_CHANGE,
        CACHE_HIT,
        CACHE_MISS,
        PREFETCH_SUCCESS,
        PREFETCH_FAIL;

    }

    public static abstract class ChunkEvent
    extends Event {
        private static final HandlerList HANDLERS = new HandlerList();
        protected final Chunk chunk;
        protected final ChunkEventType type;
        protected final long timestamp;
        protected final Map<String, Object> metadata;

        public ChunkEvent(Chunk chunk, ChunkEventType type) {
            this.chunk = chunk;
            this.type = type;
            this.timestamp = System.currentTimeMillis();
            this.metadata = new HashMap<String, Object>();
        }

        public Chunk getChunk() {
            return this.chunk;
        }

        public ChunkEventType getEventType() {
            return this.type;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(String key, Object value) {
            this.metadata.put(key, value);
        }

        public HandlerList getHandlers() {
            return HANDLERS;
        }

        public static HandlerList getHandlerList() {
            return HANDLERS;
        }
    }

    public static class ChunkLoadEvent
    extends ChunkEvent
    implements Cancellable {
        private boolean cancelled = false;
        private final boolean isAsync;
        private final Player requester;

        public ChunkLoadEvent(Chunk chunk, boolean isAsync, Player requester) {
            super(chunk, ChunkEventType.PRE_LOAD);
            this.isAsync = isAsync;
            this.requester = requester;
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        public Player getRequester() {
            return this.requester;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancel) {
            this.cancelled = cancel;
        }
    }

    public static class ChunkUnloadEvent
    extends ChunkEvent
    implements Cancellable {
        private boolean cancelled = false;
        private final UnloadReason reason;

        public ChunkUnloadEvent(Chunk chunk, UnloadReason reason) {
            super(chunk, ChunkEventType.PRE_UNLOAD);
            this.reason = reason;
        }

        public UnloadReason getReason() {
            return this.reason;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancel) {
            this.cancelled = cancel;
        }

        public static enum UnloadReason {
            MANUAL,
            AUTOMATIC,
            OPTIMIZATION,
            MEMORY_PRESSURE,
            IDLE_TIMEOUT;

        }
    }

    public static class ChunkOptimizationEvent
    extends ChunkEvent {
        private final int chunksAffected;
        private final OptimizationType optimizationType;
        private final double performanceGain;

        public ChunkOptimizationEvent(Chunk chunk, OptimizationType type, int affected, double gain) {
            super(chunk, ChunkEventType.OPTIMIZATION_START);
            this.optimizationType = type;
            this.chunksAffected = affected;
            this.performanceGain = gain;
        }

        public OptimizationType getOptimizationType() {
            return this.optimizationType;
        }

        public int getChunksAffected() {
            return this.chunksAffected;
        }

        public double getPerformanceGain() {
            return this.performanceGain;
        }

        public static enum OptimizationType {
            ENTITY_CLEANUP,
            TILE_ENTITY_OPTIMIZATION,
            LIGHT_RECALCULATION,
            MEMORY_COMPACTION,
            REGION_MERGE;

        }
    }

    public static class ChunkHeatChangeEvent
    extends ChunkEvent {
        private final double oldHeat;
        private final double newHeat;
        private final HeatChangeReason reason;

        public ChunkHeatChangeEvent(Chunk chunk, double oldHeat, double newHeat, HeatChangeReason reason) {
            super(chunk, ChunkEventType.HEAT_CHANGE);
            this.oldHeat = oldHeat;
            this.newHeat = newHeat;
            this.reason = reason;
        }

        public double getOldHeat() {
            return this.oldHeat;
        }

        public double getNewHeat() {
            return this.newHeat;
        }

        public HeatChangeReason getReason() {
            return this.reason;
        }

        public static enum HeatChangeReason {
            PLAYER_ACTIVITY,
            ENTITY_SPAWN,
            REDSTONE_ACTIVITY,
            TIME_DECAY,
            MANUAL_ADJUSTMENT;

        }
    }
}

