/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.components.ChunkAnalyzer;
import cm.chunkManager.gui.GuiManager;
import cm.chunkManager.gui.MainMenu;
import cm.chunkManager.gui.Menu;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AnalyzerMenu
extends Menu {
    private final DecimalFormat df = new DecimalFormat("#.##");

    public AnalyzerMenu(ChunkManager plugin, Player player, GuiManager guiManager) {
        super(plugin, player, guiManager);
    }

    @Override
    public String getTitle() {
        return String.valueOf(ChatColor.YELLOW) + "Chunk Analyzer";
    }

    @Override
    public int getSize() {
        return 54;
    }

    @Override
    public void build() {
        if (!this.isAdvancedEnabled()) {
            this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Advanced Features Disabled", String.valueOf(ChatColor.GRAY) + "Enable in config.yml"), null);
            this.addNavigation();
            this.fillEmpty();
            return;
        }
        ChunkAnalyzer analyzer = this.plugin.getChunkAnalyzer();
        if (analyzer == null) {
            this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Analyzer Not Available", new String[0]), null);
            this.addNavigation();
            this.fillEmpty();
            return;
        }
        Chunk currentChunk = this.player.getLocation().getChunk();
        this.setItem(13, this.createItem(Material.COMPASS, String.valueOf(ChatColor.AQUA) + "Current Chunk", String.valueOf(ChatColor.WHITE) + "Location: [" + currentChunk.getX() + ", " + currentChunk.getZ() + "]", String.valueOf(ChatColor.GRAY) + "Click to analyze"), () -> {
            this.player.closeInventory();
            this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Analyzing chunk...");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                ChunkAnalyzer.ChunkAnalysisData data = analyzer.analyzeChunkSync(currentChunk);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk Analysis [" + currentChunk.getX() + ", " + currentChunk.getZ() + "]");
                    this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Complexity: " + data.complexity + " (" + data.getComplexityLevel() + ")");
                    this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Priority: " + data.priority + "/100");
                    this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Performance Impact: " + this.df.format(data.performanceImpact) + "%");
                    this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Memory: " + data.estimatedMemoryUsage / 1024 + " KB");
                    this.player.sendMessage(String.valueOf(ChatColor.RED) + "Entities: " + data.mobCount + " mobs, " + data.passiveEntityCount + " passive");
                    this.player.sendMessage(String.valueOf(ChatColor.GOLD) + "Tile Entities: " + data.tileEntityCount);
                });
            });
        });
        int slot = 19;
        for (World w : Bukkit.getWorlds()) {
            if (this.plugin.isWorldBlacklisted(w)) continue;
            if (slot >= 26) break;
            World targetWorld = w;
            this.setItem(slot++, this.createItem(Material.GRASS_BLOCK, String.valueOf(ChatColor.GREEN) + w.getName(), String.valueOf(ChatColor.GRAY) + "Click to analyze world"), () -> {
                this.player.closeInventory();
                this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Analyzing " + targetWorld.getName() + "...");
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    Map<String, Object> stats = analyzer.getWorldStatistics(targetWorld);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\n" + targetWorld.getName() + " Analysis:");
                        this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Total Chunks: " + String.valueOf(stats.get("totalChunks")));
                        this.player.sendMessage(String.valueOf(ChatColor.WHITE) + "Avg Complexity: " + this.df.format(stats.get("averageComplexity")));
                        this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "High Priority: " + String.valueOf(stats.get("highPriorityChunks")));
                        this.player.sendMessage(String.valueOf(ChatColor.RED) + "Total Mobs: " + String.valueOf(stats.get("totalMobs")));
                        this.player.sendMessage(String.valueOf(ChatColor.GOLD) + "Tile Entities: " + String.valueOf(stats.get("totalTileEntities")));
                        this.player.sendMessage(String.valueOf(ChatColor.AQUA) + "Memory: " + String.valueOf(stats.get("totalMemoryUsageMB")) + " MB");
                    });
                });
            });
        }
        this.addNavigation();
        this.fillEmpty();
    }

    private boolean isAdvancedEnabled() {
        try {
            return this.plugin.getConfig().getBoolean("advanced-features.enabled", true);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addNavigation() {
        this.setItem(45, this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back", new String[0]), () -> this.guiManager.openMenu(this.player, new MainMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(53, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]), () -> this.player.closeInventory());
    }

    private void fillEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), null);
        }
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

