/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.gui.MainMenu;
import cm.chunkManager.gui.Menu;
import cm.chunkManager.gui.StatsMenu;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GuiManager
implements Listener {
    private final ChunkManager plugin;
    private final Map<UUID, Menu> openMenus;
    private final Map<UUID, BukkitTask> updateTasks;
    private final Map<UUID, Long> navigationCooldown;

    public GuiManager(ChunkManager plugin) {
        this.plugin = plugin;
        this.openMenus = new ConcurrentHashMap<UUID, Menu>();
        this.updateTasks = new ConcurrentHashMap<UUID, BukkitTask>();
        this.navigationCooldown = new ConcurrentHashMap<UUID, Long>();
    }

    public void openMainMenu(Player player) {
        this.openMenu(player, new MainMenu(this.plugin, player, this));
    }

    public void openMenu(Player player, Menu menu) {
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        Long lastNav = this.navigationCooldown.get(uuid);
        if (lastNav != null && now - lastNav < 100L) {
            return;
        }
        this.navigationCooldown.put(uuid, now);
        this.stopAutoUpdate(uuid);
        this.openMenus.remove(uuid);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.openMenus.put(uuid, menu);
            menu.open();
            this.startAutoUpdate(player, menu);
        }, 1L);
    }

    public void closeMenu(Player player) {
        UUID uuid = player.getUniqueId();
        this.openMenus.remove(uuid);
        this.stopAutoUpdate(uuid);
    }

    private void startAutoUpdate(Player player, Menu menu) {
        UUID uuid = player.getUniqueId();
        this.stopAutoUpdate(uuid);
        if (!(menu instanceof StatsMenu)) {
            return;
        }
        int interval = this.plugin.getConfig().getInt("gui.update-interval", 20);
        if (interval < 10) {
            interval = 20;
        }
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            Menu currentMenu = this.openMenus.get(uuid);
            if (currentMenu instanceof StatsMenu && player.isOnline()) {
                currentMenu.refresh();
            } else {
                this.stopAutoUpdate(uuid);
            }
        }, (long)interval, (long)interval);
        this.updateTasks.put(uuid, task);
    }

    private void stopAutoUpdate(UUID uuid) {
        BukkitTask task = this.updateTasks.remove(uuid);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Menu menu = this.openMenus.get(player.getUniqueId());
        if (menu == null) {
            return;
        }
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!event.getClickedInventory().equals((Object)event.getView().getTopInventory())) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= menu.getSize()) {
            return;
        }
        menu.handleClick(slot);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.openMenus.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID uuid = player.getUniqueId();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!this.openMenus.containsKey(uuid)) {
                this.stopAutoUpdate(uuid);
                this.navigationCooldown.remove(uuid);
            }
        }, 2L);
    }

    public void shutdown() {
        this.updateTasks.values().forEach(task -> {
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
        });
        this.updateTasks.clear();
        this.openMenus.clear();
        this.navigationCooldown.clear();
    }
}

