/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiUtils {
    public static ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack filler() {
        return GuiUtils.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
    }

    public static ItemStack backButton() {
        return GuiUtils.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back", new String[0]);
    }

    public static ItemStack closeButton() {
        return GuiUtils.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]);
    }

    public static ChatColor getPerformanceColor(double value, double good, double warn, double poor) {
        if (value >= good) {
            return ChatColor.GREEN;
        }
        if (value >= warn) {
            return ChatColor.YELLOW;
        }
        if (value >= poor) {
            return ChatColor.GOLD;
        }
        return ChatColor.RED;
    }

    public static ChatColor getMemoryColor(double percentage) {
        if (percentage > 80.0) {
            return ChatColor.RED;
        }
        if (percentage > 60.0) {
            return ChatColor.YELLOW;
        }
        return ChatColor.GREEN;
    }
}

