/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.gui.AnalyzerMenu;
import cm.chunkManager.gui.GuiManager;
import cm.chunkManager.gui.Menu;
import cm.chunkManager.gui.RegionMenu;
import cm.chunkManager.gui.SettingsMenu;
import cm.chunkManager.gui.StatsMenu;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MainMenu
extends Menu {
    public MainMenu(ChunkManager plugin, Player player, GuiManager guiManager) {
        super(plugin, player, guiManager);
    }

    @Override
    public String getTitle() {
        return String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.BOLD) + "ChunkManager";
    }

    @Override
    public int getSize() {
        return 27;
    }

    @Override
    public void build() {
        this.setItem(10, this.createItem(Material.DIAMOND, String.valueOf(ChatColor.AQUA) + "Performance Stats", String.valueOf(ChatColor.GRAY) + "View server performance", String.valueOf(ChatColor.GRAY) + "and chunk statistics"), () -> this.guiManager.openMenu(this.player, new StatsMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(12, this.createItem(Material.REDSTONE, String.valueOf(ChatColor.GOLD) + "Settings", String.valueOf(ChatColor.GRAY) + "Configure chunk", String.valueOf(ChatColor.GRAY) + "management settings"), () -> this.guiManager.openMenu(this.player, new SettingsMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(14, this.createItem(Material.GRASS_BLOCK, String.valueOf(ChatColor.GREEN) + "Regions", String.valueOf(ChatColor.GRAY) + "View region activity", String.valueOf(ChatColor.GRAY) + "and optimization data"), () -> this.guiManager.openMenu(this.player, new RegionMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(16, this.createItem(Material.COMPASS, String.valueOf(ChatColor.YELLOW) + "Chunk Analyzer", String.valueOf(ChatColor.GRAY) + "Analyze chunk complexity", String.valueOf(ChatColor.GRAY) + "and performance impact"), () -> this.guiManager.openMenu(this.player, new AnalyzerMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]), () -> this.player.closeInventory());
        this.fillEmpty();
    }

    private void fillEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), null);
        }
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

