/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.gui.GuiManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Menu
implements InventoryHolder {
    protected final ChunkManager plugin;
    protected final Player player;
    protected final GuiManager guiManager;
    protected Inventory inv;
    protected final Map<Integer, Runnable> actions;

    public Menu(ChunkManager plugin, Player player, GuiManager guiManager) {
        this.plugin = plugin;
        this.player = player;
        this.guiManager = guiManager;
        this.actions = new ConcurrentHashMap<Integer, Runnable>();
    }

    public abstract void build();

    public abstract String getTitle();

    public abstract int getSize();

    protected void create() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)this.getTitle());
    }

    protected void setItem(int slot, ItemStack item, Runnable action) {
        if (this.inv == null || slot < 0 || slot >= this.getSize()) {
            return;
        }
        this.inv.setItem(slot, item);
        if (action != null) {
            this.actions.put(slot, action);
        } else {
            this.actions.remove(slot);
        }
    }

    public void open() {
        if (this.inv == null) {
            this.create();
        }
        this.actions.clear();
        this.inv.clear();
        this.build();
        this.player.openInventory(this.inv);
    }

    public void refresh() {
        if (this.inv == null || !this.player.isOnline()) {
            return;
        }
        this.actions.clear();
        this.inv.clear();
        this.build();
    }

    public void handleClick(int slot) {
        Runnable action = this.actions.get(slot);
        if (action != null) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, action);
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

