/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.components.RegionOptimizer;
import cm.chunkManager.gui.GuiManager;
import cm.chunkManager.gui.MainMenu;
import cm.chunkManager.gui.Menu;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RegionMenu
extends Menu {
    public RegionMenu(ChunkManager plugin, Player player, GuiManager guiManager) {
        super(plugin, player, guiManager);
    }

    @Override
    public String getTitle() {
        return String.valueOf(ChatColor.GREEN) + "Region Stats";
    }

    @Override
    public int getSize() {
        return 54;
    }

    @Override
    public void build() {
        if (!this.isAdvancedEnabled()) {
            this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Advanced Features Disabled", String.valueOf(ChatColor.GRAY) + "Enable in config.yml"), null);
            this.addNavigation();
            this.fillEmpty();
            return;
        }
        RegionOptimizer regionOpt = this.plugin.getRegionOptimizer();
        if (regionOpt == null) {
            this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Region Optimizer Not Available", new String[0]), null);
            this.addNavigation();
            this.fillEmpty();
            return;
        }
        int slot = 10;
        for (World world : Bukkit.getWorlds()) {
            if (this.plugin.isWorldBlacklisted(world)) continue;
            if (slot >= 35) break;
            Map<String, Object> stats = regionOpt.getRegionStatistics(world);
            Material mat = Material.GRASS_BLOCK;
            ChatColor nameColor = ChatColor.GREEN;
            int highActivity = (Integer)stats.getOrDefault("highActivityRegions", 0);
            if (highActivity > 10) {
                mat = Material.REDSTONE_BLOCK;
                nameColor = ChatColor.RED;
            } else if (highActivity > 5) {
                mat = Material.GOLD_BLOCK;
                nameColor = ChatColor.GOLD;
            }
            this.setItem(slot++, this.createItem(mat, String.valueOf(nameColor) + world.getName(), String.valueOf(ChatColor.WHITE) + "Total Regions: " + String.valueOf(stats.get("totalRegions")), String.valueOf(ChatColor.WHITE) + "Active: " + String.valueOf(stats.get("activeRegions")), String.valueOf(ChatColor.WHITE) + "Optimized: " + String.valueOf(stats.get("optimizedRegions")), String.valueOf(ChatColor.YELLOW) + "High Activity: " + String.valueOf(stats.get("highActivityRegions"))), null);
        }
        this.addNavigation();
        this.fillEmpty();
    }

    private boolean isAdvancedEnabled() {
        try {
            return this.plugin.getConfig().getBoolean("advanced-features.enabled", true);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addNavigation() {
        this.setItem(45, this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back", new String[0]), () -> this.guiManager.openMenu(this.player, new MainMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(53, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]), () -> this.player.closeInventory());
    }

    private void fillEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), null);
        }
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

