/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.gui.GuiManager;
import cm.chunkManager.gui.MainMenu;
import cm.chunkManager.gui.Menu;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SettingsMenu
extends Menu {
    public SettingsMenu(ChunkManager plugin, Player player, GuiManager guiManager) {
        super(plugin, player, guiManager);
    }

    @Override
    public String getTitle() {
        return String.valueOf(ChatColor.GOLD) + "Settings";
    }

    @Override
    public int getSize() {
        return 45;
    }

    @Override
    public void build() {
        boolean maintenanceMode = this.plugin.isMaintenanceMode();
        int radius = this.plugin.getConfigManager().getDynamicRadius();
        boolean dynamicRadius = this.plugin.getConfigManager().isDynamicRadiusEnabled();
        this.setItem(10, this.createItem(maintenanceMode ? Material.RED_CONCRETE : Material.LIME_CONCRETE, String.valueOf(ChatColor.YELLOW) + "Maintenance Mode", maintenanceMode ? String.valueOf(ChatColor.RED) + "Currently: ON" : String.valueOf(ChatColor.GREEN) + "Currently: OFF", String.valueOf(ChatColor.GRAY) + "Click to toggle"), () -> {
            this.plugin.setMaintenanceMode(!maintenanceMode);
            this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Maintenance mode " + (!maintenanceMode ? "enabled" : "disabled"));
            this.refresh();
        });
        this.setItem(12, this.createItem(Material.COMPARATOR, String.valueOf(ChatColor.AQUA) + "Chunk Radius", String.valueOf(ChatColor.WHITE) + "Current: " + radius, String.valueOf(ChatColor.GRAY) + "Manual adjustment disabled", String.valueOf(ChatColor.GRAY) + "Use dynamic radius instead"), null);
        this.setItem(14, this.createItem(dynamicRadius ? Material.LIME_DYE : Material.GRAY_DYE, String.valueOf(ChatColor.AQUA) + "Dynamic Radius", dynamicRadius ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled", String.valueOf(ChatColor.GRAY) + "Auto-adjusts based on", String.valueOf(ChatColor.GRAY) + "server performance"), null);
        this.setItem(16, this.createItem(Material.REDSTONE_TORCH, String.valueOf(ChatColor.GOLD) + "Force Optimize", String.valueOf(ChatColor.GRAY) + "Unload cold chunks", String.valueOf(ChatColor.GRAY) + "and clean cache"), () -> {
            this.player.closeInventory();
            Bukkit.dispatchCommand((CommandSender)this.player, (String)"optimizechunks");
        });
        this.setItem(20, this.createItem(Material.ENDER_PEARL, String.valueOf(ChatColor.AQUA) + "Garbage Collection", String.valueOf(ChatColor.GRAY) + "Force memory cleanup", String.valueOf(ChatColor.YELLOW) + "May cause lag spike"), () -> {
            this.player.closeInventory();
            Bukkit.dispatchCommand((CommandSender)this.player, (String)"chunkgc");
        });
        this.setItem(22, this.createItem(Material.BOOK, String.valueOf(ChatColor.YELLOW) + "Reload Config", String.valueOf(ChatColor.GRAY) + "Reload configuration", String.valueOf(ChatColor.GRAY) + "from config.yml"), () -> {
            this.plugin.reloadConfiguration();
            this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded!");
            this.refresh();
        });
        this.setItem(24, this.createItem(Material.WRITABLE_BOOK, String.valueOf(ChatColor.AQUA) + "Language", String.valueOf(ChatColor.WHITE) + "Current: " + this.plugin.getConfigManager().getLanguage(), String.valueOf(ChatColor.GRAY) + "Change plugin language"), () -> {
            this.player.closeInventory();
            this.player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use: /chunklang <code>");
        });
        this.setItem(36, this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back", new String[0]), () -> this.guiManager.openMenu(this.player, new MainMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(44, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]), () -> this.player.closeInventory());
        this.fillEmpty();
    }

    private void fillEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), null);
        }
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

