/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.gui;

import cm.chunkManager.ChunkManager;
import cm.chunkManager.components.PerformanceMonitor;
import cm.chunkManager.gui.GuiManager;
import cm.chunkManager.gui.MainMenu;
import cm.chunkManager.gui.Menu;
import cm.chunkManager.utils.MemoryManager;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StatsMenu
extends Menu {
    private final DecimalFormat df = new DecimalFormat("#.##");

    public StatsMenu(ChunkManager plugin, Player player, GuiManager guiManager) {
        super(plugin, player, guiManager);
    }

    @Override
    public String getTitle() {
        return String.valueOf(ChatColor.AQUA) + "Performance Stats";
    }

    @Override
    public int getSize() {
        return 54;
    }

    @Override
    public void build() {
        PerformanceMonitor perfMon = this.plugin.getPerformanceMonitor();
        MemoryManager memMgr = this.plugin.getMemoryManager();
        double tickTime = perfMon.getAverageTickTime();
        double tps = tickTime > 50.0 ? Math.max(0.0, 20.0 - (tickTime - 50.0) / 50.0) : 20.0;
        MemoryManager.MemoryStats memStats = memMgr.getMemoryStats();
        Map<String, String> info = perfMon.getPerformanceInfo();
        ChatColor tpsColor = tps >= 19.0 ? ChatColor.GREEN : (tps >= 17.0 ? ChatColor.YELLOW : ChatColor.RED);
        this.setItem(10, this.createItem(Material.CLOCK, String.valueOf(ChatColor.AQUA) + "Server Performance", String.valueOf(tpsColor) + "TPS: " + this.df.format(tps) + "/20.0", String.valueOf(ChatColor.GRAY) + "Tick Time: " + this.df.format(tickTime) + "ms", String.valueOf(ChatColor.GRAY) + "Target: 50ms"), null);
        ChatColor memColor = memStats.usagePercentage > 80.0 ? ChatColor.RED : (memStats.usagePercentage > 60.0 ? ChatColor.YELLOW : ChatColor.GREEN);
        this.setItem(12, this.createItem(Material.REDSTONE, String.valueOf(memColor) + "Memory Usage", String.valueOf(ChatColor.WHITE) + this.df.format(memStats.usedMB) + "/" + this.df.format(memStats.maxMB) + " MB", String.valueOf(ChatColor.GRAY) + "Usage: " + this.df.format(memStats.usagePercentage) + "%"), null);
        this.setItem(14, this.createItem(Material.CHEST, String.valueOf(ChatColor.AQUA) + "Chunk Cache", String.valueOf(ChatColor.WHITE) + "Queue: " + this.plugin.getChunkCache().getQueueSize(), String.valueOf(ChatColor.WHITE) + "Kept Loaded: " + this.plugin.getChunkCache().getKeepLoadedSize(), String.valueOf(ChatColor.GRAY) + "Cache Size: " + this.plugin.getConfigManager().getMaxCacheSize()), null);
        this.setItem(16, this.createItem(Material.PLAYER_HEAD, String.valueOf(ChatColor.AQUA) + "Players & Chunks", String.valueOf(ChatColor.WHITE) + "Players: " + info.get("online_players"), String.valueOf(ChatColor.WHITE) + "Total Chunks: " + info.get("total_chunks"), String.valueOf(ChatColor.GRAY) + "Radius: " + this.plugin.getConfigManager().getDynamicRadius()), null);
        if (this.plugin.isMaintenanceMode()) {
            this.setItem(22, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Maintenance Mode", String.valueOf(ChatColor.YELLOW) + "Currently Active", String.valueOf(ChatColor.GRAY) + "Reduced chunk loading"), null);
        }
        int worldSlot = 28;
        for (World world : Bukkit.getWorlds()) {
            if (this.plugin.isWorldBlacklisted(world) || worldSlot >= 35) continue;
            int chunks = world.getLoadedChunks().length;
            int entities = world.getEntities().size();
            this.setItem(worldSlot++, this.createItem(Material.GRASS_BLOCK, String.valueOf(ChatColor.GREEN) + world.getName(), String.valueOf(ChatColor.WHITE) + "Chunks: " + chunks, String.valueOf(ChatColor.WHITE) + "Entities: " + entities), null);
        }
        this.setItem(45, this.createItem(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Back", new String[0]), () -> this.guiManager.openMenu(this.player, new MainMenu(this.plugin, this.player, this.guiManager)));
        this.setItem(53, this.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Close", new String[0]), () -> this.player.closeInventory());
        this.fillEmpty();
    }

    private void fillEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.inv.getItem(i) != null) continue;
            this.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), null);
        }
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

