/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class ChunkDataPool {
    private final Queue<ChunkData> pool = new ConcurrentLinkedQueue<ChunkData>();
    private final AtomicInteger createdCount = new AtomicInteger(0);
    private final int maxPoolSize;

    public ChunkDataPool(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        for (int i = 0; i < maxPoolSize / 2; ++i) {
            this.pool.offer(new ChunkData());
            this.createdCount.incrementAndGet();
        }
    }

    public ChunkData acquire() {
        ChunkData data = this.pool.poll();
        if (data == null) {
            data = new ChunkData();
            this.createdCount.incrementAndGet();
        }
        return data;
    }

    public void release(ChunkData data) {
        if (data != null && this.pool.size() < this.maxPoolSize) {
            data.reset();
            this.pool.offer(data);
        }
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public int getTotalCreated() {
        return this.createdCount.get();
    }

    public void clear() {
        this.pool.clear();
    }

    public static class ChunkData {
        public int x;
        public int z;
        public String worldName;
        public long timestamp;
        public boolean isActive;

        public void reset() {
            this.x = 0;
            this.z = 0;
            this.worldName = null;
            this.timestamp = 0L;
            this.isActive = false;
        }

        public void set(Chunk chunk) {
            this.x = chunk.getX();
            this.z = chunk.getZ();
            this.worldName = chunk.getWorld().getName();
            this.timestamp = System.currentTimeMillis();
            this.isActive = true;
        }

        public void set(int x, int z, String worldName) {
            this.x = x;
            this.z = z;
            this.worldName = worldName;
            this.timestamp = System.currentTimeMillis();
            this.isActive = true;
        }
    }

    public static class LocationData {
        public double x;
        public double y;
        public double z;
        public String worldName;

        public void reset() {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.worldName = null;
        }

        public void set(Location location) {
            this.x = location.getX();
            this.y = location.getY();
            this.z = location.getZ();
            this.worldName = location.getWorld().getName();
        }
    }
}

