/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.utils;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChunkUtils {
    private static Boolean paperAvailable = null;
    private static Method getChunkAtAsyncMethod = null;

    private ChunkUtils() {
    }

    public static boolean isPaperServer() {
        if (paperAvailable == null) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                paperAvailable = true;
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("io.papermc.paper.configuration.Configuration");
                    paperAvailable = true;
                }
                catch (ClassNotFoundException e2) {
                    paperAvailable = false;
                }
            }
        }
        return paperAvailable;
    }

    public static CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, JavaPlugin plugin) {
        if (ChunkUtils.isPaperServer()) {
            try {
                if (getChunkAtAsyncMethod == null) {
                    getChunkAtAsyncMethod = World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
                }
                return (CompletableFuture)getChunkAtAsyncMethod.invoke((Object)world, x, z);
            }
            catch (Exception e) {
                return ChunkUtils.getChunkSync(world, x, z, plugin);
            }
        }
        return ChunkUtils.getChunkSync(world, x, z, plugin);
    }

    private static CompletableFuture<Chunk> getChunkSync(World world, int x, int z, JavaPlugin plugin) {
        CompletableFuture<Chunk> future = new CompletableFuture<Chunk>();
        if (plugin.getServer().isPrimaryThread()) {
            future.complete(world.getChunkAt(x, z));
        } else {
            plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> future.complete(world.getChunkAt(x, z)));
        }
        return future;
    }

    public static void loadChunkAsync(World world, int x, int z, JavaPlugin plugin, Runnable callback) {
        ChunkUtils.getChunkAtAsync(world, x, z, plugin).thenRun(() -> {
            if (callback != null) {
                plugin.getServer().getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }
}

