/*
 * Decompiled with CFR 0.152.
 */
package cm.chunkManager.utils;

import cm.chunkManager.utils.ChunkDataPool;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class MemoryManager {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final ChunkDataPool chunkDataPool;
    private final AtomicLong lastGCTime = new AtomicLong(0L);
    private final long minGCInterval = 30000L;
    private volatile boolean lowMemoryMode = false;
    private final double lowMemoryThreshold = 0.85;
    private final double criticalMemoryThreshold = 0.95;

    public MemoryManager(JavaPlugin plugin, int poolSize) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.chunkDataPool = new ChunkDataPool(poolSize);
        this.registerMemoryNotifications();
    }

    private void registerMemoryNotifications() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : pools) {
            long maxMemory;
            if (!pool.getType().toString().equals("HEAP") || !pool.isUsageThresholdSupported() || (maxMemory = pool.getUsage().getMax()) <= 0L) continue;
            pool.setUsageThreshold((long)((double)maxMemory * 0.85));
        }
    }

    public boolean isLowMemoryMode() {
        return this.lowMemoryMode;
    }

    public void checkMemoryStatus() {
        double usagePercentage = this.getMemoryUsagePercentage();
        if (usagePercentage > 0.95) {
            this.logger.warning("Critical memory usage detected: " + String.format("%.2f%%", usagePercentage * 100.0));
            this.forceGarbageCollection();
            this.lowMemoryMode = true;
        } else if (usagePercentage > 0.85) {
            if (!this.lowMemoryMode) {
                this.logger.info("Entering low memory mode: " + String.format("%.2f%%", usagePercentage * 100.0));
                this.lowMemoryMode = true;
            }
        } else if (this.lowMemoryMode && usagePercentage < 0.7) {
            this.logger.info("Exiting low memory mode: " + String.format("%.2f%%", usagePercentage * 100.0));
            this.lowMemoryMode = false;
        }
    }

    public double getMemoryUsagePercentage() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return (double)usedMemory / (double)maxMemory;
    }

    public void requestGarbageCollection() {
        long lastGC;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastGC = this.lastGCTime.get()) > 30000L && this.lastGCTime.compareAndSet(lastGC, currentTime)) {
            System.gc();
            this.logger.fine("Garbage collection requested");
        }
    }

    public void forceGarbageCollection() {
        System.gc();
        System.runFinalization();
        this.lastGCTime.set(System.currentTimeMillis());
        this.logger.info("Forced garbage collection executed");
    }

    public ChunkDataPool getChunkDataPool() {
        return this.chunkDataPool;
    }

    public MemoryStats getMemoryStats() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return new MemoryStats((double)usedMemory / 1048576.0, (double)totalMemory / 1048576.0, (double)maxMemory / 1048576.0, (double)freeMemory / 1048576.0, this.getMemoryUsagePercentage() * 100.0);
    }

    public void cleanup() {
        this.chunkDataPool.clear();
    }

    public static class MemoryStats {
        public final double usedMB;
        public final double totalMB;
        public final double maxMB;
        public final double freeMB;
        public final double usagePercentage;

        public MemoryStats(double usedMB, double totalMB, double maxMB, double freeMB, double usagePercentage) {
            this.usedMB = usedMB;
            this.totalMB = totalMB;
            this.maxMB = maxMB;
            this.freeMB = freeMB;
            this.usagePercentage = usagePercentage;
        }
    }
}

