/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import java.util.List;
import net.minecraft.network.Varint21FrameDecoder;
import one.pkg.mod.krypton_fnp.shared.network.VarIntByteDecoder;
import one.pkg.mod.krypton_fnp.shared.network.util.WellKnownExceptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={Varint21FrameDecoder.class})
public class Varint21FrameDecoderMixin {
    private final VarIntByteDecoder reader = new VarIntByteDecoder();

    @Overwrite
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        this.reader.reset();
        int varintEnd = in.forEachByte((ByteProcessor)this.reader);
        if (varintEnd == -1) {
            if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
                in.clear();
            }
            return;
        }
        if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
            in.readerIndex(varintEnd);
        } else if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.SUCCESS) {
            int readVarint = this.reader.getReadVarint();
            int bytesRead = this.reader.getBytesRead();
            if (readVarint < 0) {
                in.clear();
                throw WellKnownExceptions.BAD_LENGTH_CACHED;
            }
            if (readVarint == 0) {
                in.readerIndex(varintEnd + 1);
            } else {
                int minimumRead = bytesRead + readVarint;
                if (in.isReadable(minimumRead)) {
                    out.add(in.retainedSlice(varintEnd + 1, readVarint));
                    in.skipBytes(minimumRead);
                }
            }
        } else if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.TOO_BIG) {
            in.clear();
            throw WellKnownExceptions.VARINT_BIG_CACHED;
        }
    }
}

