/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import java.util.List;
import me.steinborn.krypton.mod.shared.network.util.WellKnownExceptions;
import net.minecraft.network.Varint21FrameDecoder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Varint21FrameDecoder.class})
public class SplitterHandlerMixin {
    @Overwrite
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        int packetStart = in.forEachByte(ByteProcessor.FIND_NON_NUL);
        if (packetStart == -1) {
            in.clear();
            return;
        }
        in.readerIndex(packetStart);
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = SplitterHandlerMixin.krypton_Multi$readRawVarInt21(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (length < 0) {
            throw WellKnownExceptions.BAD_LENGTH_CACHED;
        }
        if (length > 0) {
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                out.add(in.readRetainedSlice(length));
            }
        }
    }

    @Unique
    private static int krypton_Multi$readRawVarInt21(ByteBuf buffer) {
        if (buffer.readableBytes() < 4) {
            return SplitterHandlerMixin.krypton_Multi$readRawVarintSmallBuf(buffer);
        }
        int wholeOrMore = buffer.getIntLE(buffer.readerIndex());
        int atStop = ~wholeOrMore & 0x808080;
        if (atStop == 0) {
            throw WellKnownExceptions.VARINT_BIG_CACHED;
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(atStop) + 1;
        buffer.skipBytes(bitsToKeep >> 3);
        int preservedBytes = wholeOrMore & (atStop ^ atStop - 1);
        preservedBytes = preservedBytes & 0x7F007F | (preservedBytes & 0x7F00) >> 1;
        preservedBytes = preservedBytes & 0x3FFF | (preservedBytes & 0x3FFF0000) >> 2;
        return preservedBytes;
    }

    @Unique
    private static int krypton_Multi$readRawVarintSmallBuf(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return result | (tmp & 0x7F) << 14;
    }
}

