/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.experimental;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.VarLong;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VarLong.class}, priority=900)
public class VarLongMixin {
    @Unique
    private static final int DATA_BITS_PER_BYTE = 7;

    @Unique
    private static boolean krypton_Multi$hasContinuationBit(byte data) {
        return (data & 0x80) != 0;
    }

    @Overwrite
    public static int getByteSize(long data) {
        if (data == 0L) {
            return 1;
        }
        int significantBits = 64 - Long.numberOfLeadingZeros(data);
        return (significantBits + 7 - 1) / 7;
    }

    @Overwrite
    public static long read(ByteBuf buffer) {
        byte currentByte;
        long result = 0L;
        int bytesRead = 0;
        do {
            if (bytesRead >= 10) {
                throw new RuntimeException("VarLong too big");
            }
            currentByte = buffer.readByte();
            result |= (long)(currentByte & 0x7F) << bytesRead * 7;
            ++bytesRead;
        } while (VarLongMixin.krypton_Multi$hasContinuationBit(currentByte));
        return result;
    }
}

