/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.pipeline.encryption;

import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import me.steinborn.krypton.mod.shared.misc.KryptonPipelineEvent;
import me.steinborn.krypton.mod.shared.network.ClientConnectionEncryptionExtension;
import me.steinborn.krypton.mod.shared.network.pipeline.MinecraftCipherDecoder;
import me.steinborn.krypton.mod.shared.network.pipeline.MinecraftCipherEncoder;
import net.minecraft.network.Connection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Connection.class})
public class ClientConnectionMixin
implements ClientConnectionEncryptionExtension {
    @Shadow
    private boolean encrypted;
    @Shadow
    private Channel channel;

    @Override
    public void setupEncryption(SecretKey key) throws GeneralSecurityException {
        if (!this.encrypted) {
            VelocityCipher decryption = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
            VelocityCipher encryption = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
            this.encrypted = true;
            this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new MinecraftCipherDecoder(decryption));
            this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new MinecraftCipherEncoder(encryption));
            this.channel.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.ENCRYPTION_ENABLED);
        }
    }
}

