/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mod.shared.network.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.Mth;

public class VarIntUtil {
    public static final int MASK_7_BITS = -128;
    public static final int MASK_14_BITS = -16384;
    public static final int MASK_21_BITS = -2097152;
    public static final int MASK_28_BITS = -268435456;
    private static final int[] VARINT_EXACT_BYTE_LENGTHS = new int[33];

    public static int getVarIntLength(int value) {
        return VARINT_EXACT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(value)];
    }

    public static void writeVarIntFull0210(ByteBuf buf, int value) {
        if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            buf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            buf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            buf.writeInt(w);
            buf.writeByte(value >>> 28);
        }
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            VarIntUtil.VARINT_EXACT_BYTE_LENGTHS[i] = Mth.ceil((double)((31.0 - (double)(i - 1)) / 7.0));
        }
        VarIntUtil.VARINT_EXACT_BYTE_LENGTHS[32] = 1;
    }
}

