/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import java.util.List;
import net.minecraft.network.Varint21FrameDecoder;
import one.pkg.mod.krypton_fnp.shared.network.VarIntByteDecoder;
import one.pkg.mod.krypton_fnp.shared.network.util.WellKnownExceptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Varint21FrameDecoder.class})
public class Varint21FrameDecoderMixin {
    @Unique
    private final VarIntByteDecoder krypton_FNP$reader = new VarIntByteDecoder();

    @Overwrite
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        this.krypton_FNP$reader.reset();
        int varintEnd = in.forEachByte((ByteProcessor)this.krypton_FNP$reader);
        if (varintEnd == -1) {
            if (this.krypton_FNP$reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
                in.clear();
            }
            return;
        }
        if (this.krypton_FNP$reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
            in.readerIndex(varintEnd);
        } else if (this.krypton_FNP$reader.getResult() == VarIntByteDecoder.DecodeResult.SUCCESS) {
            int readVarint = this.krypton_FNP$reader.getReadVarint();
            int bytesRead = this.krypton_FNP$reader.getBytesRead();
            if (readVarint < 0) {
                in.clear();
                throw WellKnownExceptions.BAD_LENGTH_CACHED;
            }
            if (readVarint == 0) {
                in.readerIndex(varintEnd + 1);
            } else {
                int minimumRead = bytesRead + readVarint;
                if (in.isReadable(minimumRead)) {
                    out.add(in.retainedSlice(varintEnd + 1, readVarint));
                    in.skipBytes(minimumRead);
                }
            }
        } else if (this.krypton_FNP$reader.getResult() == VarIntByteDecoder.DecodeResult.TOO_BIG) {
            in.clear();
            throw WellKnownExceptions.VARINT_BIG_CACHED;
        }
    }
}

