/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.pipeline.compression;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.CompressionEncoder;
import net.minecraft.network.Connection;
import one.pkg.mod.krypton_fnp.shared.misc.KryptonPipelineEvent;
import one.pkg.mod.krypton_fnp.shared.network.compression.MinecraftCompressDecoder;
import one.pkg.mod.krypton_fnp.shared.network.compression.MinecraftCompressEncoder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class ConnectionMixin {
    @Shadow
    private Channel f_129468_;

    @Unique
    private static boolean kryptonfnp$isKryptonOrVanillaDecompressor(Object o) {
        return o instanceof CompressionEncoder || o instanceof MinecraftCompressDecoder;
    }

    @Unique
    private static boolean kryptonfnp$isKryptonOrVanillaCompressor(Object o) {
        return o instanceof CompressionDecoder || o instanceof MinecraftCompressEncoder;
    }

    @Inject(method={"setupCompression"}, at={@At(value="HEAD")}, cancellable=true)
    public void setCompressionThreshold(int compressionThreshold, boolean validate, CallbackInfo ci) {
        if (compressionThreshold < 0) {
            if (ConnectionMixin.kryptonfnp$isKryptonOrVanillaDecompressor(this.f_129468_.pipeline().get("decompress"))) {
                this.f_129468_.pipeline().remove("decompress");
            }
            if (ConnectionMixin.kryptonfnp$isKryptonOrVanillaCompressor(this.f_129468_.pipeline().get("compress"))) {
                this.f_129468_.pipeline().remove("compress");
            }
            this.f_129468_.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_DISABLED);
        } else {
            MinecraftCompressDecoder decoder = (MinecraftCompressDecoder)this.f_129468_.pipeline().get("decompress");
            MinecraftCompressEncoder encoder = (MinecraftCompressEncoder)this.f_129468_.pipeline().get("compress");
            if (decoder != null && encoder != null) {
                decoder.setThreshold(compressionThreshold);
                encoder.setThreshold(compressionThreshold);
                this.f_129468_.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_THRESHOLD_UPDATED);
            } else {
                VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(4);
                encoder = new MinecraftCompressEncoder(compressionThreshold, compressor);
                decoder = new MinecraftCompressDecoder(compressionThreshold, validate, compressor);
                this.f_129468_.pipeline().addBefore("decoder", "decompress", (ChannelHandler)decoder);
                this.f_129468_.pipeline().addBefore("encoder", "compress", (ChannelHandler)encoder);
                this.f_129468_.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_ENABLED);
            }
        }
        ci.cancel();
    }
}

